/* FILE:    armSensor.h
   AUTHOR:  Michael Wagner
   CREATED: Aug 19, 1999

   DESCRIPTION: This file defines the sensor driver for
     Nomad's manipulator arm, armSensor. This class
     is inhereted from the virtual class sensor.h
*/

#ifndef __ARM_SENSOR_H__
#define __ARM_SENSOR_H__

#include "sensor.h"
#include "MeteoriteArmController.h"
#include "armCamImageScanner.h"
#include "armSensorDef.h"
#include "telemetryMsgs.h"
#include "armSensorTelemetryThread.h"
#include "spectrometer.h"
#include "metalDetector.h"

class armSensor : public sensor {
 public:
  armSensor(char *sensorID, char *DAQ_SaveFileNameBase);                        /* The constructor should simply instantiate 
										   objects and set class variables. */
  armSensor(char *sensorID, int boxSize, int pixSize, char *DAQ_SaveFileNameBase);  /* This constructor lets you set the 
										       armCamImageScanner parameters */
  ~armSensor();                                     /* The destructor should delete objects in 
						       the sensor driver class. Deleting the 
						       objects in this class should automatically 
						       call their respective uninit functions, to 
						       close serial ports and such. */
  
  // Implementing the sensor interface.
  sensorReply *startup(sensorRequest *req);         /* The startup function should initialize all 
						       subcomponents, and prepare the sensor for deployment. */
  sensorReply *calibration(sensorRequest *req);     /* The calibration function should be used to update 
						       internal state variables with correct values. */
  sensorReply *deployment(sensorRequest *req);      /* The deployment function should deploy the sensor to the 
						       target coordinates (request->targetPosition), given a 
						       current robot location and pose (request->robotPosition). */ 
  sensorReply *unDeployment(sensorRequest *req);    /* The unDeployment function should servo the sensor back 
						       to its startup state. */
  sensorReply *dataAcquisition(sensorRequest *req); /* The dataAcqusition function should simply capture data, 
						       calculate the appropriate file name in which to save this 
						       new data, and save it. */
  sensorReply *shutdown(sensorRequest *req);        /* The shutdown function should uninitialize the sensor but 
						       not delete any state information or internal variables. */ 
  sensorReply *diagnostic(sensorRequest *req);      /* The diagnostic function should run the sensor through a
						       number of tests to search for errors, and return the most
						       important error to the user. */
  sensorReply *targetAcq(sensorRequest *req);       /* The targetAcq function is used to get target acquisition
						       data. */
  sensorReply *toggleDebug(sensorRequest *req);     /* Switches sensor to debug mode. */

  sensorReply *getCost(sensorRequest *req);         /* Returns the sensor's costs */
  sensorReply *getWorkspace(sensorRequest *req);    /* Returns the sensor's workspace */
  sensorReply *getStatus(sensorRequest *req);       /* Just returns data in the status and extendedStatus fields 
						       of the reply, doesn't take any action */

 private:
  int debugMode;
  char *DAQ_SaveFileNameBase;
  armCamImageScanner *ims;
  MeteoriteArmController *arm;
  armSensorTelemetryThread *telThread;
  spectrometer *spectro;
  metalDetector *metal;
};

RTIBool teleopCallback(NDDSObjectInstance reply, NDDSObjectInstance request, void *userData);

#endif /* __ARM_SENSOR_H__ */
