#ifndef __ARM_CAM_IMAGE_SCANNER_H__
#define __ARM_CAM_IMAGE_SCANNER_H__

#include "ImageScanner.h"

#define DEFAULT_ARM_BOX_SIZE 5
#define DEFAULT_ARM_PIX_SIZE 200

class armCamImageScanner : public ImageScanner {
 public:
  armCamImageScanner() {
    this->boxSize = DEFAULT_ARM_BOX_SIZE;
    this->pixSize = DEFAULT_ARM_PIX_SIZE;
  }
  armCamImageScanner(int boxSize, int pixSize) {
    this->boxSize = boxSize;
    this->pixSize = pixSize;
  }

  r3Vector findRock(frameGrabber *grabber, int hres, int vres);
  int boxSize;
  int pixSize;
};

#endif /* __ARM_CAM_IMAGE_SCANNER_H__ */
