#include "PotLookUpTable.h"

double PotLookUpTable::getAngle(double potValue) {
  int potGuess;
  int potGuessp1;
  double dis,angle;
  if (potValue < potVals[0]) {
    //we have to extrapolate... deal with it.
  dis = (potValue-potVals[1])/(potVals[0]-potVals[1]);
  angle = encDegrees[1]+dis*(encDegrees[0]-encDegrees[1]);    
  return angle;
  } else if ( potValue > potVals[NUM_TABLE_ENTRIES-1]) {
    //we have to extrapolate... deal with it.
    dis = (potValue-potVals[NUM_TABLE_ENTRIES-2])/(potVals[NUM_TABLE_ENTRIES-1]-potVals[NUM_TABLE_ENTRIES-2]);
  angle = encDegrees[NUM_TABLE_ENTRIES-2]+dis*(encDegrees[NUM_TABLE_ENTRIES-1]-encDegrees[NUM_TABLE_ENTRIES-2]);
  return angle;
  }

  potValue*=sense; // make all readings increasing monotonic
  potGuess = (potValue-potVals[0]) /((potVals[NUM_TABLE_ENTRIES-1]-potVals[0])/(NUM_TABLE_ENTRIES-1)); 
  potGuessp1=potGuess+1;
  //  cerr << "geussing " << potGuess << "\n";
  // we guessed Too high
  if (potValue<potVals[potGuess]) {
    while (potValue<potVals[potGuess]) {
      //  cerr << "in guessed too low: " << potVals[potGuess] <<"\n";
      potGuess--;
      if (potGuessp1 <1) {
	potGuessp1=1;
	cerr << "Extrapolating-- THIS IS REALLY BAD!\n";
	break;
      }
    }
    potGuessp1=potGuess+1;
  } else if (potVals[potGuessp1]>potVals[potGuessp1]) {
    // we guessed to low
    while (potValue>potVals[potGuessp1]) {
      potGuessp1++;
      if (potGuess>(NUM_TABLE_ENTRIES-1)) {
	potGuess=(NUM_TABLE_ENTRIES-2);
	cerr << "Extrapolating--- THIS IS REALLY BAD!\n";
	break;
      }
    }
    potGuess =potGuessp1-1;
 
  }
  


  // we now have a pair of points to linearly interpolate between.
  dis = (potValue-potVals[potGuess])/(potVals[potGuessp1]-potVals[potGuess]);
  angle = encDegrees[potGuess]+dis*(encDegrees[potGuessp1]-encDegrees[potGuess]);
  return angle;
}


/*readIn-
  this stores values in the lookup table from a recorded data file
  the data file format is: (the file should be NUM_TABLE_ENTRIES+1 lines)
  sense
  potvalue,encDegrees
  potvalue, encDegrees
  ...
  ...
  potvalue, encDegrees
*/
void PotLookUpTable::readIn(char * ifname) { 
  char c; 
  int i;
  ifstream in(ifname);
  in >> sense;
  for (i=0;i<NUM_TABLE_ENTRIES;i++) {
    in >> potVals[i] >> c >> encDegrees[i];
    //    cerr << potVals[i] << " " << encDegrees[i] << "\n";
  }
  in.close();
  cerr << "[POTLOOKUPTABLE] Completed loading of table\n";
}

void PotLookUpTable::writeOut(char *ofname) {
  int i;
  ofstream out(ofname);

  if (sense >0) {
    out << 1 <<'\n';
    for (i=0;i<NUM_TABLE_ENTRIES;i++) {
      out << potVals[i] << ',' << encDegrees[i] << '\n';
    }
  } else {
    out << 1 << '\n';
    for (i=NUM_TABLE_ENTRIES-1;i>-1;i--) {
      out << potVals[i] << ',' << encDegrees[i] << '\n';
    }
  }
    out.close();
  cerr << "[POTLOOKUPTABLE] Completed writing table\n";
}

void PotLookUpTable::record(ElectronicsInterface *ei, char *ofname, int axis, int sense) {
  int i;
  char c;
  double  lowerBound[4] ={0,-3,0,-63};
  double  upperBound[4] = {183,183,50,63};
  int s=0;
  ei->sendCommand("RS");
  ei->sendCommand("MO");
  cerr << "please put joint " << axis+1 << " at the zero degree position\n";
  while (c!='c') {
    cerr << "press c[enter] to continue, q[enter] to quit \n";
    cin >> c;
    if (c=='q') {
      cerr << "Quitting without recording a look up table\n";
      return;
    }
  }
  while (!(s==1 || s==-1)) {
    cerr << "please enter sense of axis (+1 or -1)\n";
    cin >> s;
  }
  sense = s;
  cerr << "sense is : " << sense << "\n";
  ei->initialize();
  potVals[0] = ei->queryPotValue(axis);
  encDegrees[0] = 0;
  for (i=1;i<NUM_TABLE_ENTRIES;i++) {
    cerr << "moving to " << lowerBound[axis]+(i)*(upperBound[axis]-lowerBound[axis]+1)/(NUM_TABLE_ENTRIES) <<"\n";
     ei->moveToAndWait(axis,lowerBound[axis]+(i)*(upperBound[axis]-lowerBound[axis]+1)/(NUM_TABLE_ENTRIES) );
    potVals[i] = ei->queryPotValue(axis);
    encDegrees[i]= ei->queryEncPosition(axis);
    if (i==NUM_TABLE_ENTRIES/2 && axis==0) {
      
      ei->sendCommand("MOY");
      cerr << "please reposition the second link as necessary\n";
      c=';';
      while (c!='c') {
	cerr << "press c[enter] to continue I WILL START MOVING AGAIN\n";
	cin >> c;
      }
      ei->sendCommand("SHY");
    }
  }
 writeOut(ofname); 
}
  

    

      
  
