#ifndef __JOINT_LIMIT
#define __JOINT_LIMIT
/*This code was written by Chris Urmson                                     *
 *please contact me with any problems, quesetions, random insults...        *
 *curmson@ri.cmu.edu                                                        *
 *or at 268-8919.                                                           *
 *                                                                          */

/*This file provides a simple class to implement joint limits 
 */

/*this routine forces an angle to be between +-180 degrees */
double fixAngle(double angle);


class JointLimit {
private:
  double min, max;
 
public:
  /*This creates a joint limit object with the given 
    minimum and maximum*/
  JointLimit(double minimum, double maximum);
 
 /* inRange- this is used to check if an angle is within range for 
     a joint
     returns:
     0 - if the angle is out of range
     nonzero - if the angle is within range
     */
  int inRange(double angle);

  /* limit- this returns an angle within range, if the given angle is
     larger than the maximum then it returns the maximum, if it is smaller 
     than the minimum it returns the minimum, otherwise it returns the 
     argument.
     */
  double limit(double angle);
  
};



#endif __JOINT_LIMIT
