/*This code was written by Chris Urmson                                     *
 *please contact me with any problems, quesetions, random insults...        *
 *curmson@ri.cmu.edu                                                        *
 *or at 268-8919.                                                           *
 *                                                                          */

#include "JointLimit.h"


/*this routine forces an angle to be between +-180 degrees */
double fixAngle(double angle) {
  while (angle<-180) {
    angle+=360;
  }
  while (angle > 180) {
    angle-=360;
  }
  return angle;
}

/*This creates a joint limit object with the given 
  minimum and maximum*/
JointLimit::JointLimit(double minimum, double maximum) {
  min = minimum;
  max = maximum;
}

/* inRange- this is used to check if an angle is within range for 
     a joint
     returns:
     0 - if the angle is out of range
     nonzero - if the angle is within range
     */
int JointLimit::inRange(double angle) {
  if (angle >max) 
    return 0;
  if (angle< min)
    return 0;
  return 1;
}

  /* limit- this returns an angle within range, if the given angle is
     larger than the maximum then it returns the maximum, if it is smaller 
     than the minimum it returns the minimum, otherwise it returns the 
     argument.
     */
double JointLimit::limit(double angle) {
  if (angle > max) 
    return max;
  if (angle < min) 
    return min;
  else 
    return angle;
}
  
