/*This code was written by Chris Urmson                                     *
 *please contact me with any problems, quesetions, random insults...        *
 *curmson@ri.cmu.edu                                                        *
 *or at 268-8919.                                                           *
 *                                                                          */
#include <stdio.h>
#include <iostream.h>
#include <unistd.h>
#include "ElectronicsInterface.h"

/*the names of the axes given by the controller*/
char * axesNames[8] = {"A","B","C","D","E","F","G","H"};
/*these fix the motors so that they are the correct sense*/
int axesDirectionFix[8] = {-1,1,-1,1,1,1,1,1};
ElectronicsInterface::ElectronicsInterface(ostream * out, istream * in,
					   double *zeros, double * convs, double *analogConvs) {
  int i;
  output =out;
  input = in;
  for (i=0;i<MAXIMUM_AXES;i++) {
    axesZeroPositions[i]= zeros[i]; 
    countsPerDegree[i]=convs[i];
    //    potCountsPerDegree[i]=analogConvs[i];
    
  }
  
}


int ElectronicsInterface::sendCommand(char * command, int SHOW_CONTROLLER) {

  char c;
  int i;
  int numAllowedqs=0;
//SHOW_CONTROLLER =0;
  (*output) << command << "\r\n";
  //  cerr << "sent command " << command << "\n";
  (*input) >> c;

  if (SHOW_CONTROLLER) {
    cerr << "\"" << c; 
  }
  /* initially I just checked below for : or ?, that deliminated the end of a
     response from the controller, but I may want to send a ? so
     count how many I send and don't get more than that back.*/
  for (i=0;i<strlen(command);i++) {
    if (command[i]=='?') {
      numAllowedqs++;
    }
  }
  while (c!=':' && (numAllowedqs>=0)) { 
    /* eat away characters till we get to something we recognize*/
    (*input) >> c;
    if( SHOW_CONTROLLER) {
      cerr  << c;
    }
    if (c=='?') {
      numAllowedqs--;
    }
  }
  if (SHOW_CONTROLLER) {
    cerr << "\"\n";
  }
  if (c=='?') {
    cerr << "Command \"" << command << "\" was unable to be interpreted\n";
    cerr << "in ElectronicsInterface.cpp - sendCommand\n";
    return 0;
    
  } else {
    return 1;
  }
  
}

long ElectronicsInterface::queryCounts(int axis) {
  long position;
  char c;
  (*output) << "TP" << axesNames[axis] << "\r\n";
  (*input) >>c;
  (*input) >>c;
  (*input) >>c;
  (*input) >> position >> c;
  return position;
}

double ElectronicsInterface::queryEncPosition(int axis) {
  return convertCountsToAngle(axis,queryCounts(axis));
}

double ElectronicsInterface::queryPotValue(int axis) {
  double position;
  char c;
  int i;
  (*output) << "MG @AN[" << axis+1 << "]\r\n";
  for (i=0;i<8;i++) {
    (*input) >>c;
    //    cerr << c;
  }
  (*input) >> position >> c;
  //  cerr << position << c << "\n";
  return position;
}

double ElectronicsInterface::queryPotPosition(int axis) {
  return convertAnalogToAngle(axis,queryPotValue(axis));
}



int ElectronicsInterface::queryDigitalInput(int bit) {
  int val;
  char c;
  int which; //holds which byte to query.
  int mask;
  //first off lets make it zero based...
  bit-=1;
  which = bit/8; // integer division to figure out which bit  
  (*output) << "TI" << which << "\r\n";
  (*input) >> c >> c >> c; // read in echo of command
  (*input) >> val;
  (*input) >> c ; // read the colon
  mask =1;
  mask=mask << (bit%8); //shift so that we are masking the correct bit
  if (mask & val) {
    return 1;
  } else {
    return 0;
  }
}


void ElectronicsInterface::setDigitalOutput(int bit) {
  char command[80];
  if ((bit >8) || (bit <1)) {
    cerr << "Unable to set bit " << bit << ": out of range\n";
    cerr << "in ElectronicsInterface.cpp - setDigitalOutput\n";
    return;
  }
  sprintf(command,"SB %d",bit);
  sendCommand(command);
}

void ElectronicsInterface::clearDigitalOutput(int bit) {
  char command[80];
  if ((bit >8) || (bit <1)) {
    cerr << "Unable to clear bit " << bit << ": out of range\n";
    cerr << "in ElectronicsInterface.cpp - clearDigitalOutput\n";
    return;
  }
  sprintf(command,"CB %d",bit);
  sendCommand(command);
}

//#define DEBUG_MOVE
int ElectronicsInterface::moveToAbsolutePosition(int axis, double angle) {
  double curAngle;
  int stat;
  curAngle = queryPotPosition(axis); 
#ifdef DEBUG_MOVE
  cout << "Pots say: " << curAngle << "\n";
  cout << "Encoders say " << queryEncPosition(axis) << "\n";
  cout << "Therefore I will go to (en encoders) " << (angle-curAngle)+queryEncPosition(axis) << "\n";
  stat = moveToAndWait(axis,(angle-curAngle)+queryEncPosition(axis));
  cout << "Encoders say " << queryEncPosition(axis) << "\n";
  cout << "Pots say: " << queryPotPosition(axis) << "\n";
  return stat;
#else 
  return moveToAndWait(axis,(angle-curAngle)+queryEncPosition(axis));
#endif

}

void ElectronicsInterface::burn(void) {
  sendCommand("MOX");
  sendCommand("MOY");
  sendCommand("SHZ");
  sendCommand("IL 2,2,2");
  sendCommand("ER 2000,2000,2000,2000");  

  sendCommand("OE 1,1,1");
  sendCommand("BN");

}

void ElectronicsInterface::moveToPosition(int axis, double angle) {
  long position;
  char command[80];
  position= convertAngleToCounts(axis,angle);//angle-queryPotPositin(axis,angle));
  sprintf(command, "PA%s=%d",axesNames[axis],position);
  sendCommand(command);
  sprintf(command, "AC%s=%d",axesNames[axis],ACCELERATION);
  sendCommand(command);
  sprintf(command, "DC%s=%d",axesNames[axis],DECELERATION);
  sendCommand(command);
  sprintf(command,"SP%s=%d",axesNames[axis],VELOCITY);
  sendCommand(command);
  sprintf(command,"IT%s=%f",axesNames[axis],SMOOTHING_PARAM);
  sendCommand(command);
  sprintf(command,"BG %s",axesNames[axis]);
  sendCommand(command);
  //  sprintf(command,"AP %s",axesNames[axis]);
  //  sendCommand(command);
}

int ElectronicsInterface::waitTillAtPosition(int axis, double angle) {
  double curPos, oldPos;
  char buf[80];
  curPos = queryEncPosition(axis);
  oldPos = curPos+1;
  while (fabs(curPos-angle)>0.1) {
    usleep(250000);//250 mSecs
    oldPos =curPos;
    curPos =queryEncPosition(axis);
    if (curPos==oldPos) {
      sprintf(buf,"SC%s",axesNames[axis]);
      sendCommand(buf);
      return ARM_MOVE_ERROR;
    }
  }
  sleep(1); //settling time
  return ARM_GOT_THERE;
}
  
  


long ElectronicsInterface::convertAngleToCounts(int axis,double angle) {
  long counts;
  /*the +0.5 is for rounding....coupled with the floor*/
  counts = (long)(floor(axesDirectionFix[axis]*angle*countsPerDegree[axis]+0.5));
  return counts;
}


double ElectronicsInterface::convertCountsToAngle(int axis, long counts) {
  double angle;
  /*the multiply by 1.0 is to force type conversion to double*/
  angle = (counts)*1.0/(countsPerDegree[axis]*1.0)*axesDirectionFix[axis];
}

double ElectronicsInterface::convertAnalogToAngle(int axis, double position) {
  return converters[axis]->getAngle(position);
}

void ElectronicsInterface::initialize(void) {
  char buf[80];
  int i;
  /*use analog feedback for axes 1-3*/
  //  sendCommand("AF 1,1,1,1");
  for (i=0;i<4;i++)
       converters[i] = new PotLookUpTable();

  converters[0]->readIn("joint1.lut");
  converters[1]->readIn("joint2.lut");
  converters[2]->readIn("joint3.lut");
  sendCommand("RS");
  sendCommand("SH");
  sprintf(buf,"ER %d,%d,%d",2000,2000,2000);
  sendCommand(buf);
  sendCommand("KD 64,64");
  sendCommand("KP 6,6");
  sendCommand("KI 0,0");
 
  



}
