#include <iostream.h>
#include <linuxser.h>
#include "MeteoriteArmController.h"
#include "armCamImageScanner.h"
class ArmTestBench : public MeteoriteArmController {
public:
  ArmTestBench(ImageScanner *ims) : MeteoriteArmController(ims) {}

  int operateMenu() {
    char c;
    char buf[80];
    double x,y;
    int jointNum;
    double theta;

    cout << "****************\n";
    cout << "T. Test deploy arm\n";
    cout << "A. Position arm\n";
    cout << "B. Set arm height\n";
    cout << "C. Stow arm\n";
    cout << "D. Set relative joint angle\n";
    cout << "E. Set absolute joint angle\n";
    cout << "F  Burn arm paramaters\n";
    cout << "G  SendCommand\n";
    cout << "R  Reset arm\n";
    cout << "Q. Quit \n";
    cout << "****************\n>";
    cin >> c;
    switch (c) {
    case 'T':
    case 't':
      cout << "enter estimate of rock position x,y\n>";
      cin >> x >> c >>y;
      cout << "going to position arm at (" << x << "," << y << ")\n";
      this->deployPractice(x,y);
      break;
    case 'A':
    case 'a':
      cout << "enter desired position x,y\n>";
      cin >>x >> c >> y;
      cout << "going to position arm at (" << x << "," << y << ")\n";
      if (this->checkIfStowed()) {
	this->unstow(); 
      }
      this ->putArmAt(x,y);
      break;
    case 'B':
    case 'b':
      cout << "enter desired height h\n>";
      cin >> x;
      cout << "going to set arm height to " << x << "\n";
      this->setArmHeight(x);
      break;
    case 'C':
    case 'c':
      cout << "stowing arm\n";
      this->stow();
      break;
    case 'D':
    case 'd':
      cout << "Enter joint number (1 indexed): ";
      cin >> jointNum;
      cout << "Enter relative theta (degrees): ";
      cin >> theta;
      if(this->setJointAngleRel(jointNum, theta) == ARM_OK) {
	cout << "Success!\n";
      } else {
	cout << "Action failed!\n";
      }
      break;
    case 'E':
    case 'e':
      cout << "Enter joint number (1 indexed): ";
      cin >> jointNum;
      cout << "Enter absolute theta (degrees): ";
      cin >> theta;
      if(this->setJointAngleAbs(jointNum, theta) == ARM_OK) {
	cout << "Success!\n";
      } else {
	cout << "Action failed!\n";
      }
      break;
    case 'F':
    case 'f':
      controller->burn();
      break;
    case 'G':
    case 'g':
      cin >> buf;
      controller->sendCommand(buf,1);
      break;
    case 'R':
    case 'r':
      controller->initialize();
      break;
    case 'Q':
    case 'q':
      return 1;
      break;
    default:
      break;
    }
    return 0;
  }
};



void main(void) {
  portstream_fd serialPortFD= openserial("/dev/ttyS1");// closeserial("/dev/cua1");
  //  MeteoriteArmController *testee;
  ElectronicsInterface *testee;
  if (serialPortFD == PORT_NOT_OPENED) {
    // cout << "Serial port wasn't opened\n";
    exit(1);
  }

  closeserial(serialPortFD);

  armCamImageScanner *ims = new armCamImageScanner();
  ArmTestBench *bench = new ArmTestBench(ims);
  bench->init();
  int done=0;
  double x,y;
  char c;
  cout << "Welcome to arm test bench\n";
  while (!done) {
    done = bench->operateMenu();
  }

  delete bench;
  delete ims;
}
  

