/* FILE:    smManipulatorDriver.h
   AUTHOR:  Michael Wagner
   CREATED: Aug 30, 1999

   DESCRIPTION: This file defines the manipulator arm
     sensor manager device driver class, smManipulatorDriver. 
     This class is inhereted from the virtual class smDriver.h
*/

#ifndef __SM_MANIPULATOR_DRIVER_H__
#define __SM_MANIPULATOR_DRIVER_H__

#include "sensManDef.h"
#include "smDriver.h"
#include "smDriverDef.h"
#include "dbRecord.h"
#include "sensorMsgs.h"
#include "ndds/NDDS.h"
#include "armSensor.h"

#define MANIPULATOR_DRIVER_ID "smManipulatorDriver"
#define ARM_SENSOR_ID "armSensor"

#define ARM_DAQ_SAVE_FILE_NAME_BASE "/usr/nomad/data/Manipulator"

#define METAL_DETECTOR_DEPLOYMENT_POSITIONS 2
#define SPECTROMETER_DEPLOYMENT_POSITIONS 6

class smManipulatorDriver : public smDriver {
 public:
  smManipulatorDriver(DGPS *currPosition, pose *currPose);
  ~smManipulatorDriver();
  
  // Implementing the smDriver interface.
  SENS_MAN_STATUS execute(sensManRequest *sensManRequestMsg, int driverNum, dbRecord *workingData, dbRecordBitMask *bitMask);
  sensorCost *getCost(sensManRequest *sensManRequestMsg, int driverNum, dbRecord *workingData);
  sensorWorkspace *getWorkspace();
  SENS_MAN_STATUS getStatus();

 private:
  DGPS *currPosition;
  pose *currPose;
  sensorRequest *sensorRequestMsg;
  sensorReply *sensorReplyMsg;

  armSensor *arm; // TBD: This is a hack to get around NDDS / MeteoriteArmController problems
};

#endif /* __SM_MANIPULATOR_DRIVER_H__ */

  



