/* FILE:    smHiResDriver.h
   AUTHOR:  Michael Wagner
   CREATED: Apr 6, 1999

   DESCRIPTION: This file defines the high-resolution
     camera sensor manager device driver class, 
     smHiResDriver. This class is inhereted from the
     virtual class smDriver.h
*/

#ifndef __SM_HI_RES_DRIVER_H__
#define __SM_HI_RES_DRIVER_H__

#include "sensManDef.h"
#include "smDriver.h"
#include "smDriverDef.h"
#include "dbRecord.h"
#include "sensorMsgs.h"
#include "ndds/NDDS.h"

#define HI_RES_DRIVER_ID "smHiResDriver"
#define HI_RES_SENSOR_ID "hiResSensor"

class smHiResDriver : public smDriver {
 public:
  smHiResDriver(DGPS *currPosition, pose *currPose);
  ~smHiResDriver();
  
  // Implementing the smDriver interface.
  SENS_MAN_STATUS execute(sensManRequest *sensManRequestMsg, int driverNum, dbRecord *workingData, dbRecordBitMask *bitMask);
  sensorCost *getCost(sensManRequest *sensManRequestMsg, int driverNum, dbRecord *workingData);
  sensorWorkspace *getWorkspace();
  SENS_MAN_STATUS getStatus();

 private:
  DGPS *currPosition;
  pose *currPose;
  void sensorClientSetup();
  NDDSClient client;
  NDDSClientReplyStatus clientStatus;
  sensorRequest *sensorRequestMsg;
  sensorReply *sensorReplyMsg;
};

#endif /* __SM_HI_RES_DRIVER_H__ */

  



