/* FILE: smDriverDef.h
   CREATED: 4/12/99
   AUTHOR: Michael Wagner
   
   DESCRIPTION: This file defines types used by the sensor manager drivers.
 */

#ifndef __SM_DRIVER_DEF_H__
#define __SM_DRIVER_DEF_H__

#include "sensorDef.h"

// Global NDDS client/server definitions
#define SENSOR_MIN_WAIT_TIME 0.1f
#define SENSOR_MAX_WAIT_TIME 300.0f

#define SM_DRIVER_MAX_ID_LENGTH SENSOR_MAX_ID_LENGTH

typedef SENSOR_STATUS   SM_DRIVER_MODE;
typedef SENSOR_STATUS   SM_DRIVER_STATUS;
typedef SENSOR_FUNCTION SM_DRIVER_FUNCTION;

/* Used when sensor driver is registering itself. */
typedef enum {
  SM_DRIVER_REG_OK,
  SM_DRIVER_REG_FAIL,
  SM_DRIVER_NDDS_FAIL
} SM_DRIVER_REG_STATUS;

#endif /* __SM_DRIVER_DEF_H__ */
