/* FILE:    smDriver.h
   AUTHOR:  Michael Wagner
   CREATED: Apr 6, 1999

   DESCRIPTION: This file defines the virtual class
     smDriver, to be extended by any sensor manager
     device driver.
*/

#ifndef __SM_DRIVER_H__
#define __SM_DRIVER_H__

#include "sensManMsgs.h"
#include "dbRecord.h"
#include "sensManDef.h"
#include "sensorDef.h"
#include "smDriverDef.h"

class smDriver {
 public:
  smDriver(DGPS *currPosition, pose *currPose) {};
  ~smDriver() {};

  virtual SENS_MAN_STATUS execute(sensManRequest *sensManRequestMsg, int driverNum, dbRecord *workingData, dbRecordBitMask *bitMask) = 0;
  virtual sensorCost *getCost(sensManRequest *sensManRequestMsg, int driverNum, dbRecord *workingData) = 0;
  virtual sensorWorkspace *getWorkspace() = 0;
  virtual SENS_MAN_STATUS getStatus() = 0;

  char driverID[SM_DRIVER_MAX_ID_LENGTH];

};

#endif /* __SM_DRIVER_H__ */


