/* FILE: sensManQueue.h
   AUTHOR: Michael Wagner
   CREATED: May 13, 1999
   DESCRIPTION: Defines a queue for the Sensor Manager. This queue
     assignes a unique ID number for every request placed in the
     queue.

     TBD: Make this a subclass of queue, not just a composition!
     TBD: The (void *)'s are hacks too! Don't use them in C++! 
*/

#ifndef __SENS_MAN_QUEUE_H__
#define __SENS_MAN_QUEUE_H__

#include "queue.h"

#ifndef MAX_REQ_NUM
#define MAX_REQ_NUM 1048576
#endif


// This structure is used to store the request number with the request itself.
typedef struct {
  void *req;
  int reqNum;
} requestStruct;


class sensManQueue {
 private:
  queue<requestStruct *> *q;
  int reqNum;

 public:
  sensManQueue() {
    reqNum = -1;
    q = new queue<requestStruct *>();
  }

  requestStruct *remove(void) {
    return(q->remove());
  }

  unsigned int add(void *val) {
    requestStruct *req = new requestStruct;

    if(++reqNum >= MAX_REQ_NUM) {
      reqNum = 0;
    }
    req->reqNum = reqNum;
    req->req = val;

    q->add(req);

    return(reqNum);
  }

  int isEmpty() {
    return q->isEmpty();
  }  

};


#endif /* __SENS_MAN_QUEUE_H__ */
