/* FILE: sensManMain.h
   AUTHOR: Michael Wagner
   CREATED: Apr 19, 1999
   DESCRIPTION: Defines a few things for sensManMain.cpp
*/

#ifndef __SENS_MAN_MAIN_H__
#define __SENS_MAN_MAIN_H__

#include "ndds/NDDS.h"
#include "sensManQueue.h"
#include "sensManMsgs.h"
#include "sensorMsgs.h"
#include "smDriverDef.h"

// Global NDDS client/server definitions
#define SENSOR_REG_SERVER_STRENGTH 10.0f
#define SENS_MAN_SERVER_STRENGTH 10.0f
//#define SENSOR_MIN_WAIT_TIME 0.1f
//#define SENSOR_MAX_WAIT_TIME 1200.0f
#define DB_MIN_WAIT_TIME 0.1f
#define DB_MAX_WAIT_TIME 5.0f

// Global NDDS publisher definitions
#define SENS_MAN_COMPLETE_PERSISTANCE 15.0f
#define SENS_MAN_COMPLETE_STRENGTH 10.0f

// Global NDDS subscriber definitions
#define SENSOR_REG_DEADLINE 10.0f
#define SENSOR_REG_MIN_SEPARATION 0.0f 
#define TELEMETRY_DEADLINE 10.0f
#define TELEMETRY_MIN_SEPARATION 0.0f 

// Hacks to get more info into the "userData" paramaters of NDDS service routines.
typedef struct {
  sensMan *sm;
  NDDSClient *clients;
} sensorRegCallbackParam;

typedef struct {
  sensMan *sm;
  sensManQueue *q;
} sensManServiceParam;

typedef struct {
  DGPS *currPosition;
  pose *currPose;
} telemetryParam;

// Service routines
RTIBool sensManServiceRtn(NDDSObjectInstance reply,
			  NDDSObjectInstance request,
			  void *userData);

// NDDS server and client setup functions.
void sensorClientSetup(int sensorNum, char *sensorID, NDDSClient *client);
void dbClientSetup(NDDSClient *client);
void sensManServerSetup(sensMan *sensorManager, sensManQueue *clientReqQ);

// NDDS subscription functions
RTIBool sensorRegCallback(NDDSRecvInfo *issue);

// Other functions.
void publishComplete(NDDSPublication pub, sensManComplete *msg, int status, int reqNum);

#endif /* __SENS_MAN_MAIN_H__ */


