/* FILE: sensManDef.h
   CREATED: 4/15/99
   AUTHOR: Michael Wagner
   DESCRIPTION: This file contains definitions used by the sensor manager
     and software that uses the sensor manager.
*/

#ifndef __SENS_MAN_DEF_H__
#define __SENS_MAN_DEF_H__

#include "dbRecordDef.h"

#define SENS_MAN_MAX_SENSORS MAX_SENSORS
#define SENS_MAN_MAX_DRIVERS MAX_SENSORS

// This structure holds cost information
typedef struct {
  float timeCost;   /* seconds */
  float energyCost; /* Joules */
} sensorCost;

// This structue holds workspace information
typedef struct {
  float maxDistanceTolerance; /* meters */
  float minDistanceTolerance; /* meters */
  float angularTolerance;  /* meters */
} sensorWorkspace;

// The sensor manager returns one of these values to acknowledge
// a misssion planner request in sensManReply.status.
typedef enum {
  SENS_MAN_SUCCESSFUL,
  SENS_MAN_WORKING,
  SENS_MAN_OUT_OF_WORKSPACE,
  SENS_MAN_FAILED,
  //  SENS_MAN_MALFUNCTION,
  SENS_MAN_NO_SUCH_DRIVER,
  SENS_MAN_SUBMITTED_REQ,
  SENS_MAN_TRY_AGAIN
} SENS_MAN_STATUS;

// The mission planner commands the sensor manager with this enum
// in sensManRequest.mode.
typedef enum {
  SENS_MAN_COST_REQUEST,
  SENS_MAN_ACTION_REQUEST,
  SENS_MAN_STATUS_REQUEST,
  SENS_MAN_NUM_DRIVER_REQUEST,
  SENS_MAN_WORKSPACE_REQUEST,
} SENS_MAN_REQUEST_MODE;


#endif /* __SENS_MAN_DEF_H__ */
