/* FILE: sensMan.h
   AUTHOR: Lenny Delligatti
   CREATED: Apr 19 1999
   DESCRIPTION: Defines the sensMan class, the class in which the sensor
     manager functionality lies. 
*/

#ifndef __SENS_MAN_H__
#define __SENS_MAN_H__

#include "smDriver.h"
#include "sensManDef.h"
#include "smDriverDef.h"
#include "sensorDef.h"

class sensMan {
 public:
  sensMan();
  ~sensMan();
  
  // Methods dealing with drivers ("logical sensors")
  SENS_MAN_STATUS initDriver(smDriver *newDriver, int *driverNum); 
  SENS_MAN_STATUS deleteDriver(int driverNum);  
  smDriver *getDriver(int driverNum);
  int getNumDrivers();
  int isValidDriver(int driverNum);

  // Methods dealing with sensors ("physical sensors")
  SENS_MAN_STATUS addSensor(char *sensorID, SENSOR_STATUS mode, int *sensorNum);
  SENS_MAN_STATUS deleteSensor(int sensorNum);

 private:
  smDriver *drivers[SENS_MAN_MAX_DRIVERS];
  int numDrivers;
  
  char *sensorIDs[SENS_MAN_MAX_SENSORS];
  int numSensors;
  SENSOR_STATUS sensorStatus[SENS_MAN_MAX_SENSORS];
};

#endif /* __SENS_MAN_H__ */

