#include <iostream.h>
#include <stdio.h>
#include <fstream.h>

#include "sensMan.h"
#include "sensManDef.h"

sensMan::sensMan() {
  // Initialize all driver pointers to NULL
  for(int i=0; i < SENS_MAN_MAX_DRIVERS; i++) {
    drivers[i] = NULL;
  }

  for(int i=0; i < SENS_MAN_MAX_SENSORS; i++) {
    sensorIDs[i] = NULL;
  }

  numDrivers = 0;
  numSensors = 0;
}

sensMan::~sensMan() {
  // Destroy all driver objects in array
  for(int i=0; i < SENS_MAN_MAX_DRIVERS; i++) {
    if (drivers[i] != NULL) {
      delete(drivers[i]);
    }
  }
  
  for(int i=0; i < SENS_MAN_MAX_SENSORS; i++) {
    delete(sensorIDs[i]);
  }

  numDrivers = 0;
  numSensors = 0;
}

SENS_MAN_STATUS sensMan::initDriver(smDriver *newDriver, int *driverNum) {
  if(numDrivers < SENS_MAN_MAX_DRIVERS-1) {
    drivers[numDrivers] = newDriver;
    cerr << "[sensMan] Initialized new driver \"" << drivers[numDrivers]->driverID << "\" as driver #" << numDrivers << endl;
    numDrivers++;
    *driverNum = numDrivers;
    return(SENS_MAN_SUCCESSFUL);
  } else {
    return(SENS_MAN_FAILED);
  }
}

SENS_MAN_STATUS sensMan::deleteDriver(int driverNum) {
  if((driverNum >= 0) && (driverNum < SENS_MAN_MAX_DRIVERS)) {
    delete drivers[driverNum];
    numDrivers--;
    return(SENS_MAN_SUCCESSFUL);
  } else {
    return(SENS_MAN_FAILED);
  }
}


smDriver *sensMan::getDriver(int driverNum) {
  if((driverNum >= 0) && (driverNum < SENS_MAN_MAX_DRIVERS) && 
     (drivers[driverNum] != NULL)) {
    return(drivers[driverNum]);
  } else {
    return(NULL);
  }
}

int sensMan::getNumDrivers() {
  return numDrivers;
}

int sensMan::isValidDriver(int driverNum) {
  // TBD: Check that all the sensors that the driver depends on have been
  // registered. This will require a way to keep track of what drivers need
  // what sensors.

  return(1);
}

SENS_MAN_STATUS sensMan::addSensor(char *sensorID, SENSOR_STATUS status, int *sensorNum) {
  if(numSensors < SENS_MAN_MAX_SENSORS-1) {
    // Check to see if sensor is already added
    for(int i=0; i < numSensors; i++) {
      if(strcmp(sensorID, sensorIDs[i]) == 0) {
	return(SENS_MAN_FAILED);
      }
    }
    sensorIDs[numSensors] = new char[strlen(sensorID)];
    sensorStatus[numSensors] = status;
    strcpy(sensorIDs[numSensors], sensorID);
    numSensors++;
    *sensorNum = numSensors;
    return(SENS_MAN_SUCCESSFUL);
  } else {
    return(SENS_MAN_FAILED);
  }
}

SENS_MAN_STATUS sensMan::deleteSensor(int sensorNum) {
  if((sensorNum >= 0) && (sensorNum < SENS_MAN_MAX_SENSORS) && (sensorIDs[sensorNum] != NULL)) {
    sensorIDs[sensorNum] = NULL;
    numSensors--;
    return(SENS_MAN_SUCCESSFUL);
  } else {
    return(SENS_MAN_FAILED);
  }
}

