/************************************************************************/
/* This queue library was written by Mike Montemerlo.  A few additions  */
/* were made to his original version (ppin_queue and ppfree_queue).     */
/************************************************************************/
#include <stdio.h>
#include "malloc.h"
#include "navplan.h"

/************************************************************************/
/* Initialize the queue.                                                */
/************************************************************************/
ppqueue ppinit_queue(void)
{
  return(NULL);
}

/************************************************************************/
/* Return 1 if the queue is empty, 0 otherwise.                         */
/************************************************************************/
int ppempty_queue(ppqueue q)
{
  if(q==NULL)
    return 1;	
  else
    return 0;
}

/************************************************************************/
/* Put the data at the end of the queue.                                */
/************************************************************************/
void ppenqueue(ppqueue *q, void *data)
{
  ppqueue temp=*q;

  if(ppempty_queue(temp)) {
    temp=(ppqueue)malloc(sizeof(struct ppqueue_t));
    temp->next=NULL;
    temp->data=data;
    *q=temp;
  }
  else {
    while(temp->next!=NULL) temp=temp->next;
    temp->next=(ppqueue)malloc(sizeof(struct ppqueue_t));
    temp->next->next=NULL;
    temp->next->data=data;
  }
}

/************************************************************************/
/* Return the data at the top of the queue.                             */
/************************************************************************/
void *ppdequeue(ppqueue *q)
{
  ppqueue temp=*q;
  void *data;

  if(ppempty_queue(*q)) {
    return NULL;
  }
  (*q)=(*q)->next;
  data=temp->data;
  free(temp);
  return(data);
}


/************************************************************************/
/* Return 1 if the item is in the queue, 0 otherwise.                   */
/************************************************************************/
int ppin_queue(ppqueue *q, void *item)
{
  ppqueue temp=*q;
  int value=0;

  while (!ppempty_queue(temp) && !value) {
    if (temp->data == item)
      value = 1;
    temp=temp->next;
  }
  return(value);
}

/************************************************************************/
/* Free all memory associated with the queue.                           */
/************************************************************************/
void ppfree_queue(ppqueue *q)
{
  ppqueue temp;

  temp = *q;
  if (!ppempty_queue(*q)) {
    ppfree_queue(&(temp->next));
    free(temp);
  }
}

