#define FORWARD 1.571
#define BACKWARD -1.571
#define TURNRIGHT4 1.301
#define TURNRIGHT6 1.406
#define TURNLEFT4 1.831
#define TURNLEFT6 1.736

#define NORMSPEED 0.15
#define STOPPED 0.0

/* Typedef Structures */
/* this struct is for the stored tree and leaf queue */
typedef struct tree_list_t {
  MP_POSE curr_pose;            /* current location */
  float curr_angle, curr_speed; /* current config and speed */
  float turn, speed;            /* commanded move */
  float priority;
  struct tree_list_t *parent;          /* parent of this leaf */
  struct tree_list_t *prev;            /* previous item in list */
  struct tree_list_t *next;            /* next stored item in list */
} tree_list;


/* Function prototypes */ 
int goal(MP_POSE curr, mangoals Goal, int type);
float minAngle(float angle1, float angle2);
void read_model(float model[84][7]);
void find_stop(float model[84][7], float stopmodel[6][7]);
tree_list* lowestPriority(tree_list* tree);
float heuristic(MP_POSE pose, mangoals Goal, int type);
void addItem(tree_list* list, tree_list item);
tree_list* findParent(tree_list *tree, tree_list *current);
void changeItem(tree_list* list, tree_list item);
void removeLeaf(tree_list* list, tree_list* current);

