#define CONT_TARGET   1     /* map pixel contains a target object */
#define CONT_DANGER   2     /* map pixel contains a dangerous object */
#define CONT_SNOW     3     /* map pixel contains snow-covered terrain */
#define CONT_BOUND    4     /* map pixel contains boundary line */
 
#define SENS_ROV    0     /* map bit for a pixel driven over by rover */
#define SENS_PANO   1     /* map bit for a pixel sensed by panoramic camera */
#define SENS_RADAR  2     /* map bit for a pixel sensed by radar */
#define SENS_CAMERA 3     /* map bit for a pixel sensed by hi-res camera */
#define SENS_SPEC   4     /* map bit for a pixel sensed by spectrometer */
#define SENS_MAG    5     /* map bit for a pixel sensed by magnetometer */
#define SENS_MET    6     /* map bit for a pixel sensed by metal detector */
#define SENS_PLAN   7     /* map bit for a pixel plan indicates as covered */
 
/* These are used for marking map grids (from Mark Maimone) */
#define SETBIT(bit_no, item, value) \
        ((value)?(item |=(1<<bit_no)): \
                 (item &=~(1<<bit_no)))
#define GETBIT(bit_no, item) \
        (((item)&(1<<bit_no))>>bit_no)


/* Typedef Structure */
typedef struct {
  map_pixel* pixels[8];
} adj_pix_array;


/* Functions */
grid_block* init_grid_block(void);
int add_grid_block(planner_map* map, grid_block* curr, int dir);
adj_pix_array find_adj_pixels(planner_map* map, map_pixel* curr);
void free_map(planner_map map);
void mark_obstacle(planner_map* map, MP_POSE curr);

