/* FILE: missionPlannerMain.cpp
   AUTHOR: Michael Wagner
   CREATED: April 29, 1999
   DESCRIPTION: This is code that uses a missionPlanner object. It serves as a
     link between this object and NDDS.
*/

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include "sensManMsgs.h"
#include "sensManDef.h"
#include "ndds/NDDS.h"
#include "dbRecord.h"
#include "SAS_ServiceNames.h"

int clientMain()
{
  int   count          = 0;
  float minWaitTime    = 2.0f;
  float maxWaitTime    = 5.0f;
  NDDSClient          client;
  NDDSClientReplyStatus    clientStatus;
  sensManReply   *itemReply   = NULL;
  sensManRequest *itemRequest = NULL;
  
  sensManReplyNddsRegister();
  sensManRequestNddsRegister();
  
  cout << "Creating client to sensor manager service...";
  client = NddsClientCreate(SENS_MAN_SERVICE, 
			    sensManReplyPublicationType,
			    sensManRequestPublicationType);
  cout << "done!" << endl;
  NddsUtilitySleep(2.0);
  
  itemRequest = (sensManRequest *)calloc(1, sizeof(sensManRequest));
  itemReply   = (sensManReply *)calloc(1, sizeof(sensManReply));
  
  // TBD: put real data in here. Right now this just gets test data from the user.
  int cont = 1;
  while(cont) {
  //  for(int cont = 0; cont < 20; cont++) {
  //NddsUtilitySleep(1.0);
    
    cout << "Target ID: "; cin >> itemRequest->targetID;
    cout << "Sensor Manager Driver Num: "; cin >> itemRequest->driverNum;
    cout << "Assuming action mode, since cost mode is not yet implemented.\n"; itemRequest->mode = SENS_MAN_ACTION_REQUEST;
    if(NddsClientServerWait(client, 2.0, 5, 1) == RTI_FALSE) { 
      cerr << "[missionPlannerMain] ERROR: Can't find server!" << endl;
    } 


    /* Now make the sensor manager request. Wait until we get a reply. */
    clientStatus = NddsClientCallAndWait(client, itemReply, itemRequest, 
					 minWaitTime, maxWaitTime);
    
    /* Check the status of the return. If it's good, then return it to
       main. If not, then return an appropriate error. Main will set up
       the sensor driver NDDS server only if this step is successful. */
    if(clientStatus == NDDS_CLIENT_RECV_REPLY) {
      switch(itemReply->status) {
      case SENS_MAN_SUCCESSFUL:
	cout << "missionPlanner: request to Sensor Manager successful!" << endl;
	break;
      case SENS_MAN_OUT_OF_WORKSPACE:
	cout << "missionPlanner: Sensor Manager replied with an out of workspace status." << endl;
	break;
      case SENS_MAN_FAILED:
	cout << "missionPlanner: ERROR: request to Sensor Manager failed!" << endl;
	break;
      case SENS_MAN_NO_SUCH_DRIVER:
	cout << "missionPlanner: ERROR: sensor #" << itemRequest->driverNum << " invalid!" << endl;
	break;
      case SENS_MAN_SUBMITTED_REQ:
	cout << "missionPlanner: successfully submitted request to sensor manager!" << endl;
	break;
      }
    } else {
      // Some NDDS problem.
      cout << "missionPlanner: ERROR: did not get a reply from Sensor Manager!" << endl;
    }

    cout << "1 continue, 0 quit: "; cin >> cont; 
  }
}

int main(int argc, char *argv[]) {
  if(argc != 2) {
    cout << "Usage: missionPlanner nddsDomain" << endl;
    return(-1);
  }

  NddsInit(atoi(argv[1]), NULL);

  cout << "missionPlanner: finished NDDS initialization, starting Sensor Manager client..." << endl;
  clientMain();

  cout << "missionPlanner: exiting" << endl;

  return(0);
}

