/* mangen teleopMsgs \- NDDS methods for teleopMsgs type.
   banner = ==========
  
   This file is derived from code automatically generated by nddsgen.
 */

static char copyright_rti[] = 
"(c) Copyright, Real-Time Innovations, Inc., 1994.  All rights reserved.";

/*
DESCRIPTION:
  This file was automatically generated by the 'nddsgen' code generator from the
  XDR file teleopMsgs.x.  See the man pages on 'nddsgen' and 'NddsXDR'.

  This file was generated with the following steps:

(1) One or more XDR descriptions where written into a file named 
    teleopMsgs.x (NOTE: the .x termination which is standard for this 
    files is required.). This description uses the XDR language,
    which resembles "C"-like structure-type declarations. More information 
    and examples on how to write these ".x" files can be found in the 
    on-line html page for 'nddsgen'.

(2) 'nddsgen' was run on the teleopMsgs.x file. The command was:
    /usr/mwagner/nomad/src/SAS/messages/teleop/nddsgen teleopMsgs.x -replace

    This created the teleopMsgs.c, and teleopMsgs.h.

(3) The teleopMsgs_stub.c is copied into teleopMsgs.c;
    if you pass "-replace" during nddsgen. This file contains the functions, 
    NddsTypeNameSeralize(), NddsTypeNameDeserialize(), and NddsTypeNamePrint() 
    for each NDDS type.

(4) The user may want to fill in the code for the NddsTypeNamePrint()
    function if they want NDDS to print the NddsTypeName automatically
    in certain situations. This isn't required.

(5) The file teleopMsgs.c also contains functions to register, and 
    test NDDS types.

SEE ALSO:
  nddsgen(1), NddsXDR(2), Ndds(2)
--------------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <rpc/types.h>
#include <rpc/xdr.h>

#include "teleopMsgs.h"
#include "teleopMsgsDef.h"
#include "sensorDef.h"


int NddsXDRSerializeSize_hiResRequest()
{
    int size = 0;
    size += NddsXDRSerializeSize_int(); /* function */
    size += NddsXDRSerializeSize_float(); /* pan */
    size += NddsXDRSerializeSize_float(); /* tilt */
    size += NddsXDRSerializeSize_float(); /* FOV */
    return size;
}




bool_t
NddsXDRPrint_hiResRequest(hiResRequest *objp, char *desc, int indent)
{
    int i;
    for (i=0; i<indent; i++) { printf("  "); }
    printf("%s:\n", desc);

    if (!NddsXDRPrint_int(&objp->function, "function", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_float(&objp->pan, "pan", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_float(&objp->tilt, "tilt", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_float(&objp->FOV, "FOV", indent+1)) {
        return (FALSE);
    }
    return (TRUE);
}




bool_t
xdr_hiResRequest(XDR *xdrs, hiResRequest *objp)
{
    if (!xdr_int(xdrs, &objp->function)) {
    	return (FALSE);
    }
    if (!xdr_float(xdrs, &objp->pan)) {
    	return (FALSE);
    }
    if (!xdr_float(xdrs, &objp->tilt)) {
    	return (FALSE);
    }
    if (!xdr_float(xdrs, &objp->FOV)) {
    	return (FALSE);
    }
    return (TRUE);
}




int NddsXDRSerializeSize_hiResReply()
{
    int size = 0;
    size += NddsXDRSerializeSize_int(); /* status */
    size += NddsXDRSerializeSize_string(SENSOR_MAX_FILENAME_LENGTH); /* filename */
    return size;
}




bool_t
NddsXDRPrint_hiResReply(hiResReply *objp, char *desc, int indent)
{
    int i;
    for (i=0; i<indent; i++) { printf("  "); }
    printf("%s:\n", desc);

    if (!NddsXDRPrint_int(&objp->status, "status", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_string(objp->filename, "filename", indent+1)) {
        return (FALSE);
    }
    return (TRUE);
}




bool_t
xdr_hiResReply(XDR *xdrs, hiResReply *objp)
{
    if (!xdr_int(xdrs, &objp->status)) {
    	return (FALSE);
    }
    if (!xdr_string_safe(xdrs, &objp->filename, SENSOR_MAX_FILENAME_LENGTH)) {
    	return (FALSE);
    }
    return (TRUE);
}




int NddsXDRSerializeSize_armRequest()
{
    int size = 0;
    size += NddsXDRSerializeSize_int(); /* function */
    size += NddsXDRSerializeSize_int(); /* row */
    size += NddsXDRSerializeSize_int(); /* col */
    return size;
}




bool_t
NddsXDRPrint_armRequest(armRequest *objp, char *desc, int indent)
{
    int i;
    for (i=0; i<indent; i++) { printf("  "); }
    printf("%s:\n", desc);

    if (!NddsXDRPrint_int(&objp->function, "function", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_int(&objp->row, "row", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_int(&objp->col, "col", indent+1)) {
        return (FALSE);
    }
    return (TRUE);
}




bool_t
xdr_armRequest(XDR *xdrs, armRequest *objp)
{
    if (!xdr_int(xdrs, &objp->function)) {
    	return (FALSE);
    }
    if (!xdr_int(xdrs, &objp->row)) {
    	return (FALSE);
    }
    if (!xdr_int(xdrs, &objp->col)) {
    	return (FALSE);
    }
    return (TRUE);
}




int NddsXDRSerializeSize_armReply()
{
    int size = 0;
    size += NddsXDRSerializeSize_int(); /* status */
    return size;
}




bool_t
NddsXDRPrint_armReply(armReply *objp, char *desc, int indent)
{
    int i;
    for (i=0; i<indent; i++) { printf("  "); }
    printf("%s:\n", desc);

    if (!NddsXDRPrint_int(&objp->status, "status", indent+1)) {
        return (FALSE);
    }
    return (TRUE);
}




bool_t
xdr_armReply(XDR *xdrs, armReply *objp)
{
    if (!xdr_int(xdrs, &objp->status)) {
    	return (FALSE);
    }
    return (TRUE);
}


/* ========================================================================
   hiResRequestSerialize \- NDDS serialization method for hiResRequest

   Required NDDS method to serialize an hiResRequest into NDDSXDRStream 
   buffer.
   The data will be deserialized by the hiResRequestDeserialize() function.

   The 'options' may be defined and used for customizing serialization
   for different situations. Often (as in this case) they are simply 
   ignored.
 */
RTIBool hiResRequestSerialize(NDDSXDRStream nddsds, 
			   hiResRequest *nddshiResRequest,
			   int options)
{
    return xdr_hiResRequest(NddsXDRGetSerializingStream(nddsds),
			       nddshiResRequest);
}

/* ========================================================================
   hiResRequestDeserialize \- NDDS deserialization method for hiResRequest 
   
   Required NDDS method to deserialize the data from an NDDSXDRStream buffer.
   The data was serialized by the hiResRequestSerialize() function.

   If outArray==NULL (null pointer), this function will create a
   hiResRequest of the appropriate size to hold the data 
   (as required by NDDS).

   Returns the output array or NULL if an error occurred
 */
hiResRequest *hiResRequestDeserialize(hiResRequest *nddshiResRequest,
				      NDDSXDRStream nddsds)
{
    int allocated = RTI_FALSE;

    if (nddshiResRequest == NULL) {
	allocated = RTI_TRUE;
	nddshiResRequest =(hiResRequest *)calloc(1, sizeof(hiResRequest));
    }

    if (!xdr_hiResRequest(NddsXDRGetDeserializingStream(nddsds),
			     nddshiResRequest))  {
	if (allocated) {
	    free(nddshiResRequest);
	}
	return NULL;
    }
    
    return nddshiResRequest;
}

/* ========================================================================
   hiResRequestPrint \- NDDS Print method for hiResRequest objects

   Optional NDDS method to print the contents of an hiResRequest.

   Note that if this method *must* handle the case where the object
   is NULL.
 */
hiResRequest *hiResRequestPrint(hiResRequest *nddshiResRequest)
{
    /* Do not remove. hiResRequestPrint must handle a NULL 
       hiResRequest 
       */
    if (nddshiResRequest==NULL) {
	printf("hiResRequest: (null)\n");
	return NULL;
    }

    /* Replace by custom code if desired */
    if (!NddsXDRPrint_hiResRequest(nddshiResRequest, "hiResRequest", 0)) {
	printf("NddsXDRPrinthiResRequest() failed on %p\n", 
	       nddshiResRequest);
	return NULL;
    }

    /* Do not remove the return value */
    return nddshiResRequest;
}

/* ========================================================================
   hiResRequestSerializeSize \- NDDS size method for hiResRequest objects
 
   This optional NDDS method returns the maximum size of a hiResRequest object.
   The purpose of this method is to allow NDDS to optimize its memory usage.
 
   Users must be very careful and return a size that is equal-to or larger 
   than the maximum hiResRequest serialized. Please refer to NddsXdr(2) for
   functions to help determin the serialized size of basic types.

   If a -1 is returned then NDDS will default to a safe size, but will not
   be optimal.
 */
int hiResRequestSerializeSize()
{
    return NddsXDRSerializeSize_hiResRequest();
}


/* ========================================================================
   hiResRequestAllocate \- NDDS Allocate method for hiResRequest objects

   Optional NDDS method to allocate an NDDS object of type hiResRequest.

   If registered within hiResRequestNddsRegister(), this method will be 
   invoked as a result of pattern subscriptions. When the NDDS agent 
   subscribes to a publication that matches the requested pattern, it
   needs to create a new object of the corresponding type to hold the 
   updates when they come. 
   It is for this purpose that hiResRequestAllocate() is used.

   This method is not always required because hiResRequestDeserialize()
   is usually able to allocate the object itself. There are however
   some cases (notably strings) for which the allocation provided
   by hiResRequestDeserialize() isn't sufficient. Registration
   of hiResRequestAllocate() allows to override the default allocation
   provided by hiResRequestDeserialize().

   If this method is to be used, it must passed to NddsTypeRegister()
   (in function hiResRequestNddsRegister()) instead of the default
   NULL method.

   This routine gets passed the type and name of the object instance and
   the parameter provided by the user passed in the 
   NddsSubscriptionGroupSubscriptionAdd(3) call.
 */
hiResRequest *hiResRequestAllocate(const char *type, const char *name,
				   void *userParam)
{
    hiResRequest *nddshiResRequest = NULL;

    nddshiResRequest = (hiResRequest *)calloc(1, sizeof(*nddshiResRequest));
    {
	/* Add the custom allocation of entries in the structure here */
    }

    return nddshiResRequest;
}

/* ========================================================================
   hiResRequestFree \- NDDS Free method for hiResRequest objects

   Optional NDDS method to Free an NDDS object of type hiResRequest.

   This method is not used in the current version of NDDS.
 */
RTIBool hiResRequestFree(hiResRequest *inst, const char *type, const char *name,
		      void *userParam)
{
    return RTI_TRUE;
}

/* ========================================================================
   hiResRequestNddsRegister \- Install hiResRequest type to NDDS
   
   This function will register an hiResRequest type with NDDS.   
   Registration must happen before any reference to the hiResRequest 
   type is given to NDDS.

   A description of the type hiResRequest was written in a file
   named hiResRequest.x (NOTE: the .x termination which is standard
   for this files is required.). This description uses the XDR language,
   which resembles "C"-like structure-type declarations. More information
   and examples on how to write these ".x" files can be found in the
   man page for 'nddsgen'.
 
   nddsgen was run on the teleopMsgs.x file. See the man pages
   on nddsgen and teleopMsgs for details.
 */
void hiResRequestNddsRegister(void)
{
   NddsTypeRegister(hiResRequestPublicationType,
	/*A #define in teleopMsgs.h*/
		    (SerializeMethodType)hiResRequestSerialize,
		    (DeserializeMethodType)hiResRequestDeserialize,
		    (PrintMethodType)hiResRequestPrint,
		    (AllocateMethodType)NULL,
		    (FreeMethodType)NULL,
		    (SerializeSizeMethodType)hiResRequestSerializeSize);
}
/* ========================================================================
   hiResReplySerialize \- NDDS serialization method for hiResReply

   Required NDDS method to serialize an hiResReply into NDDSXDRStream 
   buffer.
   The data will be deserialized by the hiResReplyDeserialize() function.

   The 'options' may be defined and used for customizing serialization
   for different situations. Often (as in this case) they are simply 
   ignored.
 */
RTIBool hiResReplySerialize(NDDSXDRStream nddsds, 
			   hiResReply *nddshiResReply,
			   int options)
{
    return xdr_hiResReply(NddsXDRGetSerializingStream(nddsds),
			       nddshiResReply);
}

/* ========================================================================
   hiResReplyDeserialize \- NDDS deserialization method for hiResReply 
   
   Required NDDS method to deserialize the data from an NDDSXDRStream buffer.
   The data was serialized by the hiResReplySerialize() function.

   If outArray==NULL (null pointer), this function will create a
   hiResReply of the appropriate size to hold the data 
   (as required by NDDS).

   Returns the output array or NULL if an error occurred
 */
hiResReply *hiResReplyDeserialize(hiResReply *nddshiResReply,
				      NDDSXDRStream nddsds)
{
    int allocated = RTI_FALSE;

    if (nddshiResReply == NULL) {
	allocated = RTI_TRUE;
	nddshiResReply =(hiResReply *)calloc(1, sizeof(hiResReply));
    }

    if (!xdr_hiResReply(NddsXDRGetDeserializingStream(nddsds),
			     nddshiResReply))  {
	if (allocated) {
	    free(nddshiResReply);
	}
	return NULL;
    }
    
    return nddshiResReply;
}

/* ========================================================================
   hiResReplyPrint \- NDDS Print method for hiResReply objects

   Optional NDDS method to print the contents of an hiResReply.

   Note that if this method *must* handle the case where the object
   is NULL.
 */
hiResReply *hiResReplyPrint(hiResReply *nddshiResReply)
{
    /* Do not remove. hiResReplyPrint must handle a NULL 
       hiResReply 
       */
    if (nddshiResReply==NULL) {
	printf("hiResReply: (null)\n");
	return NULL;
    }

    /* Replace by custom code if desired */
    if (!NddsXDRPrint_hiResReply(nddshiResReply, "hiResReply", 0)) {
	printf("NddsXDRPrinthiResReply() failed on %p\n", 
	       nddshiResReply);
	return NULL;
    }

    /* Do not remove the return value */
    return nddshiResReply;
}

/* ========================================================================
   hiResReplySerializeSize \- NDDS size method for hiResReply objects
 
   This optional NDDS method returns the maximum size of a hiResReply object.
   The purpose of this method is to allow NDDS to optimize its memory usage.
 
   Users must be very careful and return a size that is equal-to or larger 
   than the maximum hiResReply serialized. Please refer to NddsXdr(2) for
   functions to help determin the serialized size of basic types.

   If a -1 is returned then NDDS will default to a safe size, but will not
   be optimal.
 */
int hiResReplySerializeSize()
{
    return NddsXDRSerializeSize_hiResReply();
}


/* ========================================================================
   hiResReplyAllocate \- NDDS Allocate method for hiResReply objects

   Optional NDDS method to allocate an NDDS object of type hiResReply.

   If registered within hiResReplyNddsRegister(), this method will be 
   invoked as a result of pattern subscriptions. When the NDDS agent 
   subscribes to a publication that matches the requested pattern, it
   needs to create a new object of the corresponding type to hold the 
   updates when they come. 
   It is for this purpose that hiResReplyAllocate() is used.

   This method is not always required because hiResReplyDeserialize()
   is usually able to allocate the object itself. There are however
   some cases (notably strings) for which the allocation provided
   by hiResReplyDeserialize() isn't sufficient. Registration
   of hiResReplyAllocate() allows to override the default allocation
   provided by hiResReplyDeserialize().

   If this method is to be used, it must passed to NddsTypeRegister()
   (in function hiResReplyNddsRegister()) instead of the default
   NULL method.

   This routine gets passed the type and name of the object instance and
   the parameter provided by the user passed in the 
   NddsSubscriptionGroupSubscriptionAdd(3) call.
 */
hiResReply *hiResReplyAllocate(const char *type, const char *name,
				   void *userParam)
{
    hiResReply *nddshiResReply = NULL;

    nddshiResReply = (hiResReply *)calloc(1, sizeof(*nddshiResReply));
    {
	/* Add the custom allocation of entries in the structure here */
    }

    return nddshiResReply;
}

/* ========================================================================
   hiResReplyFree \- NDDS Free method for hiResReply objects

   Optional NDDS method to Free an NDDS object of type hiResReply.

   This method is not used in the current version of NDDS.
 */
RTIBool hiResReplyFree(hiResReply *inst, const char *type, const char *name,
		      void *userParam)
{
    return RTI_TRUE;
}

/* ========================================================================
   hiResReplyNddsRegister \- Install hiResReply type to NDDS
   
   This function will register an hiResReply type with NDDS.   
   Registration must happen before any reference to the hiResReply 
   type is given to NDDS.

   A description of the type hiResReply was written in a file
   named hiResReply.x (NOTE: the .x termination which is standard
   for this files is required.). This description uses the XDR language,
   which resembles "C"-like structure-type declarations. More information
   and examples on how to write these ".x" files can be found in the
   man page for 'nddsgen'.
 
   nddsgen was run on the teleopMsgs.x file. See the man pages
   on nddsgen and teleopMsgs for details.
 */
void hiResReplyNddsRegister(void)
{
   NddsTypeRegister(hiResReplyPublicationType,
	/*A #define in teleopMsgs.h*/
		    (SerializeMethodType)hiResReplySerialize,
		    (DeserializeMethodType)hiResReplyDeserialize,
		    (PrintMethodType)hiResReplyPrint,
		    (AllocateMethodType)NULL,
		    (FreeMethodType)NULL,
		    (SerializeSizeMethodType)hiResReplySerializeSize);
}
/* ========================================================================
   armRequestSerialize \- NDDS serialization method for armRequest

   Required NDDS method to serialize an armRequest into NDDSXDRStream 
   buffer.
   The data will be deserialized by the armRequestDeserialize() function.

   The 'options' may be defined and used for customizing serialization
   for different situations. Often (as in this case) they are simply 
   ignored.
 */
RTIBool armRequestSerialize(NDDSXDRStream nddsds, 
			   armRequest *nddsarmRequest,
			   int options)
{
    return xdr_armRequest(NddsXDRGetSerializingStream(nddsds),
			       nddsarmRequest);
}

/* ========================================================================
   armRequestDeserialize \- NDDS deserialization method for armRequest 
   
   Required NDDS method to deserialize the data from an NDDSXDRStream buffer.
   The data was serialized by the armRequestSerialize() function.

   If outArray==NULL (null pointer), this function will create a
   armRequest of the appropriate size to hold the data 
   (as required by NDDS).

   Returns the output array or NULL if an error occurred
 */
armRequest *armRequestDeserialize(armRequest *nddsarmRequest,
				      NDDSXDRStream nddsds)
{
    int allocated = RTI_FALSE;

    if (nddsarmRequest == NULL) {
	allocated = RTI_TRUE;
	nddsarmRequest =(armRequest *)calloc(1, sizeof(armRequest));
    }

    if (!xdr_armRequest(NddsXDRGetDeserializingStream(nddsds),
			     nddsarmRequest))  {
	if (allocated) {
	    free(nddsarmRequest);
	}
	return NULL;
    }
    
    return nddsarmRequest;
}

/* ========================================================================
   armRequestPrint \- NDDS Print method for armRequest objects

   Optional NDDS method to print the contents of an armRequest.

   Note that if this method *must* handle the case where the object
   is NULL.
 */
armRequest *armRequestPrint(armRequest *nddsarmRequest)
{
    /* Do not remove. armRequestPrint must handle a NULL 
       armRequest 
       */
    if (nddsarmRequest==NULL) {
	printf("armRequest: (null)\n");
	return NULL;
    }

    /* Replace by custom code if desired */
    if (!NddsXDRPrint_armRequest(nddsarmRequest, "armRequest", 0)) {
	printf("NddsXDRPrintarmRequest() failed on %p\n", 
	       nddsarmRequest);
	return NULL;
    }

    /* Do not remove the return value */
    return nddsarmRequest;
}

/* ========================================================================
   armRequestSerializeSize \- NDDS size method for armRequest objects
 
   This optional NDDS method returns the maximum size of a armRequest object.
   The purpose of this method is to allow NDDS to optimize its memory usage.
 
   Users must be very careful and return a size that is equal-to or larger 
   than the maximum armRequest serialized. Please refer to NddsXdr(2) for
   functions to help determin the serialized size of basic types.

   If a -1 is returned then NDDS will default to a safe size, but will not
   be optimal.
 */
int armRequestSerializeSize()
{
    return NddsXDRSerializeSize_armRequest();
}


/* ========================================================================
   armRequestAllocate \- NDDS Allocate method for armRequest objects

   Optional NDDS method to allocate an NDDS object of type armRequest.

   If registered within armRequestNddsRegister(), this method will be 
   invoked as a result of pattern subscriptions. When the NDDS agent 
   subscribes to a publication that matches the requested pattern, it
   needs to create a new object of the corresponding type to hold the 
   updates when they come. 
   It is for this purpose that armRequestAllocate() is used.

   This method is not always required because armRequestDeserialize()
   is usually able to allocate the object itself. There are however
   some cases (notably strings) for which the allocation provided
   by armRequestDeserialize() isn't sufficient. Registration
   of armRequestAllocate() allows to override the default allocation
   provided by armRequestDeserialize().

   If this method is to be used, it must passed to NddsTypeRegister()
   (in function armRequestNddsRegister()) instead of the default
   NULL method.

   This routine gets passed the type and name of the object instance and
   the parameter provided by the user passed in the 
   NddsSubscriptionGroupSubscriptionAdd(3) call.
 */
armRequest *armRequestAllocate(const char *type, const char *name,
				   void *userParam)
{
    armRequest *nddsarmRequest = NULL;

    nddsarmRequest = (armRequest *)calloc(1, sizeof(*nddsarmRequest));
    {
	/* Add the custom allocation of entries in the structure here */
    }

    return nddsarmRequest;
}

/* ========================================================================
   armRequestFree \- NDDS Free method for armRequest objects

   Optional NDDS method to Free an NDDS object of type armRequest.

   This method is not used in the current version of NDDS.
 */
RTIBool armRequestFree(armRequest *inst, const char *type, const char *name,
		      void *userParam)
{
    return RTI_TRUE;
}

/* ========================================================================
   armRequestNddsRegister \- Install armRequest type to NDDS
   
   This function will register an armRequest type with NDDS.   
   Registration must happen before any reference to the armRequest 
   type is given to NDDS.

   A description of the type armRequest was written in a file
   named armRequest.x (NOTE: the .x termination which is standard
   for this files is required.). This description uses the XDR language,
   which resembles "C"-like structure-type declarations. More information
   and examples on how to write these ".x" files can be found in the
   man page for 'nddsgen'.
 
   nddsgen was run on the teleopMsgs.x file. See the man pages
   on nddsgen and teleopMsgs for details.
 */
void armRequestNddsRegister(void)
{
   NddsTypeRegister(armRequestPublicationType,
	/*A #define in teleopMsgs.h*/
		    (SerializeMethodType)armRequestSerialize,
		    (DeserializeMethodType)armRequestDeserialize,
		    (PrintMethodType)armRequestPrint,
		    (AllocateMethodType)NULL,
		    (FreeMethodType)NULL,
		    (SerializeSizeMethodType)armRequestSerializeSize);
}
/* ========================================================================
   armReplySerialize \- NDDS serialization method for armReply

   Required NDDS method to serialize an armReply into NDDSXDRStream 
   buffer.
   The data will be deserialized by the armReplyDeserialize() function.

   The 'options' may be defined and used for customizing serialization
   for different situations. Often (as in this case) they are simply 
   ignored.
 */
RTIBool armReplySerialize(NDDSXDRStream nddsds, 
			   armReply *nddsarmReply,
			   int options)
{
    return xdr_armReply(NddsXDRGetSerializingStream(nddsds),
			       nddsarmReply);
}

/* ========================================================================
   armReplyDeserialize \- NDDS deserialization method for armReply 
   
   Required NDDS method to deserialize the data from an NDDSXDRStream buffer.
   The data was serialized by the armReplySerialize() function.

   If outArray==NULL (null pointer), this function will create a
   armReply of the appropriate size to hold the data 
   (as required by NDDS).

   Returns the output array or NULL if an error occurred
 */
armReply *armReplyDeserialize(armReply *nddsarmReply,
				      NDDSXDRStream nddsds)
{
    int allocated = RTI_FALSE;

    if (nddsarmReply == NULL) {
	allocated = RTI_TRUE;
	nddsarmReply =(armReply *)calloc(1, sizeof(armReply));
    }

    if (!xdr_armReply(NddsXDRGetDeserializingStream(nddsds),
			     nddsarmReply))  {
	if (allocated) {
	    free(nddsarmReply);
	}
	return NULL;
    }
    
    return nddsarmReply;
}

/* ========================================================================
   armReplyPrint \- NDDS Print method for armReply objects

   Optional NDDS method to print the contents of an armReply.

   Note that if this method *must* handle the case where the object
   is NULL.
 */
armReply *armReplyPrint(armReply *nddsarmReply)
{
    /* Do not remove. armReplyPrint must handle a NULL 
       armReply 
       */
    if (nddsarmReply==NULL) {
	printf("armReply: (null)\n");
	return NULL;
    }

    /* Replace by custom code if desired */
    if (!NddsXDRPrint_armReply(nddsarmReply, "armReply", 0)) {
	printf("NddsXDRPrintarmReply() failed on %p\n", 
	       nddsarmReply);
	return NULL;
    }

    /* Do not remove the return value */
    return nddsarmReply;
}

/* ========================================================================
   armReplySerializeSize \- NDDS size method for armReply objects
 
   This optional NDDS method returns the maximum size of a armReply object.
   The purpose of this method is to allow NDDS to optimize its memory usage.
 
   Users must be very careful and return a size that is equal-to or larger 
   than the maximum armReply serialized. Please refer to NddsXdr(2) for
   functions to help determin the serialized size of basic types.

   If a -1 is returned then NDDS will default to a safe size, but will not
   be optimal.
 */
int armReplySerializeSize()
{
    return NddsXDRSerializeSize_armReply();
}


/* ========================================================================
   armReplyAllocate \- NDDS Allocate method for armReply objects

   Optional NDDS method to allocate an NDDS object of type armReply.

   If registered within armReplyNddsRegister(), this method will be 
   invoked as a result of pattern subscriptions. When the NDDS agent 
   subscribes to a publication that matches the requested pattern, it
   needs to create a new object of the corresponding type to hold the 
   updates when they come. 
   It is for this purpose that armReplyAllocate() is used.

   This method is not always required because armReplyDeserialize()
   is usually able to allocate the object itself. There are however
   some cases (notably strings) for which the allocation provided
   by armReplyDeserialize() isn't sufficient. Registration
   of armReplyAllocate() allows to override the default allocation
   provided by armReplyDeserialize().

   If this method is to be used, it must passed to NddsTypeRegister()
   (in function armReplyNddsRegister()) instead of the default
   NULL method.

   This routine gets passed the type and name of the object instance and
   the parameter provided by the user passed in the 
   NddsSubscriptionGroupSubscriptionAdd(3) call.
 */
armReply *armReplyAllocate(const char *type, const char *name,
				   void *userParam)
{
    armReply *nddsarmReply = NULL;

    nddsarmReply = (armReply *)calloc(1, sizeof(*nddsarmReply));
    {
	/* Add the custom allocation of entries in the structure here */
    }

    return nddsarmReply;
}

/* ========================================================================
   armReplyFree \- NDDS Free method for armReply objects

   Optional NDDS method to Free an NDDS object of type armReply.

   This method is not used in the current version of NDDS.
 */
RTIBool armReplyFree(armReply *inst, const char *type, const char *name,
		      void *userParam)
{
    return RTI_TRUE;
}

/* ========================================================================
   armReplyNddsRegister \- Install armReply type to NDDS
   
   This function will register an armReply type with NDDS.   
   Registration must happen before any reference to the armReply 
   type is given to NDDS.

   A description of the type armReply was written in a file
   named armReply.x (NOTE: the .x termination which is standard
   for this files is required.). This description uses the XDR language,
   which resembles "C"-like structure-type declarations. More information
   and examples on how to write these ".x" files can be found in the
   man page for 'nddsgen'.
 
   nddsgen was run on the teleopMsgs.x file. See the man pages
   on nddsgen and teleopMsgs for details.
 */
void armReplyNddsRegister(void)
{
   NddsTypeRegister(armReplyPublicationType,
	/*A #define in teleopMsgs.h*/
		    (SerializeMethodType)armReplySerialize,
		    (DeserializeMethodType)armReplyDeserialize,
		    (PrintMethodType)armReplyPrint,
		    (AllocateMethodType)NULL,
		    (FreeMethodType)NULL,
		    (SerializeSizeMethodType)armReplySerializeSize);
}
