/* targetAcqMsgs_subscription.c \- A subscription of data of type targetAcqRequest

   This file is derived from code automatically generated by the nddsgen
   command:

   /usr/mwagner/nomad/src/SAS/messages/targetAcq/nddsgen targetAcqMsgs.x -publicationType targetAcqRequest -publicationType targetAcqReply -example i86Linux5.1=server
 */

static char copyright_rti[] = 
"(c) Copyright, Real-Time Innovations, Inc., 1994-8.  All rights reserved.";

/*
DESCRIPTION:
Example subscription which was automatically generated by 'nddsgen'.  To test 
them follow these steps:
(1) Compile this file and the example publisher.
(2) Start NDDS with nddsStartDaemon -d <domain> on the machines where
    the test will be run. For more details see the man page on nddsStartDaemon.
(3) Make sure your environment variable NDDS_PEER_HOSTS is set to at least
    contain the machines where the test will be run.
(4) Start the publisher on the same domain used for NDDS with the command
    objs/i86Linux5.1=server/targetAcqMsgs_publisher <domain>
(5) Start the subscription on the same domain used for NDDS with the command
    objs/i86Linux5.1=server/targetAcqMsgs_subscription <domain>

--------------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#include "ndds/NDDS.h"
#include "targetAcqMsgs.h"

RTIBool targetAcqRequestCallback(NDDSRecvInfo *issue)
{
    targetAcqRequest *item = (targetAcqRequest *)issue->instance;
#if 0
    NddsRecvInfoPrint(issue, 3, 0);
#endif /* 0 */

    targetAcqRequestPrint(item);

    return RTI_TRUE;
}


void subscriberMain(int nddsDomain)
{
    float          deadline       = 10.0f;
    float          min_separation = 0.0f;
    NDDSSubscription subscription;
    targetAcqRequest  *item1 = NULL;


    NddsInit(nddsDomain, NULL);

    targetAcqRequestNddsRegister();

    /* Allocate strings and custom structures here. */
    {
	item1 = (targetAcqRequest *)calloc(1, sizeof(targetAcqRequest));

	/* Your initialization code goes here! */
    }

    subscription = NddsSubscriptionCreate(NDDS_SUBSCRIPTION_IMMEDIATE,
				          "Example targetAcqRequest", 
				          targetAcqRequestPublicationType, item1,
				          deadline, min_separation,
				          targetAcqRequestCallback, NULL);

    while (1) {
        /* NddsSubscriptionPoll(subscription); 
	   Only needed if NDDS_SUBSCRIBER_POLLED*/

	/* 
	 * We sleep only to kill time.  Nothing need be done here 
	 *  for an NDDS_SUBSCRIBER_IMMEDIATE subscription. 
	 */
	printf("Sleeping for %f sec...\n", deadline);
	NddsUtilitySleep(deadline);
    }
}

#ifndef RTI_VXWORKS
void main(int argc, char *argv[])
{
    int   nddsDomain = NDDSDomainDefault;

    if (argc >=2) {
	nddsDomain = atoi(argv[1]);
    }

    subscriberMain(nddsDomain);
}
#endif
