/* targetAcqMsgs_server.c \- A server example.

   This file is derived from code automatically generated by the nddsgen
   command:

   /usr/mwagner/nomad/src/SAS/messages/targetAcq/nddsgen targetAcqMsgs.x -publicationType targetAcqRequest -publicationType targetAcqReply -example i86Linux5.1:client
 */

static char copyright_rti[] = 
"(c) Copyright, Real-Time Innovations, Inc., 1994-8.  All rights reserved.";

/*
DESCRIPTION:
  Example server which is automatically generated by 'nddsgen'. To test them 
  follow these steps:

(1) Compile this file and the example client.
(2) Start NDDS with nddsStartDaemon -d <domain> on the machines where
    the test will be run. For more details see the man page on nddsStartDaemon.
(3) Make sure your environment variable NDDS_PEER_HOSTS is set to at least
    contain the machines where the test will be run.
(4) Start the client on the same domain used for NDDS with the command
    objs/i86Linux5.1/targetAcqMsgs_client <domain>
(5) Start the server on the same domain used for NDDS with the command
    objs/i86Linux5.1/targetAcqMsgs_server <domain>

--------------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#include "ndds/NDDS.h"
#include "targetAcqMsgs.h"

RTIBool ServerRoutine(NDDSObjectInstance reply, 
		   NDDSObjectInstance request,
		   void *userData)
{
    targetAcqReply   *itemReply   = (targetAcqReply *)reply;
    targetAcqRequest *itemRequest = (targetAcqRequest *)request;

    targetAcqRequestPrint(itemRequest);

    /* modify the data replied here */

    /*
     * If you return a RTI_TRUE value then the reply will be sent. 
     * If you return RTI_FALSE then the reply will not be sent.
     */
    return RTI_TRUE; 
}


void serverMain(int nddsDomain)
{
    float strength       = 1.0f;
    double sleepTime     = 10.0f;
    NDDSServer          server       = NULL;
    targetAcqReply   *itemReply   = NULL;
    targetAcqRequest *itemRequest = NULL;

    NddsInit(nddsDomain, NULL);

    targetAcqReplyNddsRegister();
    targetAcqRequestNddsRegister();

    itemReply   = (targetAcqReply *)calloc(1, sizeof(targetAcqReply));
    itemRequest = (targetAcqRequest *)calloc(1, sizeof(targetAcqRequest));

    printf("User initialization of targetAcqRequest and targetAcqReply.\n");
    {
        /* Your initialization code goes here! */
    }

    NddsServerCreate("Service1", NDDS_SERVER_IMMEDIATE, strength, 
	             itemReply, itemRequest, 
		     targetAcqReplyPublicationType, 
		     targetAcqRequestPublicationType, ServerRoutine, NULL);

    while (1) {
	printf("Sleeping for %f sec...\n", sleepTime);
	NddsUtilitySleep(sleepTime);
    }
}

#ifndef RTI_VXWORKS
void main(int argc, char *argv[])
{
    int   nddsDomain     = NDDSDomainDefault;

    if (argc >=2) {
	nddsDomain = atoi(argv[1]);
    }

    serverMain(nddsDomain);
}
#endif
