/* targetAcqRequest_publication.c \- A publication of data of type targetAcqRequest

   This file is derived from code automatically generated by the nddsgen 
   command:

   /usr/mwagner/nomad/src/SAS/messages/targetAcq/nddsgen targetAcqMsgs.x -publicationType targetAcqRequest -publicationType targetAcqReply -example i86Linux5.1=server
 */

static char copyright_rti[] = 
"(c) Copyright, Real-Time Innovations, Inc., 1994-8.  All rights reserved.";

/*
DESCRIPTION:
Example publication of type targetAcqRequest automatically generated by 'nddsgen'
To test them follow these steps:

(1) Compile this file and the example publication.
(2) Start NDDS with nddsStartDaemon -d <domain> on the machines where
    the test will be run. For more details see the man page on nddsStartDaemon.
(3) Make sure your environment variable NDDS_PEER_HOSTS is set to at least
    contain the machines where the test will be run.
(4) Start the publication on the same domain used for NDDS with the command
    objs/i86Linux5.1=server/targetAcqRequest_subscriber <domain>
(5) Start the publication on the same domain used for NDDS with the command
    objs/i86Linux5.1=server/targetAcqRequest_publication <domain>

--------------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#include "ndds/NDDS.h"
#include "targetAcqMsgs.h"

void publisherMain(int nddsDomain)
{
    int          count           = 0;  
    float        send_period_sec = 4.0f; /* 4 seconds */
    float        persistence     = 15.0f;
    float        strength        = 1.0f;
    NDDSPublication publication;
    targetAcqRequest *item1;

    NddsInit(nddsDomain, NULL);

    targetAcqRequestNddsRegister();

    item1 = (targetAcqRequest *)calloc(1, sizeof(targetAcqRequest));
    printf("User Initialization of a targetAcqRequest\n");
    {
	/* Your initialization code goes here! */
    }
       
    publication = NddsPublicationCreate("Example targetAcqRequest", 
				      targetAcqRequestPublicationType, item1, 
				      persistence, strength);

    for (count=0;;count++) {
	printf("Sampling publication, count %d\n", count);

	/* modify the samples produced here */

	NddsPublicationSend(publication);
	NddsUtilitySleep(send_period_sec);
    }
}


#ifndef RTI_VXWORKS
void main(int argc, char *argv[])
{
    int nddsDomain = NDDSDomainDefault;

    if (argc >=2) {
	nddsDomain = atoi(argv[1]);
    }
    publisherMain(nddsDomain);
}
#endif
