/* targetAcqMsgs_client.c \- A client example.

  This file is derived from code automatically generated by the nddsgen
  command:

  /usr/mwagner/nomad/src/SAS/messages/targetAcq/nddsgen targetAcqMsgs.x -publicationType targetAcqRequest -publicationType targetAcqReply -example i86Linux5.1:client
 */

static char copyright_rti[] = 
"(c) Copyright, Real-Time Innovations, Inc., 1994-8.  All rights reserved.";

/*
DESCRIPTION:
  Example client which is automatically generated by 'nddsgen'. To test them 
  follow these steps:

(1) Compile this file and the example client.
(2) Start NDDS with nddsStartDaemon -d <domain> on the machines where
    the test will be run. For more details see the man page on nddsStartDaemon.
(3) Make sure your environment variable NDDS_PEER_HOSTS is set to at least
    contain the machines where the test will be run.
(4) Start the client on the same domain used for NDDS with the command
    objs/i86Linux5.1/targetAcqMsgs_client <domain>
(5) Start the server on the same domain used for NDDS with the command
    objs/i86Linux5.1/targetAcqMsgs_server <domain>

--------------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#include "ndds/NDDS.h"
#include "targetAcqMsgs.h"

void clientMain(int nddsDomain, int func)
{
    int   count          = 0;
    float minWaitTime    = 2.0f;
    float maxWaitTime    = 5.0f;
    NDDSClient          client;
    NDDSClientReplyStatus    clientStatus;
    targetAcqReply   *itemReply   = NULL;
    targetAcqRequest *itemRequest = NULL;

    NddsInit(nddsDomain, NULL);

    targetAcqReplyNddsRegister();
    targetAcqRequestNddsRegister();

    client = NddsClientCreate("targetAcqService", 
			      targetAcqReplyPublicationType,
			      targetAcqRequestPublicationType);
		
    itemReply   = (targetAcqReply *)calloc(1, sizeof(targetAcqReply));
    itemRequest = (targetAcqRequest *)calloc(1, sizeof(targetAcqRequest));
    /* The following alloc. is required for strings and custom structures */
    {
	/* Allocate strings and custom structures here */

    }

 
        /* modify the data requested here */
	itemRequest->period = 1.0;
	itemRequest->driverNum  = 0;
	itemRequest->function = func;

	clientStatus = NddsClientCallAndWait(client, itemReply, itemRequest, 
					     minWaitTime, maxWaitTime);

	if (clientStatus == NDDS_CLIENT_RECV_REPLY) {
            targetAcqReplyPrint(itemReply);
        } else if (clientStatus == NDDS_CLIENT_ERROR) {
	    NddsUtilitySleep(2.0);
        }
}

#ifndef RTI_VXWORKS
void main(int argc, char *argv[])
{
    int nddsDomain     = NDDSDomainDefault; 

    if(argc != 3) {
	printf("usage: targetAcqMsgs_client NDDSDomain func\n");
	return;
    }
    clientMain(atoi(argv[1]), atoi(argv[2]));
}
#endif
