/* CREATED: 5/22/99
 * AUTHOR: Michael Wagner
 *
 * DESCRIPTION:
 *   These NDDS messages deal with communication between the target acqusition module
 *   and the other processes.
 */

/* Information needed in the nddsgen .h files */
%#include "acqDriverDef.h"

struct targetAcqRequest {
  char function;   /* See targetAcqDef.h, but this basically tells the
		      module to start or stop */
  int driverNum;   /* The acqusition driver numbers are 
		      selected by the target acq module. */
  float period;    /* How often acquisition should be attempted (UNUSED!) */
};

struct targetAcqReply {
  int status;
};

struct targetAcqComplete {
  int status; /* See targetAcqDef.h */
  int newTargetIDs[MAX_TARGETS_IN_ACQ_DATA];
  int numTargets;
};

