#include <stdio.h>
#include <stdlib.h>
#include "ndds/NDDS.h"
#include "sensorMsgs.h"
#include "sensorDef.h"
#include "nddsMsgNames.h"
#include "posDerivedState.h"

#ifndef PI
#define PI 3.14159265359
#endif

#define TELEMETRY_DEADLINE 10.0f
#define TELEMETRY_MIN_SEPARATION 0.0f 

posDerivedState pos;

RTIBool telemetryCallback(NDDSRecvInfo *issue) {
  posDerivedState *item = (posDerivedState *)issue->instance;
  
  if (issue->status == NDDS_FRESH_DATA) {
    memcpy(&pos, item, sizeof(posDerivedState));
  }
  
  return(RTI_TRUE);
}

void clientMain(char *serviceName, int function) {
  int   count          = 0;
  float minWaitTime    = 2.0f;
  float maxWaitTime    = 5.0f;
  NDDSClient          client;
  NDDSClientReplyStatus    clientStatus;
  sensorReply   *itemReply   = NULL;
  sensorRequest *itemRequest = NULL;
  int coordType;
  char tmpBuff[1000];
  
  printf("Creating \"%s\" client...", serviceName);
  client = NddsClientCreate(serviceName, 
			    sensorReplyPublicationType,
			    sensorRequestPublicationType);
  
  itemReply   = (sensorReply *)calloc(1, sizeof(sensorReply));
  itemReply->sensorID = (char *)calloc(SENSOR_MAX_ID_LENGTH, sizeof(char));
  itemRequest = (sensorRequest *)calloc(1, sizeof(sensorRequest));
  itemRequest->sensorID = (char *)calloc(SENSOR_MAX_ID_LENGTH, sizeof(char));
  if(NddsClientServerWait(client, 2.0, 5, 1) == RTI_FALSE) { 
    printf("could not contact server \"%s\"!\n", serviceName);
    return;
  } 
  printf("done!\n");

  itemRequest->function = function;

  if(function == SENSOR_DEPLOY_FUNCTION) {
    printf("Do you want:\n  (1) Absolute DGPS coordinates\n  (2)Relative DGPS corrdinates\n? ");
    scanf("%d", &coordType);
    printf("Target X: ");
    scanf("%f", &itemRequest->data.DGPS_coord.x);
    printf("Target Y: ");
    scanf("%f", &itemRequest->data.DGPS_coord.y);
    printf("Target Z: ");
    scanf("%f", &itemRequest->data.DGPS_coord.z);
  }

  if(coordType == 1) {
    itemRequest->robotPosition.x = pos.posWest / -100.0;
    itemRequest->robotPosition.y = pos.posNorth / 100.0;
    itemRequest->robotPosition.z = pos.posUp / 100.0;
    itemRequest->robotPose.pitch = pos.rotX / 100.0;
    itemRequest->robotPose.roll  = pos.rotY / 100.0;
    itemRequest->robotPose.yaw   = 2 * PI - pos.rotZ / 100.0;
  } else {
    itemRequest->robotPosition.x = 0.0;
    itemRequest->robotPosition.y = 0.0;
    itemRequest->robotPosition.z = 0.0;
    itemRequest->robotPose.pitch = 0.0;
    itemRequest->robotPose.roll  = 0.0;
    itemRequest->robotPose.yaw   = 0.0;
  }

  clientStatus = NddsClientCallAndWait(client, itemReply, itemRequest, 
				       minWaitTime, maxWaitTime);
  
  if (clientStatus == NDDS_CLIENT_RECV_REPLY) {
    switch(function) {
    case SENSOR_ACQUIRE_DATA_FUNCTION:
      strncpy(tmpBuff, itemReply->data.sensorData.dataFilenames, strlen(itemReply->data.sensorData.dataFilenames) - 1);
      strcat(tmpBuff, "\0");
      printf("Sensor read data into file: %s\n", tmpBuff);
      break;
    }
  } else if (clientStatus == NDDS_CLIENT_ERROR) {
    printf("ERROR! Returned %d\n", clientStatus);
  }
}

int main(int argc, char *argv[]) {
  NDDSSubscription posDerivedStateSub;
  posDerivedState *posDerivedStateMsg = NULL;

  if (argc != 4) {
    printf("Usage: sensorMsgs_client nddsDomain sensorID function\n");
    return(-1);
  } 

  NddsInit(atoi(argv[1]), NULL);
  
  sensorReplyNddsRegister();
  sensorRequestNddsRegister();
  posDerivedStateNddsRegister();
  
  posDerivedStateMsg = (posDerivedState *)calloc(1, sizeof(posDerivedState));
  posDerivedStateSub = NddsSubscriptionCreate(NDDS_SUBSCRIPTION_IMMEDIATE,
					      POS_DERIVED_STATE_MSG_NAME, posDerivedStatePublicationType,
					      posDerivedStateMsg, TELEMETRY_DEADLINE,
					      TELEMETRY_MIN_SEPARATION, telemetryCallback, NULL);

  clientMain(argv[2], atoi(argv[3]));
}

