/* CREATED: 4/12/99
 * AUTHOR: Michael Wagner
 *
 * DESCRIPTION:
 *   These NDDS messages deal with communication to the sensor drivers. 
 */

/* Information needed in the nddsgen .h files */
%#include "dbRecord.h"
%#include "sensorDef.h"

/* NDDS MESSAGE NAME: sensorRequest
 * CREATED: 4/12/99
 * AUTHOR: Michael Wagner
 * SOURCE: Sensor Manager
 * DESTINATION: Any sensor driver
 *
 * DESCRIPTION:
 *   This message is sent from the Sensor Manager to a sensor driver to
 *   request that a function be performed.
 */

struct sensorRequest {
  string sensorID<SENSOR_MAX_ID_LENGTH>;
  int function;        /* See the file sensorDef.h */
  int sensorNum;

  DGPS robotPosition;
  pose robotPose;

  dbRecord data;  /* A current snapshot of the database record being
		     affected by the sensor. */
};

/* NDDS MESSAGE NAME: sensorReply
 * CREATED: 4/12/99
 * AUTHOR: Michael Wagner
 * SOURCE: Any sensor driver
 * DESTINATION: Sensor Manager
 *
 * DESCRIPTION:
 *   This message replies to a Sensor Manager request with the sensor
 *   driver status. 
 */

struct sensorReply {
  string sensorID<SENSOR_MAX_ID_LENGTH>;
  int function;       /* What function the sensor driver performed. 
			 See the file sensorDef.h */
  int status;         /* The generic status of the sensor driver. See the file
			 sensorDef.h */
  int extendedStatus; /* Sensor specific status, if any. Should be 0 if
		         no specific status is needed. See a specific
			 driver's definition header files. */
			 
  /* These fields contain the updated record to be placed back in the 
     database. The changedFields variable denotes what fields have
     been altered by the sensor driver. */
  dbRecord        data;
  dbRecordBitMask changedFields;

  /* Costs */
  float timeCost;          /* second */
  float energyCost;        /* joules */
  float storageCost;       /* kB */

  /* Workspace */
  float maxDistanceTolerance; /* meters */
  float minDistanceTolerance; /* meters */
  float angularTolerance;  /* radians */
};

struct sensorReg {
  string sensorID<SENSOR_MAX_ID_LENGTH>;
  int status;
};

