/* mangen sensorMsgs \- NDDS methods for sensorMsgs type.
   banner = ==========
  
   This file is derived from code automatically generated by nddsgen.
 */

static char copyright_rti[] = 
"(c) Copyright, Real-Time Innovations, Inc., 1994.  All rights reserved.";

/*
DESCRIPTION:
  This file was automatically generated by the 'nddsgen' code generator from the
  XDR file sensorMsgs.x.  See the man pages on 'nddsgen' and 'NddsXDR'.

  This file was generated with the following steps:

(1) One or more XDR descriptions where written into a file named 
    sensorMsgs.x (NOTE: the .x termination which is standard for this 
    files is required.). This description uses the XDR language,
    which resembles "C"-like structure-type declarations. More information 
    and examples on how to write these ".x" files can be found in the 
    on-line html page for 'nddsgen'.

(2) 'nddsgen' was run on the sensorMsgs.x file. The command was:
    /usr/mwagner/nomad/src/SAS/messages/sensors/nddsgen sensorMsgs.x -publicationType sensorRequest -publicationType sensorReply -publicationType sensorReg -replace

    This created the sensorMsgs.c, and sensorMsgs.h.

(3) The sensorMsgs_stub.c is copied into sensorMsgs.c;
    if you pass "-replace" during nddsgen. This file contains the functions, 
    NddsTypeNameSeralize(), NddsTypeNameDeserialize(), and NddsTypeNamePrint() 
    for each NDDS type.

(4) The user may want to fill in the code for the NddsTypeNamePrint()
    function if they want NDDS to print the NddsTypeName automatically
    in certain situations. This isn't required.

(5) The file sensorMsgs.c also contains functions to register, and 
    test NDDS types.

SEE ALSO:
  nddsgen(1), NddsXDR(2), Ndds(2)
--------------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <rpc/types.h>
#include <rpc/xdr.h>

#include "sensorMsgs.h"
#include "dbRecord.h"
#include "sensorDef.h"


int NddsXDRSerializeSize_sensorRequest()
{
    int size = 0;
    size += NddsXDRSerializeSize_string(SENSOR_MAX_ID_LENGTH); /* sensorID */
    size += NddsXDRSerializeSize_int(); /* function */
    size += NddsXDRSerializeSize_int(); /* sensorNum */
    size += NddsXDRSerializeSize_DGPS(); /* robotPosition */
    size += NddsXDRSerializeSize_pose(); /* robotPose */
    size += NddsXDRSerializeSize_dbRecord(); /* data */
    return size;
}




bool_t
NddsXDRPrint_sensorRequest(sensorRequest *objp, char *desc, int indent)
{
    int i;
    for (i=0; i<indent; i++) { printf("  "); }
    printf("%s:\n", desc);

    if (!NddsXDRPrint_string(objp->sensorID, "sensorID", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_int(&objp->function, "function", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_int(&objp->sensorNum, "sensorNum", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_DGPS(&objp->robotPosition, "robotPosition", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_pose(&objp->robotPose, "robotPose", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_dbRecord(&objp->data, "data", indent+1)) {
        return (FALSE);
    }
    return (TRUE);
}




bool_t
xdr_sensorRequest(XDR *xdrs, sensorRequest *objp)
{
    if (!xdr_string_safe(xdrs, &objp->sensorID, SENSOR_MAX_ID_LENGTH)) {
    	return (FALSE);
    }
    if (!xdr_int(xdrs, &objp->function)) {
    	return (FALSE);
    }
    if (!xdr_int(xdrs, &objp->sensorNum)) {
    	return (FALSE);
    }
    if (!xdr_DGPS(xdrs, &objp->robotPosition)) {
    	return (FALSE);
    }
    if (!xdr_pose(xdrs, &objp->robotPose)) {
    	return (FALSE);
    }
    if (!xdr_dbRecord(xdrs, &objp->data)) {
    	return (FALSE);
    }
    return (TRUE);
}




int NddsXDRSerializeSize_sensorReply()
{
    int size = 0;
    size += NddsXDRSerializeSize_string(SENSOR_MAX_ID_LENGTH); /* sensorID */
    size += NddsXDRSerializeSize_int(); /* function */
    size += NddsXDRSerializeSize_int(); /* status */
    size += NddsXDRSerializeSize_int(); /* extendedStatus */
    size += NddsXDRSerializeSize_dbRecord(); /* data */
    size += NddsXDRSerializeSize_dbRecordBitMask(); /* changedFields */
    size += NddsXDRSerializeSize_float(); /* timeCost */
    size += NddsXDRSerializeSize_float(); /* energyCost */
    size += NddsXDRSerializeSize_float(); /* storageCost */
    size += NddsXDRSerializeSize_float(); /* maxDistanceTolerance */
    size += NddsXDRSerializeSize_float(); /* minDistanceTolerance */
    size += NddsXDRSerializeSize_float(); /* angularTolerance */
    return size;
}




bool_t
NddsXDRPrint_sensorReply(sensorReply *objp, char *desc, int indent)
{
    int i;
    for (i=0; i<indent; i++) { printf("  "); }
    printf("%s:\n", desc);

    if (!NddsXDRPrint_string(objp->sensorID, "sensorID", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_int(&objp->function, "function", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_int(&objp->status, "status", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_int(&objp->extendedStatus, "extendedStatus", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_dbRecord(&objp->data, "data", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_dbRecordBitMask(&objp->changedFields, "changedFields", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_float(&objp->timeCost, "timeCost", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_float(&objp->energyCost, "energyCost", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_float(&objp->storageCost, "storageCost", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_float(&objp->maxDistanceTolerance, "maxDistanceTolerance", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_float(&objp->minDistanceTolerance, "minDistanceTolerance", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_float(&objp->angularTolerance, "angularTolerance", indent+1)) {
        return (FALSE);
    }
    return (TRUE);
}




bool_t
xdr_sensorReply(XDR *xdrs, sensorReply *objp)
{
    if (!xdr_string_safe(xdrs, &objp->sensorID, SENSOR_MAX_ID_LENGTH)) {
    	return (FALSE);
    }
    if (!xdr_int(xdrs, &objp->function)) {
    	return (FALSE);
    }
    if (!xdr_int(xdrs, &objp->status)) {
    	return (FALSE);
    }
    if (!xdr_int(xdrs, &objp->extendedStatus)) {
    	return (FALSE);
    }
    if (!xdr_dbRecord(xdrs, &objp->data)) {
    	return (FALSE);
    }
    if (!xdr_dbRecordBitMask(xdrs, &objp->changedFields)) {
    	return (FALSE);
    }
    if (!xdr_float(xdrs, &objp->timeCost)) {
    	return (FALSE);
    }
    if (!xdr_float(xdrs, &objp->energyCost)) {
    	return (FALSE);
    }
    if (!xdr_float(xdrs, &objp->storageCost)) {
    	return (FALSE);
    }
    if (!xdr_float(xdrs, &objp->maxDistanceTolerance)) {
    	return (FALSE);
    }
    if (!xdr_float(xdrs, &objp->minDistanceTolerance)) {
    	return (FALSE);
    }
    if (!xdr_float(xdrs, &objp->angularTolerance)) {
    	return (FALSE);
    }
    return (TRUE);
}




int NddsXDRSerializeSize_sensorReg()
{
    int size = 0;
    size += NddsXDRSerializeSize_string(SENSOR_MAX_ID_LENGTH); /* sensorID */
    size += NddsXDRSerializeSize_int(); /* status */
    return size;
}




bool_t
NddsXDRPrint_sensorReg(sensorReg *objp, char *desc, int indent)
{
    int i;
    for (i=0; i<indent; i++) { printf("  "); }
    printf("%s:\n", desc);

    if (!NddsXDRPrint_string(objp->sensorID, "sensorID", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_int(&objp->status, "status", indent+1)) {
        return (FALSE);
    }
    return (TRUE);
}




bool_t
xdr_sensorReg(XDR *xdrs, sensorReg *objp)
{
    if (!xdr_string_safe(xdrs, &objp->sensorID, SENSOR_MAX_ID_LENGTH)) {
    	return (FALSE);
    }
    if (!xdr_int(xdrs, &objp->status)) {
    	return (FALSE);
    }
    return (TRUE);
}


/* ========================================================================
   sensorRequestSerialize \- NDDS serialization method for sensorRequest

   Required NDDS method to serialize an sensorRequest into NDDSXDRStream 
   buffer.
   The data will be deserialized by the sensorRequestDeserialize() function.

   The 'options' may be defined and used for customizing serialization
   for different situations. Often (as in this case) they are simply 
   ignored.
 */
RTIBool sensorRequestSerialize(NDDSXDRStream nddsds, 
			   sensorRequest *nddssensorRequest,
			   int options)
{
    return xdr_sensorRequest(NddsXDRGetSerializingStream(nddsds),
			       nddssensorRequest);
}

/* ========================================================================
   sensorRequestDeserialize \- NDDS deserialization method for sensorRequest 
   
   Required NDDS method to deserialize the data from an NDDSXDRStream buffer.
   The data was serialized by the sensorRequestSerialize() function.

   If outArray==NULL (null pointer), this function will create a
   sensorRequest of the appropriate size to hold the data 
   (as required by NDDS).

   Returns the output array or NULL if an error occurred
 */
sensorRequest *sensorRequestDeserialize(sensorRequest *nddssensorRequest,
				      NDDSXDRStream nddsds)
{
    int allocated = RTI_FALSE;

    if (nddssensorRequest == NULL) {
	allocated = RTI_TRUE;
	nddssensorRequest =(sensorRequest *)calloc(1, sizeof(sensorRequest));
    }

    if (!xdr_sensorRequest(NddsXDRGetDeserializingStream(nddsds),
			     nddssensorRequest))  {
	if (allocated) {
	    free(nddssensorRequest);
	}
	return NULL;
    }
    
    return nddssensorRequest;
}

/* ========================================================================
   sensorRequestPrint \- NDDS Print method for sensorRequest objects

   Optional NDDS method to print the contents of an sensorRequest.

   Note that if this method *must* handle the case where the object
   is NULL.
 */
sensorRequest *sensorRequestPrint(sensorRequest *nddssensorRequest)
{
    /* Do not remove. sensorRequestPrint must handle a NULL 
       sensorRequest 
       */
    if (nddssensorRequest==NULL) {
	printf("sensorRequest: (null)\n");
	return NULL;
    }

    /* Replace by custom code if desired */
    if (!NddsXDRPrint_sensorRequest(nddssensorRequest, "sensorRequest", 0)) {
	printf("NddsXDRPrintsensorRequest() failed on %p\n", 
	       nddssensorRequest);
	return NULL;
    }

    /* Do not remove the return value */
    return nddssensorRequest;
}

/* ========================================================================
   sensorRequestSerializeSize \- NDDS size method for sensorRequest objects
 
   This optional NDDS method returns the maximum size of a sensorRequest object.
   The purpose of this method is to allow NDDS to optimize its memory usage.
 
   Users must be very careful and return a size that is equal-to or larger 
   than the maximum sensorRequest serialized. Please refer to NddsXdr(2) for
   functions to help determin the serialized size of basic types.

   If a -1 is returned then NDDS will default to a safe size, but will not
   be optimal.
 */
int sensorRequestSerializeSize()
{
    return NddsXDRSerializeSize_sensorRequest();
}


/* ========================================================================
   sensorRequestAllocate \- NDDS Allocate method for sensorRequest objects

   Optional NDDS method to allocate an NDDS object of type sensorRequest.

   If registered within sensorRequestNddsRegister(), this method will be 
   invoked as a result of pattern subscriptions. When the NDDS agent 
   subscribes to a publication that matches the requested pattern, it
   needs to create a new object of the corresponding type to hold the 
   updates when they come. 
   It is for this purpose that sensorRequestAllocate() is used.

   This method is not always required because sensorRequestDeserialize()
   is usually able to allocate the object itself. There are however
   some cases (notably strings) for which the allocation provided
   by sensorRequestDeserialize() isn't sufficient. Registration
   of sensorRequestAllocate() allows to override the default allocation
   provided by sensorRequestDeserialize().

   If this method is to be used, it must passed to NddsTypeRegister()
   (in function sensorRequestNddsRegister()) instead of the default
   NULL method.

   This routine gets passed the type and name of the object instance and
   the parameter provided by the user passed in the 
   NddsSubscriptionGroupSubscriptionAdd(3) call.
 */
sensorRequest *sensorRequestAllocate(const char *type, const char *name,
				   void *userParam)
{
    sensorRequest *nddssensorRequest = NULL;

    nddssensorRequest = (sensorRequest *)calloc(1, sizeof(*nddssensorRequest));
    {
	/* Add the custom allocation of entries in the structure here */
    }

    return nddssensorRequest;
}

/* ========================================================================
   sensorRequestFree \- NDDS Free method for sensorRequest objects

   Optional NDDS method to Free an NDDS object of type sensorRequest.

   This method is not used in the current version of NDDS.
 */
RTIBool sensorRequestFree(sensorRequest *inst, const char *type, const char *name,
		      void *userParam)
{
    return RTI_TRUE;
}

/* ========================================================================
   sensorRequestNddsRegister \- Install sensorRequest type to NDDS
   
   This function will register an sensorRequest type with NDDS.   
   Registration must happen before any reference to the sensorRequest 
   type is given to NDDS.

   A description of the type sensorRequest was written in a file
   named sensorRequest.x (NOTE: the .x termination which is standard
   for this files is required.). This description uses the XDR language,
   which resembles "C"-like structure-type declarations. More information
   and examples on how to write these ".x" files can be found in the
   man page for 'nddsgen'.
 
   nddsgen was run on the sensorMsgs.x file. See the man pages
   on nddsgen and sensorMsgs for details.
 */
void sensorRequestNddsRegister(void)
{
   NddsTypeRegister(sensorRequestPublicationType,
	/*A #define in sensorMsgs.h*/
		    (SerializeMethodType)sensorRequestSerialize,
		    (DeserializeMethodType)sensorRequestDeserialize,
		    (PrintMethodType)sensorRequestPrint,
		    (AllocateMethodType)NULL,
		    (FreeMethodType)NULL,
		    (SerializeSizeMethodType)sensorRequestSerializeSize);
}
/* ========================================================================
   sensorReplySerialize \- NDDS serialization method for sensorReply

   Required NDDS method to serialize an sensorReply into NDDSXDRStream 
   buffer.
   The data will be deserialized by the sensorReplyDeserialize() function.

   The 'options' may be defined and used for customizing serialization
   for different situations. Often (as in this case) they are simply 
   ignored.
 */
RTIBool sensorReplySerialize(NDDSXDRStream nddsds, 
			   sensorReply *nddssensorReply,
			   int options)
{
    return xdr_sensorReply(NddsXDRGetSerializingStream(nddsds),
			       nddssensorReply);
}

/* ========================================================================
   sensorReplyDeserialize \- NDDS deserialization method for sensorReply 
   
   Required NDDS method to deserialize the data from an NDDSXDRStream buffer.
   The data was serialized by the sensorReplySerialize() function.

   If outArray==NULL (null pointer), this function will create a
   sensorReply of the appropriate size to hold the data 
   (as required by NDDS).

   Returns the output array or NULL if an error occurred
 */
sensorReply *sensorReplyDeserialize(sensorReply *nddssensorReply,
				      NDDSXDRStream nddsds)
{
    int allocated = RTI_FALSE;

    if (nddssensorReply == NULL) {
	allocated = RTI_TRUE;
	nddssensorReply =(sensorReply *)calloc(1, sizeof(sensorReply));
    }

    if (!xdr_sensorReply(NddsXDRGetDeserializingStream(nddsds),
			     nddssensorReply))  {
	if (allocated) {
	    free(nddssensorReply);
	}
	return NULL;
    }
    
    return nddssensorReply;
}

/* ========================================================================
   sensorReplyPrint \- NDDS Print method for sensorReply objects

   Optional NDDS method to print the contents of an sensorReply.

   Note that if this method *must* handle the case where the object
   is NULL.
 */
sensorReply *sensorReplyPrint(sensorReply *nddssensorReply)
{
    /* Do not remove. sensorReplyPrint must handle a NULL 
       sensorReply 
       */
    if (nddssensorReply==NULL) {
	printf("sensorReply: (null)\n");
	return NULL;
    }

    /* Replace by custom code if desired */
    if (!NddsXDRPrint_sensorReply(nddssensorReply, "sensorReply", 0)) {
	printf("NddsXDRPrintsensorReply() failed on %p\n", 
	       nddssensorReply);
	return NULL;
    }

    /* Do not remove the return value */
    return nddssensorReply;
}

/* ========================================================================
   sensorReplySerializeSize \- NDDS size method for sensorReply objects
 
   This optional NDDS method returns the maximum size of a sensorReply object.
   The purpose of this method is to allow NDDS to optimize its memory usage.
 
   Users must be very careful and return a size that is equal-to or larger 
   than the maximum sensorReply serialized. Please refer to NddsXdr(2) for
   functions to help determin the serialized size of basic types.

   If a -1 is returned then NDDS will default to a safe size, but will not
   be optimal.
 */
int sensorReplySerializeSize()
{
    return NddsXDRSerializeSize_sensorReply();
}


/* ========================================================================
   sensorReplyAllocate \- NDDS Allocate method for sensorReply objects

   Optional NDDS method to allocate an NDDS object of type sensorReply.

   If registered within sensorReplyNddsRegister(), this method will be 
   invoked as a result of pattern subscriptions. When the NDDS agent 
   subscribes to a publication that matches the requested pattern, it
   needs to create a new object of the corresponding type to hold the 
   updates when they come. 
   It is for this purpose that sensorReplyAllocate() is used.

   This method is not always required because sensorReplyDeserialize()
   is usually able to allocate the object itself. There are however
   some cases (notably strings) for which the allocation provided
   by sensorReplyDeserialize() isn't sufficient. Registration
   of sensorReplyAllocate() allows to override the default allocation
   provided by sensorReplyDeserialize().

   If this method is to be used, it must passed to NddsTypeRegister()
   (in function sensorReplyNddsRegister()) instead of the default
   NULL method.

   This routine gets passed the type and name of the object instance and
   the parameter provided by the user passed in the 
   NddsSubscriptionGroupSubscriptionAdd(3) call.
 */
sensorReply *sensorReplyAllocate(const char *type, const char *name,
				   void *userParam)
{
    sensorReply *nddssensorReply = NULL;

    nddssensorReply = (sensorReply *)calloc(1, sizeof(*nddssensorReply));
    {
	/* Add the custom allocation of entries in the structure here */
    }

    return nddssensorReply;
}

/* ========================================================================
   sensorReplyFree \- NDDS Free method for sensorReply objects

   Optional NDDS method to Free an NDDS object of type sensorReply.

   This method is not used in the current version of NDDS.
 */
RTIBool sensorReplyFree(sensorReply *inst, const char *type, const char *name,
		      void *userParam)
{
    return RTI_TRUE;
}

/* ========================================================================
   sensorReplyNddsRegister \- Install sensorReply type to NDDS
   
   This function will register an sensorReply type with NDDS.   
   Registration must happen before any reference to the sensorReply 
   type is given to NDDS.

   A description of the type sensorReply was written in a file
   named sensorReply.x (NOTE: the .x termination which is standard
   for this files is required.). This description uses the XDR language,
   which resembles "C"-like structure-type declarations. More information
   and examples on how to write these ".x" files can be found in the
   man page for 'nddsgen'.
 
   nddsgen was run on the sensorMsgs.x file. See the man pages
   on nddsgen and sensorMsgs for details.
 */
void sensorReplyNddsRegister(void)
{
   NddsTypeRegister(sensorReplyPublicationType,
	/*A #define in sensorMsgs.h*/
		    (SerializeMethodType)sensorReplySerialize,
		    (DeserializeMethodType)sensorReplyDeserialize,
		    (PrintMethodType)sensorReplyPrint,
		    (AllocateMethodType)NULL,
		    (FreeMethodType)NULL,
		    (SerializeSizeMethodType)sensorReplySerializeSize);
}
/* ========================================================================
   sensorRegSerialize \- NDDS serialization method for sensorReg

   Required NDDS method to serialize an sensorReg into NDDSXDRStream 
   buffer.
   The data will be deserialized by the sensorRegDeserialize() function.

   The 'options' may be defined and used for customizing serialization
   for different situations. Often (as in this case) they are simply 
   ignored.
 */
RTIBool sensorRegSerialize(NDDSXDRStream nddsds, 
			   sensorReg *nddssensorReg,
			   int options)
{
    return xdr_sensorReg(NddsXDRGetSerializingStream(nddsds),
			       nddssensorReg);
}

/* ========================================================================
   sensorRegDeserialize \- NDDS deserialization method for sensorReg 
   
   Required NDDS method to deserialize the data from an NDDSXDRStream buffer.
   The data was serialized by the sensorRegSerialize() function.

   If outArray==NULL (null pointer), this function will create a
   sensorReg of the appropriate size to hold the data 
   (as required by NDDS).

   Returns the output array or NULL if an error occurred
 */
sensorReg *sensorRegDeserialize(sensorReg *nddssensorReg,
				      NDDSXDRStream nddsds)
{
    int allocated = RTI_FALSE;

    if (nddssensorReg == NULL) {
	allocated = RTI_TRUE;
	nddssensorReg =(sensorReg *)calloc(1, sizeof(sensorReg));
    }

    if (!xdr_sensorReg(NddsXDRGetDeserializingStream(nddsds),
			     nddssensorReg))  {
	if (allocated) {
	    free(nddssensorReg);
	}
	return NULL;
    }
    
    return nddssensorReg;
}

/* ========================================================================
   sensorRegPrint \- NDDS Print method for sensorReg objects

   Optional NDDS method to print the contents of an sensorReg.

   Note that if this method *must* handle the case where the object
   is NULL.
 */
sensorReg *sensorRegPrint(sensorReg *nddssensorReg)
{
    /* Do not remove. sensorRegPrint must handle a NULL 
       sensorReg 
       */
    if (nddssensorReg==NULL) {
	printf("sensorReg: (null)\n");
	return NULL;
    }

    /* Replace by custom code if desired */
    if (!NddsXDRPrint_sensorReg(nddssensorReg, "sensorReg", 0)) {
	printf("NddsXDRPrintsensorReg() failed on %p\n", 
	       nddssensorReg);
	return NULL;
    }

    /* Do not remove the return value */
    return nddssensorReg;
}

/* ========================================================================
   sensorRegSerializeSize \- NDDS size method for sensorReg objects
 
   This optional NDDS method returns the maximum size of a sensorReg object.
   The purpose of this method is to allow NDDS to optimize its memory usage.
 
   Users must be very careful and return a size that is equal-to or larger 
   than the maximum sensorReg serialized. Please refer to NddsXdr(2) for
   functions to help determin the serialized size of basic types.

   If a -1 is returned then NDDS will default to a safe size, but will not
   be optimal.
 */
int sensorRegSerializeSize()
{
    return NddsXDRSerializeSize_sensorReg();
}


/* ========================================================================
   sensorRegAllocate \- NDDS Allocate method for sensorReg objects

   Optional NDDS method to allocate an NDDS object of type sensorReg.

   If registered within sensorRegNddsRegister(), this method will be 
   invoked as a result of pattern subscriptions. When the NDDS agent 
   subscribes to a publication that matches the requested pattern, it
   needs to create a new object of the corresponding type to hold the 
   updates when they come. 
   It is for this purpose that sensorRegAllocate() is used.

   This method is not always required because sensorRegDeserialize()
   is usually able to allocate the object itself. There are however
   some cases (notably strings) for which the allocation provided
   by sensorRegDeserialize() isn't sufficient. Registration
   of sensorRegAllocate() allows to override the default allocation
   provided by sensorRegDeserialize().

   If this method is to be used, it must passed to NddsTypeRegister()
   (in function sensorRegNddsRegister()) instead of the default
   NULL method.

   This routine gets passed the type and name of the object instance and
   the parameter provided by the user passed in the 
   NddsSubscriptionGroupSubscriptionAdd(3) call.
 */
sensorReg *sensorRegAllocate(const char *type, const char *name,
				   void *userParam)
{
    sensorReg *nddssensorReg = NULL;

    nddssensorReg = (sensorReg *)calloc(1, sizeof(*nddssensorReg));
    {
	/* Add the custom allocation of entries in the structure here */
    }

    return nddssensorReg;
}

/* ========================================================================
   sensorRegFree \- NDDS Free method for sensorReg objects

   Optional NDDS method to Free an NDDS object of type sensorReg.

   This method is not used in the current version of NDDS.
 */
RTIBool sensorRegFree(sensorReg *inst, const char *type, const char *name,
		      void *userParam)
{
    return RTI_TRUE;
}

/* ========================================================================
   sensorRegNddsRegister \- Install sensorReg type to NDDS
   
   This function will register an sensorReg type with NDDS.   
   Registration must happen before any reference to the sensorReg 
   type is given to NDDS.

   A description of the type sensorReg was written in a file
   named sensorReg.x (NOTE: the .x termination which is standard
   for this files is required.). This description uses the XDR language,
   which resembles "C"-like structure-type declarations. More information
   and examples on how to write these ".x" files can be found in the
   man page for 'nddsgen'.
 
   nddsgen was run on the sensorMsgs.x file. See the man pages
   on nddsgen and sensorMsgs for details.
 */
void sensorRegNddsRegister(void)
{
   NddsTypeRegister(sensorRegPublicationType,
	/*A #define in sensorMsgs.h*/
		    (SerializeMethodType)sensorRegSerialize,
		    (DeserializeMethodType)sensorRegDeserialize,
		    (PrintMethodType)sensorRegPrint,
		    (AllocateMethodType)NULL,
		    (FreeMethodType)NULL,
		    (SerializeSizeMethodType)sensorRegSerializeSize);
}
