/* CREATED: 4/23/99
 * AUTHOR: Michael Wagner
 *
 * DESCRIPTION:
 *   These NDDS messages deal with communication between the Sensor Manager
 *   and the Mission Planner. 
 */

/* NDDS MESSAGE NAME: sensManRequest
 * CREATED: 4/23/99
 * AUTHOR: Michael Wagner
 * SOURCE: Mission Planner
 * DESTINATION: Sensor Manager
 *
 * DESCRIPTION:
 *    This message is sent from the Mission Planner in SAS
 *  identification mode.
 */

struct sensManRequest {
  int targetID;  /* Database target ID. */
  int driverNum; /* Unique driver num's assigned by sensor manager. */
  int mode;  /* See sensManDef.h for enumerations. */
};

/* NDDS MESSAGE NAME: sensManReply
 * CREATED: 4/23/99
 * AUTHOR: Michael Wagner
 * SOURCE: Sensor Manager
 * DESTINATION: Mission Planner
 *
 * DESCRIPTION:
 *    This message is sent from the Sensor Manager in reply to 
 *  a sensManRequest.
 */

struct sensManReply {
  int status; /* See sensManDef.h for enum. */
  int reqNum; /* A unique number for each request. */
};

/* NDDS MESSAGE NAME: sensManComplete
 * CREATED: 5/13/99
 * AUTHOR: Michael Wagner
 * SOURCE: Sensor Manager
 * DESTINATION: Any
 *
 * DESCRIPTION:
 *    This message is sent by the Sensor Manager when a command
 *  requested in a sensManRequest message is done.
 */

struct sensManComplete {
  int status; /* See sensManDef.h for enum. */
  int reqNum; /* A unique number for each request. */
  float timeCost;          /* second */
  float energyCost;        /* joules */
  float maxDistanceTolerance; /* meters */
  float minDistanceTolerance; /* meters */
  float angularTolerance;  /* radians */
};

