/* CREATED: 6/28/99
 * AUTHOR: Kim Shillcutt
 *
 * DESCRIPTION:
 *  The navManRequest message updates the settings of the navigation
 *  manager such as task mode, coverage mode, etc....  It is sent
 *  by the mission planner module.
 *
 *  The navManReply message returns confirmation that the request
 *  has been received.
 *
 *  The navManComplete message returns notice that the task has
 *  been finished.
 */

%#include "PlanParams.h"

struct navManRequest {
  PlanParams plan0;
  PlanParams plan1;
  PlanParams plan2;
  PlanParams plan3;
  PlanParams plan4;
};

struct navManReply {
    int status;
    int reqNum;
};

struct navManComplete {
    int status;
    int task;
    float timeCost;
    float areaCovered;
    float energyGen;
};

%#define navManRequestPublicationType "navManRequest"
%#define navManReplyPublicationType "navManReply"
%#define navManCompletePublicationType "navManComplete"
