/* CREATED: 7/1/99
 * AUTHOR: Kim Shillcutt 
 *
 * DESCRIPTION:
 *   These NDDS messages deal with communication between the User Interface 
 *   and the Mission Planner. 
 */

%#include "PlanParams.h"
%#include "sensManMsgs.h"

struct mPlannerRequest {
  int planningMode;    /* 0 = command, 1 = simulate */
  int type;            /* 0 = use sensor, 1 = navigate, 
			  2 = autonomous search */
  PlanParams navReq;
  sensManRequest sensReq;
};

struct mPlannerReply {
  int status;
  int reqNum;
};

struct mPlannerComplete {
  int status;
  int reqNum;
};

struct mPlannerReport {
  int value1;  /* these are still to be determined */
  int value2;
};

%#define mPlannerRequestPublicationType "mPlannerRequest"
%#define mPlannerReplyPublicationType "mPlannerReply"
%#define mPlannerCompletePublicationType "mPlannerComplete"
%#define mPlannerReportPublicationType "mPlannerReport"
