struct MP_POSE {
  float x;
  float y;
  float z;
  float roll;
  float pitch;
  float yaw;
};

struct straightPlan {
  float rowWidth;
  int type;                /* 0=LENGTH_WIDTH or 1=VERTICES */
  float length;
  float width;
  int direction;           /* 1=LEFT or 2=RIGHT */
  int numVert;
  MP_POSE vertices[10];    /* vertices[0] = start */
};

struct spiralPlan {
  float rowWidth;
  float maxRadius;
  int direction;           /* 0=COUNTERCLOCKWISE or 1=CLOCKWISE */
};

struct wayptPlan {
  MP_POSE goal;
  float tolerance;
};

struct manPlan {
  int enact;               /* 0=GENERATE_NEW_PLAN or 1=ENACT_SAVED_PLAN */
  char filename[50];
  int type;                /* 0=SINGLE_POINT or 1=WORKSPACE */
  MP_POSE goal;
  float distanceTol;
  float angularTol;
};

struct PlanParams {
  float minTurningRadius;
  float cameraFOV;
  float speed;
  double startdate;
  MP_POSE start;
  int startNewPlan;        /* 0=RESUME_SAVED_PLAN or 1=NEW_PLAN */
  int useAbsCoord;         /* 0=RELATIVE_TO_ROBOT or 1=ABSOLUTE_DGPS */
  int task;
  straightPlan straightTask;
  spiralPlan spiralTask;
  wayptPlan wayptTask;
  manPlan manplanTask;
  int storage;             /* sets order of enactment, set to 0 when old and to be ignored */
};
