#include <iostream.h>
#include <fstream.h>

#define MAX_LINE_SIZE 1024

int main(int argc, char *argv[]) {
    if(argc < 4) {
	cerr << "[javify] Usage: javify infile.java outfile.java package0 [package1...]" << endl;
	return(-1);
    }
    
    char inBuff[MAX_LINE_SIZE];
    
    fstream infile(argv[1], ios::in);
    fstream outfile(argv[2], ios::out);
    
    if(infile.fail() || outfile.fail()) {
	cerr << "[javify] ERROR: Failed opening files!" << endl;
	return(-1);
    }
    
    int done = 0;
    while((infile >> inBuff) && !done) {
	if(strcmp(inBuff, "package") == 0) {
	    outfile << inBuff;
	    infile.getline(inBuff, MAX_LINE_SIZE);
	    outfile << inBuff << endl;
	    done = 1;
	} 
    }
	
    done = 0;
    while((infile >> inBuff) && !done) {
	if(strcmp(inBuff, "import") == 0) {
	    outfile << inBuff;
	    infile.getline(inBuff, MAX_LINE_SIZE);
	    outfile << inBuff << endl;
	    for(int i=3; i < argc; i++) {
		outfile << "import " << argv[i] << ".*;" << endl;
	    }
	    done = 1;
	} 
    }

    outfile << inBuff;
    while(infile.getline(inBuff, MAX_LINE_SIZE)) {
	if(strcmp(inBuff, "\0") != 0) {
	    outfile << inBuff << endl;
	}
    }
    
    
    infile.close();
    outfile.close();
    
    return(0);
}
