package dbRecord;

#include "dbRecordDef.h"

import distinct.rpc.*;

/**
 * This class was automatically generated by Jrpcgen from the RPC/XDR file "dbRecord.x".<br>
 * dbRecord: was struct
 */

public class dbRecord implements XDRType {
  public int targetID;
  public DGPS DGPS_coord = new DGPS();
  public int timeStamp;
  public float[] probClassMember = new float[NUM_CLASSES];
  public int numSensors;
  public dbSensorData[] sensorData = new dbSensorData[MAX_SENSORS];

/**
 * Default constructor for objects of class dbRecord.
 */

public dbRecord()
{}

/**
 * Creates an object of class dbRecord.
 * @param     arg_targetID The value of the targetID component.
 * @param     arg_DGPS_coord The value of the DGPS_coord component.
 * @param     arg_timeStamp The value of the timeStamp component.
 * @param     arg_probClassMember The value of the probClassMember component.
 * @param     arg_numSensors The value of the numSensors component.
 * @param     arg_sensorData The value of the sensorData component.
 */

public dbRecord(int arg_targetID, DGPS arg_DGPS_coord, int arg_timeStamp, float[] arg_probClassMember, int arg_numSensors, dbSensorData[] arg_sensorData)
{
  targetID = arg_targetID;
  DGPS_coord = arg_DGPS_coord;
  timeStamp = arg_timeStamp;
  probClassMember = arg_probClassMember;
  numSensors = arg_numSensors;
  sensorData = arg_sensorData;
}

/**
 * Encodes an object of class dbRecord in compliance to RFC 1832 (XDR).
 * @param     xdrs The XDR output stream.
 */

public void xdr_encode(XDRStream xdrs)
{
  xdrs.xdr_encode_int(targetID);
  DGPS_coord.xdr_encode(xdrs);
  xdrs.xdr_encode_int(timeStamp);
  for (int i_v = 0; i_v < NUM_CLASSES; i_v++){
    xdrs.xdr_encode_float(probClassMember[i_v]);
  }
  xdrs.xdr_encode_int(numSensors);
  for (int i_v = 0; i_v < MAX_SENSORS; i_v++){
    sensorData[i_v].xdr_encode(xdrs);
  }
}

/**
 * Decodes an object of class dbRecord in compliance to RFC 1832 (XDR).
 * @param     xdrs The XDR input stream.
 * @exception RPCError When the calls fails for any reason.
 */

public void xdr_decode(XDRStream xdrs) throws RPCError
{
  targetID = xdrs.xdr_decode_int();
  DGPS_coord = new DGPS();
  DGPS_coord.xdr_decode(xdrs);
  timeStamp = xdrs.xdr_decode_int();
  probClassMember = new float[NUM_CLASSES];
  for (int i_v = 0; i_v < NUM_CLASSES; i_v++){
    probClassMember[i_v] = xdrs.xdr_decode_float();
  }
  numSensors = xdrs.xdr_decode_int();
  sensorData = new dbSensorData[MAX_SENSORS];
  for (int i_v = 0; i_v < MAX_SENSORS; i_v++){
    sensorData[i_v] = new dbSensorData();
    sensorData[i_v].xdr_decode(xdrs);
  }
}
}
