/* FILE: dbRecord.x
   CREATED: 4/16/99
   AUTHOR: Michael Wagner

   DESCRIPTION: This file defines a record used with the database. Because
     this record is used with NDDS messages, it is created in XDR format.
     Note that this struct will never be used directly as an NDDS message,
     but NDDS XDR methods must be setup by nddsgen for it.

     TBD: Errors and warnings currently appear when making this message. 
     The errors appear because, for no known reason, ^Q's are placed in the
     auto-generated .h files. After fixing these, I tested sample publishers 
     and subscribers of dbRecord, and stuff seems to work ok despite common NDDS
     warnings.
 */

%#include "dbRecordDef.h"

/* x, y, and z should be in meters. */
PublicationType DGPS;
struct DGPS {
  float x;
  float y;
  float z;
};


/* Roll, pitch, and yaw should all be from 0 to 2*PI radians, using the right-hand rule. */
PublicationType pose;
struct pose {
  float roll;   
  float pitch;
  float yaw;
};


PublicationType dbSensorFeatures;
struct dbSensorFeatures {
  float featureVector[MAX_FEATURE_VECTOR_SIZE];
};


PublicationType dbSensorOptionalData;
struct dbSensorOptionalData {
  float optionalData[MAX_OPTIONAL_DATA_SIZE];
};


PublicationType dbSensorReading;
struct dbSensorReading {
  char filename[MAX_DATA_FILENAME_LENGTH];
  long timeStamp;
  DGPS robotPosition;
  pose robotPose;
  dbSensorFeatures features;
  dbSensorOptionalData optionalData;
};


PublicationType dbSensorData;
struct dbSensorData {
  int numReadings;
  float estInfoGain;
  dbSensorReading readings[MAX_SENSOR_READINGS];
};


PublicationType dbRecord;
struct dbRecord {
  int targetID;
  DGPS DGPS_coord;
  long timeStamp;
  float probClassMember[NUM_CLASSES];
  int numSensors;
  dbSensorData sensorData[MAX_SENSORS];
};



PublicationType dbSensorReadingBitMask;
struct dbSensorReadingBitMask {
  char filename;
  char features;
  char optionalData;
};


PublicationType dbSensorDataBitMask;
struct dbSensorDataBitMask {
  char numReadings;
  char estInfoGain;
  dbSensorReadingBitMask readings[MAX_SENSOR_READINGS];
};


/* This bit mask is used to show what fields are to be PUT when an updated
   record is put into the database. Array fields allow the db client to
   specify which sensor's data has been changed. Eventually, this code should
   be auto-generated. See dbDef.h for enums for what these fields can 
   contain. */
PublicationType dbRecordBitMask;
struct dbRecordBitMask {
  char DGPS_coord;
  dbSensorDataBitMask sensorData[MAX_SENSORS];
  char probClassMember;
};
  

