struct DGPS {
  float x;
  float y;
  float z;
};

struct pose {
  float roll;   
  float pitch;
  float yaw;
};

struct dbSensorFeatures {
  float featureVector[40];
};

struct dbSensorOptionalData {
  float optionalData[10];
};

struct dbSensorReading {
  char filename[50];
  long timeStamp;
  DGPS robotPosition;
  pose robotPose;
  dbSensorFeatures features;
  dbSensorOptionalData optionalData;
};

struct dbSensorData {
  int numReadings;
  float estInfoGain;
  dbSensorReading readings[4];
};

struct dbRecord {
  int targetID;
  DGPS DGPS_coord;
  long timeStamp;
  float probClassMember[30];
  int numSensors;
  dbSensorData sensorData[3];
};

struct dbSensorReadingBitMask {
  char filename;
  char features;
  char optionalData;
};

struct dbSensorDataBitMask {
  char numReadings;
  char estInfoGain;
  dbSensorReadingBitMask readings[4];
};

struct dbRecordBitMask {
  char DGPS_coord;
  dbSensorDataBitMask sensorData[3];
  char probClassMember;
};
  

