/*
 * @(#)dbRecord.h    generated by: nddsgen
 *
 * built from:	dbRecord.c
 */

#ifndef dbRecord_h
#define dbRecord_h

#include "ndds/NDDS.h"
#include <rpc/types.h>
#include <rpc/xdr.h>

#ifdef __cplusplus
    extern "C" {
#endif
#include "dbRecordDef.h"


typedef struct DGPS {
    float x;
    float y;
    float z;
} DGPS;


typedef struct pose {
    float roll;
    float pitch;
    float yaw;
} pose;


typedef struct dbSensorFeatures {
    float featureVector[MAX_FEATURE_VECTOR_SIZE];
} dbSensorFeatures;


typedef struct dbSensorOptionalData {
    float optionalData[MAX_OPTIONAL_DATA_SIZE];
} dbSensorOptionalData;


typedef struct dbSensorReading {
    char filename[MAX_DATA_FILENAME_LENGTH];
    long timeStamp;
    DGPS robotPosition;
    pose robotPose;
    dbSensorFeatures features;
    dbSensorOptionalData optionalData;
} dbSensorReading;


typedef struct dbSensorData {
    int numReadings;
    float estInfoGain;
    dbSensorReading readings[MAX_SENSOR_READINGS];
} dbSensorData;


typedef struct dbRecord {
    int targetID;
    DGPS DGPS_coord;
    long timeStamp;
    float probClassMember[NUM_CLASSES];
    int numSensors;
    dbSensorData sensorData[MAX_SENSORS];
} dbRecord;


typedef struct dbSensorReadingBitMask {
    char filename;
    char features;
    char optionalData;
} dbSensorReadingBitMask;


typedef struct dbSensorDataBitMask {
    char numReadings;
    char estInfoGain;
    dbSensorReadingBitMask readings[MAX_SENSOR_READINGS];
} dbSensorDataBitMask;


typedef struct dbRecordBitMask {
    char DGPS_coord;
    dbSensorDataBitMask sensorData[MAX_SENSORS];
    char probClassMember;
} dbRecordBitMask;

#define DGPSPublicationType "DGPS"

#define posePublicationType "pose"

#define dbSensorFeaturesPublicationType "dbSensorFeatures"

#define dbSensorOptionalDataPublicationType "dbSensorOptionalData"

#define dbSensorReadingPublicationType "dbSensorReading"

#define dbSensorDataPublicationType "dbSensorData"

#define dbRecordPublicationType "dbRecord"

#define dbSensorReadingBitMaskPublicationType "dbSensorReadingBitMask"

#define dbSensorDataBitMaskPublicationType "dbSensorDataBitMask"

#define dbRecordBitMaskPublicationType "dbRecordBitMask"

extern RTIBool          DGPSSerialize(NDDSXDRStream nddsds, 
				           DGPS *nddsDGPS, 
                                           int options);
extern DGPS *DGPSDeserialize(DGPS *nddsDGPS,
				             NDDSXDRStream nddsds);
extern DGPS *DGPSPrint(DGPS *nddsDGPS);
extern int           DGPSSerializeSize();
extern void          DGPSNddsRegister();

extern RTIBool          poseSerialize(NDDSXDRStream nddsds, 
				           pose *nddspose, 
                                           int options);
extern pose *poseDeserialize(pose *nddspose,
				             NDDSXDRStream nddsds);
extern pose *posePrint(pose *nddspose);
extern int           poseSerializeSize();
extern void          poseNddsRegister();

extern RTIBool          dbSensorFeaturesSerialize(NDDSXDRStream nddsds, 
				           dbSensorFeatures *nddsdbSensorFeatures, 
                                           int options);
extern dbSensorFeatures *dbSensorFeaturesDeserialize(dbSensorFeatures *nddsdbSensorFeatures,
				             NDDSXDRStream nddsds);
extern dbSensorFeatures *dbSensorFeaturesPrint(dbSensorFeatures *nddsdbSensorFeatures);
extern int           dbSensorFeaturesSerializeSize();
extern void          dbSensorFeaturesNddsRegister();

extern RTIBool          dbSensorOptionalDataSerialize(NDDSXDRStream nddsds, 
				           dbSensorOptionalData *nddsdbSensorOptionalData, 
                                           int options);
extern dbSensorOptionalData *dbSensorOptionalDataDeserialize(dbSensorOptionalData *nddsdbSensorOptionalData,
				             NDDSXDRStream nddsds);
extern dbSensorOptionalData *dbSensorOptionalDataPrint(dbSensorOptionalData *nddsdbSensorOptionalData);
extern int           dbSensorOptionalDataSerializeSize();
extern void          dbSensorOptionalDataNddsRegister();

extern RTIBool          dbSensorReadingSerialize(NDDSXDRStream nddsds, 
				           dbSensorReading *nddsdbSensorReading, 
                                           int options);
extern dbSensorReading *dbSensorReadingDeserialize(dbSensorReading *nddsdbSensorReading,
				             NDDSXDRStream nddsds);
extern dbSensorReading *dbSensorReadingPrint(dbSensorReading *nddsdbSensorReading);
extern int           dbSensorReadingSerializeSize();
extern void          dbSensorReadingNddsRegister();

extern RTIBool          dbSensorDataSerialize(NDDSXDRStream nddsds, 
				           dbSensorData *nddsdbSensorData, 
                                           int options);
extern dbSensorData *dbSensorDataDeserialize(dbSensorData *nddsdbSensorData,
				             NDDSXDRStream nddsds);
extern dbSensorData *dbSensorDataPrint(dbSensorData *nddsdbSensorData);
extern int           dbSensorDataSerializeSize();
extern void          dbSensorDataNddsRegister();

extern RTIBool          dbRecordSerialize(NDDSXDRStream nddsds, 
				           dbRecord *nddsdbRecord, 
                                           int options);
extern dbRecord *dbRecordDeserialize(dbRecord *nddsdbRecord,
				             NDDSXDRStream nddsds);
extern dbRecord *dbRecordPrint(dbRecord *nddsdbRecord);
extern int           dbRecordSerializeSize();
extern void          dbRecordNddsRegister();

extern RTIBool          dbSensorReadingBitMaskSerialize(NDDSXDRStream nddsds, 
				           dbSensorReadingBitMask *nddsdbSensorReadingBitMask, 
                                           int options);
extern dbSensorReadingBitMask *dbSensorReadingBitMaskDeserialize(dbSensorReadingBitMask *nddsdbSensorReadingBitMask,
				             NDDSXDRStream nddsds);
extern dbSensorReadingBitMask *dbSensorReadingBitMaskPrint(dbSensorReadingBitMask *nddsdbSensorReadingBitMask);
extern int           dbSensorReadingBitMaskSerializeSize();
extern void          dbSensorReadingBitMaskNddsRegister();

extern RTIBool          dbSensorDataBitMaskSerialize(NDDSXDRStream nddsds, 
				           dbSensorDataBitMask *nddsdbSensorDataBitMask, 
                                           int options);
extern dbSensorDataBitMask *dbSensorDataBitMaskDeserialize(dbSensorDataBitMask *nddsdbSensorDataBitMask,
				             NDDSXDRStream nddsds);
extern dbSensorDataBitMask *dbSensorDataBitMaskPrint(dbSensorDataBitMask *nddsdbSensorDataBitMask);
extern int           dbSensorDataBitMaskSerializeSize();
extern void          dbSensorDataBitMaskNddsRegister();

extern RTIBool          dbRecordBitMaskSerialize(NDDSXDRStream nddsds, 
				           dbRecordBitMask *nddsdbRecordBitMask, 
                                           int options);
extern dbRecordBitMask *dbRecordBitMaskDeserialize(dbRecordBitMask *nddsdbRecordBitMask,
				             NDDSXDRStream nddsds);
extern dbRecordBitMask *dbRecordBitMaskPrint(dbRecordBitMask *nddsdbRecordBitMask);
extern int           dbRecordBitMaskSerializeSize();
extern void          dbRecordBitMaskNddsRegister();

#ifdef __cplusplus
    }   /* extern "C" */
#endif

#endif /* dbRecord_h*/
