/* mangen dbRecord \- NDDS methods for dbRecord type.
   banner = ==========
  
   This file is derived from code automatically generated by nddsgen.
 */

static char copyright_rti[] = 
"(c) Copyright, Real-Time Innovations, Inc., 1994.  All rights reserved.";

/*
DESCRIPTION:
  This file was automatically generated by the 'nddsgen' code generator from the
  XDR file dbRecord.x.  See the man pages on 'nddsgen' and 'NddsXDR'.

  This file was generated with the following steps:

(1) One or more XDR descriptions where written into a file named 
    dbRecord.x (NOTE: the .x termination which is standard for this 
    files is required.). This description uses the XDR language,
    which resembles "C"-like structure-type declarations. More information 
    and examples on how to write these ".x" files can be found in the 
    on-line html page for 'nddsgen'.

(2) 'nddsgen' was run on the dbRecord.x file. The command was:
    /usr/mwagner/nomad/src/SAS/messages/database/nddsgen dbRecord.x -replace

    This created the dbRecord.c, and dbRecord.h.

(3) The dbRecord_stub.c is copied into dbRecord.c;
    if you pass "-replace" during nddsgen. This file contains the functions, 
    NddsTypeNameSeralize(), NddsTypeNameDeserialize(), and NddsTypeNamePrint() 
    for each NDDS type.

(4) The user may want to fill in the code for the NddsTypeNamePrint()
    function if they want NDDS to print the NddsTypeName automatically
    in certain situations. This isn't required.

(5) The file dbRecord.c also contains functions to register, and 
    test NDDS types.

SEE ALSO:
  nddsgen(1), NddsXDR(2), Ndds(2)
--------------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <rpc/types.h>
#include <rpc/xdr.h>

#include "dbRecord.h"
#include "dbRecordDef.h"


int NddsXDRSerializeSize_DGPS()
{
    int size = 0;
    size += NddsXDRSerializeSize_float(); /* x */
    size += NddsXDRSerializeSize_float(); /* y */
    size += NddsXDRSerializeSize_float(); /* z */
    return size;
}




bool_t
NddsXDRPrint_DGPS(DGPS *objp, char *desc, int indent)
{
    int i;
    for (i=0; i<indent; i++) { printf("  "); }
    printf("%s:\n", desc);

    if (!NddsXDRPrint_float(&objp->x, "x", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_float(&objp->y, "y", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_float(&objp->z, "z", indent+1)) {
        return (FALSE);
    }
    return (TRUE);
}




bool_t
xdr_DGPS(XDR *xdrs, DGPS *objp)
{
    if (!xdr_float(xdrs, &objp->x)) {
    	return (FALSE);
    }
    if (!xdr_float(xdrs, &objp->y)) {
    	return (FALSE);
    }
    if (!xdr_float(xdrs, &objp->z)) {
    	return (FALSE);
    }
    return (TRUE);
}




int NddsXDRSerializeSize_pose()
{
    int size = 0;
    size += NddsXDRSerializeSize_float(); /* roll */
    size += NddsXDRSerializeSize_float(); /* pitch */
    size += NddsXDRSerializeSize_float(); /* yaw */
    return size;
}




bool_t
NddsXDRPrint_pose(pose *objp, char *desc, int indent)
{
    int i;
    for (i=0; i<indent; i++) { printf("  "); }
    printf("%s:\n", desc);

    if (!NddsXDRPrint_float(&objp->roll, "roll", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_float(&objp->pitch, "pitch", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_float(&objp->yaw, "yaw", indent+1)) {
        return (FALSE);
    }
    return (TRUE);
}




bool_t
xdr_pose(XDR *xdrs, pose *objp)
{
    if (!xdr_float(xdrs, &objp->roll)) {
    	return (FALSE);
    }
    if (!xdr_float(xdrs, &objp->pitch)) {
    	return (FALSE);
    }
    if (!xdr_float(xdrs, &objp->yaw)) {
    	return (FALSE);
    }
    return (TRUE);
}




int NddsXDRSerializeSize_dbSensorFeatures()
{
    int size = 0;
    size += NddsXDRSerializeSize_array(MAX_FEATURE_VECTOR_SIZE, NddsXDRSerializeSize_float()); /* featureVector */
    return size;
}




bool_t
NddsXDRPrint_dbSensorFeatures(dbSensorFeatures *objp, char *desc, int indent)
{
    int i;
    for (i=0; i<indent; i++) { printf("  "); }
    printf("%s:\n", desc);

    if (!NddsXDRPrint_array(objp->featureVector, MAX_FEATURE_VECTOR_SIZE, sizeof(float), (NddsXDRPrintFncType)NddsXDRPrint_float, "featureVector", indent+1)) {
        return (FALSE);
    }
    return (TRUE);
}




bool_t
xdr_dbSensorFeatures(XDR *xdrs, dbSensorFeatures *objp)
{
    if (!xdr_vector(xdrs, (char *)objp->featureVector, MAX_FEATURE_VECTOR_SIZE, sizeof(float), xdr_float)) {
    	return (FALSE);
    }
    return (TRUE);
}




int NddsXDRSerializeSize_dbSensorOptionalData()
{
    int size = 0;
    size += NddsXDRSerializeSize_array(MAX_OPTIONAL_DATA_SIZE, NddsXDRSerializeSize_float()); /* optionalData */
    return size;
}




bool_t
NddsXDRPrint_dbSensorOptionalData(dbSensorOptionalData *objp, char *desc, int indent)
{
    int i;
    for (i=0; i<indent; i++) { printf("  "); }
    printf("%s:\n", desc);

    if (!NddsXDRPrint_array(objp->optionalData, MAX_OPTIONAL_DATA_SIZE, sizeof(float), (NddsXDRPrintFncType)NddsXDRPrint_float, "optionalData", indent+1)) {
        return (FALSE);
    }
    return (TRUE);
}




bool_t
xdr_dbSensorOptionalData(XDR *xdrs, dbSensorOptionalData *objp)
{
    if (!xdr_vector(xdrs, (char *)objp->optionalData, MAX_OPTIONAL_DATA_SIZE, sizeof(float), xdr_float)) {
    	return (FALSE);
    }
    return (TRUE);
}




int NddsXDRSerializeSize_dbSensorReading()
{
    int size = 0;
    size += NddsXDRSerializeSize_array(MAX_DATA_FILENAME_LENGTH, NddsXDRSerializeSize_char()); /* filename */
    size += NddsXDRSerializeSize_long(); /* timeStamp */
    size += NddsXDRSerializeSize_DGPS(); /* robotPosition */
    size += NddsXDRSerializeSize_pose(); /* robotPose */
    size += NddsXDRSerializeSize_dbSensorFeatures(); /* features */
    size += NddsXDRSerializeSize_dbSensorOptionalData(); /* optionalData */
    return size;
}




bool_t
NddsXDRPrint_dbSensorReading(dbSensorReading *objp, char *desc, int indent)
{
    int i;
    for (i=0; i<indent; i++) { printf("  "); }
    printf("%s:\n", desc);

    if (!NddsXDRPrint_array(objp->filename, MAX_DATA_FILENAME_LENGTH, sizeof(char), (NddsXDRPrintFncType)NddsXDRPrint_char, "filename", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_long(&objp->timeStamp, "timeStamp", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_DGPS(&objp->robotPosition, "robotPosition", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_pose(&objp->robotPose, "robotPose", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_dbSensorFeatures(&objp->features, "features", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_dbSensorOptionalData(&objp->optionalData, "optionalData", indent+1)) {
        return (FALSE);
    }
    return (TRUE);
}




bool_t
xdr_dbSensorReading(XDR *xdrs, dbSensorReading *objp)
{
    if (!xdr_vector(xdrs, (char *)objp->filename, MAX_DATA_FILENAME_LENGTH, sizeof(char), xdr_char)) {
    	return (FALSE);
    }
    if (!xdr_long(xdrs, &objp->timeStamp)) {
    	return (FALSE);
    }
    if (!xdr_DGPS(xdrs, &objp->robotPosition)) {
    	return (FALSE);
    }
    if (!xdr_pose(xdrs, &objp->robotPose)) {
    	return (FALSE);
    }
    if (!xdr_dbSensorFeatures(xdrs, &objp->features)) {
    	return (FALSE);
    }
    if (!xdr_dbSensorOptionalData(xdrs, &objp->optionalData)) {
    	return (FALSE);
    }
    return (TRUE);
}




int NddsXDRSerializeSize_dbSensorData()
{
    int size = 0;
    size += NddsXDRSerializeSize_int(); /* numReadings */
    size += NddsXDRSerializeSize_float(); /* estInfoGain */
    size += NddsXDRSerializeSize_array(MAX_SENSOR_READINGS, NddsXDRSerializeSize_dbSensorReading()); /* readings */
    return size;
}




bool_t
NddsXDRPrint_dbSensorData(dbSensorData *objp, char *desc, int indent)
{
    int i;
    for (i=0; i<indent; i++) { printf("  "); }
    printf("%s:\n", desc);

    if (!NddsXDRPrint_int(&objp->numReadings, "numReadings", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_float(&objp->estInfoGain, "estInfoGain", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_array(objp->readings, MAX_SENSOR_READINGS, sizeof(dbSensorReading), (NddsXDRPrintFncType)NddsXDRPrint_dbSensorReading, "readings", indent+1)) {
        return (FALSE);
    }
    return (TRUE);
}




bool_t
xdr_dbSensorData(XDR *xdrs, dbSensorData *objp)
{
    if (!xdr_int(xdrs, &objp->numReadings)) {
    	return (FALSE);
    }
    if (!xdr_float(xdrs, &objp->estInfoGain)) {
    	return (FALSE);
    }
    if (!xdr_vector(xdrs, (char *)objp->readings, MAX_SENSOR_READINGS, sizeof(dbSensorReading), xdr_dbSensorReading)) {
    	return (FALSE);
    }
    return (TRUE);
}




int NddsXDRSerializeSize_dbRecord()
{
    int size = 0;
    size += NddsXDRSerializeSize_int(); /* targetID */
    size += NddsXDRSerializeSize_DGPS(); /* DGPS_coord */
    size += NddsXDRSerializeSize_long(); /* timeStamp */
    size += NddsXDRSerializeSize_array(NUM_CLASSES, NddsXDRSerializeSize_float()); /* probClassMember */
    size += NddsXDRSerializeSize_int(); /* numSensors */
    size += NddsXDRSerializeSize_array(MAX_SENSORS, NddsXDRSerializeSize_dbSensorData()); /* sensorData */
    return size;
}




bool_t
NddsXDRPrint_dbRecord(dbRecord *objp, char *desc, int indent)
{
    int i;
    for (i=0; i<indent; i++) { printf("  "); }
    printf("%s:\n", desc);

    if (!NddsXDRPrint_int(&objp->targetID, "targetID", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_DGPS(&objp->DGPS_coord, "DGPS_coord", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_long(&objp->timeStamp, "timeStamp", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_array(objp->probClassMember, NUM_CLASSES, sizeof(float), (NddsXDRPrintFncType)NddsXDRPrint_float, "probClassMember", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_int(&objp->numSensors, "numSensors", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_array(objp->sensorData, MAX_SENSORS, sizeof(dbSensorData), (NddsXDRPrintFncType)NddsXDRPrint_dbSensorData, "sensorData", indent+1)) {
        return (FALSE);
    }
    return (TRUE);
}




bool_t
xdr_dbRecord(XDR *xdrs, dbRecord *objp)
{
    if (!xdr_int(xdrs, &objp->targetID)) {
    	return (FALSE);
    }
    if (!xdr_DGPS(xdrs, &objp->DGPS_coord)) {
    	return (FALSE);
    }
    if (!xdr_long(xdrs, &objp->timeStamp)) {
    	return (FALSE);
    }
    if (!xdr_vector(xdrs, (char *)objp->probClassMember, NUM_CLASSES, sizeof(float), xdr_float)) {
    	return (FALSE);
    }
    if (!xdr_int(xdrs, &objp->numSensors)) {
    	return (FALSE);
    }
    if (!xdr_vector(xdrs, (char *)objp->sensorData, MAX_SENSORS, sizeof(dbSensorData), xdr_dbSensorData)) {
    	return (FALSE);
    }
    return (TRUE);
}




int NddsXDRSerializeSize_dbSensorReadingBitMask()
{
    int size = 0;
    size += NddsXDRSerializeSize_char(); /* filename */
    size += NddsXDRSerializeSize_char(); /* features */
    size += NddsXDRSerializeSize_char(); /* optionalData */
    return size;
}




bool_t
NddsXDRPrint_dbSensorReadingBitMask(dbSensorReadingBitMask *objp, char *desc, int indent)
{
    int i;
    for (i=0; i<indent; i++) { printf("  "); }
    printf("%s:\n", desc);

    if (!NddsXDRPrint_char(&objp->filename, "filename", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_char(&objp->features, "features", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_char(&objp->optionalData, "optionalData", indent+1)) {
        return (FALSE);
    }
    return (TRUE);
}




bool_t
xdr_dbSensorReadingBitMask(XDR *xdrs, dbSensorReadingBitMask *objp)
{
    if (!xdr_char(xdrs, &objp->filename)) {
    	return (FALSE);
    }
    if (!xdr_char(xdrs, &objp->features)) {
    	return (FALSE);
    }
    if (!xdr_char(xdrs, &objp->optionalData)) {
    	return (FALSE);
    }
    return (TRUE);
}




int NddsXDRSerializeSize_dbSensorDataBitMask()
{
    int size = 0;
    size += NddsXDRSerializeSize_char(); /* numReadings */
    size += NddsXDRSerializeSize_char(); /* estInfoGain */
    size += NddsXDRSerializeSize_array(MAX_SENSOR_READINGS, NddsXDRSerializeSize_dbSensorReadingBitMask()); /* readings */
    return size;
}




bool_t
NddsXDRPrint_dbSensorDataBitMask(dbSensorDataBitMask *objp, char *desc, int indent)
{
    int i;
    for (i=0; i<indent; i++) { printf("  "); }
    printf("%s:\n", desc);

    if (!NddsXDRPrint_char(&objp->numReadings, "numReadings", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_char(&objp->estInfoGain, "estInfoGain", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_array(objp->readings, MAX_SENSOR_READINGS, sizeof(dbSensorReadingBitMask), (NddsXDRPrintFncType)NddsXDRPrint_dbSensorReadingBitMask, "readings", indent+1)) {
        return (FALSE);
    }
    return (TRUE);
}




bool_t
xdr_dbSensorDataBitMask(XDR *xdrs, dbSensorDataBitMask *objp)
{
    if (!xdr_char(xdrs, &objp->numReadings)) {
    	return (FALSE);
    }
    if (!xdr_char(xdrs, &objp->estInfoGain)) {
    	return (FALSE);
    }
    if (!xdr_vector(xdrs, (char *)objp->readings, MAX_SENSOR_READINGS, sizeof(dbSensorReadingBitMask), xdr_dbSensorReadingBitMask)) {
    	return (FALSE);
    }
    return (TRUE);
}




int NddsXDRSerializeSize_dbRecordBitMask()
{
    int size = 0;
    size += NddsXDRSerializeSize_char(); /* DGPS_coord */
    size += NddsXDRSerializeSize_array(MAX_SENSORS, NddsXDRSerializeSize_dbSensorDataBitMask()); /* sensorData */
    size += NddsXDRSerializeSize_char(); /* probClassMember */
    return size;
}




bool_t
NddsXDRPrint_dbRecordBitMask(dbRecordBitMask *objp, char *desc, int indent)
{
    int i;
    for (i=0; i<indent; i++) { printf("  "); }
    printf("%s:\n", desc);

    if (!NddsXDRPrint_char(&objp->DGPS_coord, "DGPS_coord", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_array(objp->sensorData, MAX_SENSORS, sizeof(dbSensorDataBitMask), (NddsXDRPrintFncType)NddsXDRPrint_dbSensorDataBitMask, "sensorData", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_char(&objp->probClassMember, "probClassMember", indent+1)) {
        return (FALSE);
    }
    return (TRUE);
}




bool_t
xdr_dbRecordBitMask(XDR *xdrs, dbRecordBitMask *objp)
{
    if (!xdr_char(xdrs, &objp->DGPS_coord)) {
    	return (FALSE);
    }
    if (!xdr_vector(xdrs, (char *)objp->sensorData, MAX_SENSORS, sizeof(dbSensorDataBitMask), xdr_dbSensorDataBitMask)) {
    	return (FALSE);
    }
    if (!xdr_char(xdrs, &objp->probClassMember)) {
    	return (FALSE);
    }
    return (TRUE);
}


/* ========================================================================
   DGPSSerialize \- NDDS serialization method for DGPS

   Required NDDS method to serialize an DGPS into NDDSXDRStream 
   buffer.
   The data will be deserialized by the DGPSDeserialize() function.

   The 'options' may be defined and used for customizing serialization
   for different situations. Often (as in this case) they are simply 
   ignored.
 */
RTIBool DGPSSerialize(NDDSXDRStream nddsds, 
			   DGPS *nddsDGPS,
			   int options)
{
    return xdr_DGPS(NddsXDRGetSerializingStream(nddsds),
			       nddsDGPS);
}

/* ========================================================================
   DGPSDeserialize \- NDDS deserialization method for DGPS 
   
   Required NDDS method to deserialize the data from an NDDSXDRStream buffer.
   The data was serialized by the DGPSSerialize() function.

   If outArray==NULL (null pointer), this function will create a
   DGPS of the appropriate size to hold the data 
   (as required by NDDS).

   Returns the output array or NULL if an error occurred
 */
DGPS *DGPSDeserialize(DGPS *nddsDGPS,
				      NDDSXDRStream nddsds)
{
    int allocated = RTI_FALSE;

    if (nddsDGPS == NULL) {
	allocated = RTI_TRUE;
	nddsDGPS =(DGPS *)calloc(1, sizeof(DGPS));
    }

    if (!xdr_DGPS(NddsXDRGetDeserializingStream(nddsds),
			     nddsDGPS))  {
	if (allocated) {
	    free(nddsDGPS);
	}
	return NULL;
    }
    
    return nddsDGPS;
}

/* ========================================================================
   DGPSPrint \- NDDS Print method for DGPS objects

   Optional NDDS method to print the contents of an DGPS.

   Note that if this method *must* handle the case where the object
   is NULL.
 */
DGPS *DGPSPrint(DGPS *nddsDGPS)
{
    /* Do not remove. DGPSPrint must handle a NULL 
       DGPS 
       */
    if (nddsDGPS==NULL) {
	printf("DGPS: (null)\n");
	return NULL;
    }

    /* Replace by custom code if desired */
    if (!NddsXDRPrint_DGPS(nddsDGPS, "DGPS", 0)) {
	printf("NddsXDRPrintDGPS() failed on %p\n", 
	       nddsDGPS);
	return NULL;
    }

    /* Do not remove the return value */
    return nddsDGPS;
}

/* ========================================================================
   DGPSSerializeSize \- NDDS size method for DGPS objects
 
   This optional NDDS method returns the maximum size of a DGPS object.
   The purpose of this method is to allow NDDS to optimize its memory usage.
 
   Users must be very careful and return a size that is equal-to or larger 
   than the maximum DGPS serialized. Please refer to NddsXdr(2) for
   functions to help determin the serialized size of basic types.

   If a -1 is returned then NDDS will default to a safe size, but will not
   be optimal.
 */
int DGPSSerializeSize()
{
    return NddsXDRSerializeSize_DGPS();
}


/* ========================================================================
   DGPSAllocate \- NDDS Allocate method for DGPS objects

   Optional NDDS method to allocate an NDDS object of type DGPS.

   If registered within DGPSNddsRegister(), this method will be 
   invoked as a result of pattern subscriptions. When the NDDS agent 
   subscribes to a publication that matches the requested pattern, it
   needs to create a new object of the corresponding type to hold the 
   updates when they come. 
   It is for this purpose that DGPSAllocate() is used.

   This method is not always required because DGPSDeserialize()
   is usually able to allocate the object itself. There are however
   some cases (notably strings) for which the allocation provided
   by DGPSDeserialize() isn't sufficient. Registration
   of DGPSAllocate() allows to override the default allocation
   provided by DGPSDeserialize().

   If this method is to be used, it must passed to NddsTypeRegister()
   (in function DGPSNddsRegister()) instead of the default
   NULL method.

   This routine gets passed the type and name of the object instance and
   the parameter provided by the user passed in the 
   NddsSubscriptionGroupSubscriptionAdd(3) call.
 */
DGPS *DGPSAllocate(const char *type, const char *name,
				   void *userParam)
{
    DGPS *nddsDGPS = NULL;

    nddsDGPS = (DGPS *)calloc(1, sizeof(*nddsDGPS));
    {
	/* Add the custom allocation of entries in the structure here */
    }

    return nddsDGPS;
}

/* ========================================================================
   DGPSFree \- NDDS Free method for DGPS objects

   Optional NDDS method to Free an NDDS object of type DGPS.

   This method is not used in the current version of NDDS.
 */
RTIBool DGPSFree(DGPS *inst, const char *type, const char *name,
		      void *userParam)
{
    return RTI_TRUE;
}

/* ========================================================================
   DGPSNddsRegister \- Install DGPS type to NDDS
   
   This function will register an DGPS type with NDDS.   
   Registration must happen before any reference to the DGPS 
   type is given to NDDS.

   A description of the type DGPS was written in a file
   named DGPS.x (NOTE: the .x termination which is standard
   for this files is required.). This description uses the XDR language,
   which resembles "C"-like structure-type declarations. More information
   and examples on how to write these ".x" files can be found in the
   man page for 'nddsgen'.
 
   nddsgen was run on the dbRecord.x file. See the man pages
   on nddsgen and dbRecord for details.
 */
void DGPSNddsRegister(void)
{
   NddsTypeRegister(DGPSPublicationType,
	/*A #define in dbRecord.h*/
		    (SerializeMethodType)DGPSSerialize,
		    (DeserializeMethodType)DGPSDeserialize,
		    (PrintMethodType)DGPSPrint,
		    (AllocateMethodType)NULL,
		    (FreeMethodType)NULL,
		    (SerializeSizeMethodType)DGPSSerializeSize);
}
/* ========================================================================
   poseSerialize \- NDDS serialization method for pose

   Required NDDS method to serialize an pose into NDDSXDRStream 
   buffer.
   The data will be deserialized by the poseDeserialize() function.

   The 'options' may be defined and used for customizing serialization
   for different situations. Often (as in this case) they are simply 
   ignored.
 */
RTIBool poseSerialize(NDDSXDRStream nddsds, 
			   pose *nddspose,
			   int options)
{
    return xdr_pose(NddsXDRGetSerializingStream(nddsds),
			       nddspose);
}

/* ========================================================================
   poseDeserialize \- NDDS deserialization method for pose 
   
   Required NDDS method to deserialize the data from an NDDSXDRStream buffer.
   The data was serialized by the poseSerialize() function.

   If outArray==NULL (null pointer), this function will create a
   pose of the appropriate size to hold the data 
   (as required by NDDS).

   Returns the output array or NULL if an error occurred
 */
pose *poseDeserialize(pose *nddspose,
				      NDDSXDRStream nddsds)
{
    int allocated = RTI_FALSE;

    if (nddspose == NULL) {
	allocated = RTI_TRUE;
	nddspose =(pose *)calloc(1, sizeof(pose));
    }

    if (!xdr_pose(NddsXDRGetDeserializingStream(nddsds),
			     nddspose))  {
	if (allocated) {
	    free(nddspose);
	}
	return NULL;
    }
    
    return nddspose;
}

/* ========================================================================
   posePrint \- NDDS Print method for pose objects

   Optional NDDS method to print the contents of an pose.

   Note that if this method *must* handle the case where the object
   is NULL.
 */
pose *posePrint(pose *nddspose)
{
    /* Do not remove. posePrint must handle a NULL 
       pose 
       */
    if (nddspose==NULL) {
	printf("pose: (null)\n");
	return NULL;
    }

    /* Replace by custom code if desired */
    if (!NddsXDRPrint_pose(nddspose, "pose", 0)) {
	printf("NddsXDRPrintpose() failed on %p\n", 
	       nddspose);
	return NULL;
    }

    /* Do not remove the return value */
    return nddspose;
}

/* ========================================================================
   poseSerializeSize \- NDDS size method for pose objects
 
   This optional NDDS method returns the maximum size of a pose object.
   The purpose of this method is to allow NDDS to optimize its memory usage.
 
   Users must be very careful and return a size that is equal-to or larger 
   than the maximum pose serialized. Please refer to NddsXdr(2) for
   functions to help determin the serialized size of basic types.

   If a -1 is returned then NDDS will default to a safe size, but will not
   be optimal.
 */
int poseSerializeSize()
{
    return NddsXDRSerializeSize_pose();
}


/* ========================================================================
   poseAllocate \- NDDS Allocate method for pose objects

   Optional NDDS method to allocate an NDDS object of type pose.

   If registered within poseNddsRegister(), this method will be 
   invoked as a result of pattern subscriptions. When the NDDS agent 
   subscribes to a publication that matches the requested pattern, it
   needs to create a new object of the corresponding type to hold the 
   updates when they come. 
   It is for this purpose that poseAllocate() is used.

   This method is not always required because poseDeserialize()
   is usually able to allocate the object itself. There are however
   some cases (notably strings) for which the allocation provided
   by poseDeserialize() isn't sufficient. Registration
   of poseAllocate() allows to override the default allocation
   provided by poseDeserialize().

   If this method is to be used, it must passed to NddsTypeRegister()
   (in function poseNddsRegister()) instead of the default
   NULL method.

   This routine gets passed the type and name of the object instance and
   the parameter provided by the user passed in the 
   NddsSubscriptionGroupSubscriptionAdd(3) call.
 */
pose *poseAllocate(const char *type, const char *name,
				   void *userParam)
{
    pose *nddspose = NULL;

    nddspose = (pose *)calloc(1, sizeof(*nddspose));
    {
	/* Add the custom allocation of entries in the structure here */
    }

    return nddspose;
}

/* ========================================================================
   poseFree \- NDDS Free method for pose objects

   Optional NDDS method to Free an NDDS object of type pose.

   This method is not used in the current version of NDDS.
 */
RTIBool poseFree(pose *inst, const char *type, const char *name,
		      void *userParam)
{
    return RTI_TRUE;
}

/* ========================================================================
   poseNddsRegister \- Install pose type to NDDS
   
   This function will register an pose type with NDDS.   
   Registration must happen before any reference to the pose 
   type is given to NDDS.

   A description of the type pose was written in a file
   named pose.x (NOTE: the .x termination which is standard
   for this files is required.). This description uses the XDR language,
   which resembles "C"-like structure-type declarations. More information
   and examples on how to write these ".x" files can be found in the
   man page for 'nddsgen'.
 
   nddsgen was run on the dbRecord.x file. See the man pages
   on nddsgen and dbRecord for details.
 */
void poseNddsRegister(void)
{
   NddsTypeRegister(posePublicationType,
	/*A #define in dbRecord.h*/
		    (SerializeMethodType)poseSerialize,
		    (DeserializeMethodType)poseDeserialize,
		    (PrintMethodType)posePrint,
		    (AllocateMethodType)NULL,
		    (FreeMethodType)NULL,
		    (SerializeSizeMethodType)poseSerializeSize);
}
/* ========================================================================
   dbSensorFeaturesSerialize \- NDDS serialization method for dbSensorFeatures

   Required NDDS method to serialize an dbSensorFeatures into NDDSXDRStream 
   buffer.
   The data will be deserialized by the dbSensorFeaturesDeserialize() function.

   The 'options' may be defined and used for customizing serialization
   for different situations. Often (as in this case) they are simply 
   ignored.
 */
RTIBool dbSensorFeaturesSerialize(NDDSXDRStream nddsds, 
			   dbSensorFeatures *nddsdbSensorFeatures,
			   int options)
{
    return xdr_dbSensorFeatures(NddsXDRGetSerializingStream(nddsds),
			       nddsdbSensorFeatures);
}

/* ========================================================================
   dbSensorFeaturesDeserialize \- NDDS deserialization method for dbSensorFeatures 
   
   Required NDDS method to deserialize the data from an NDDSXDRStream buffer.
   The data was serialized by the dbSensorFeaturesSerialize() function.

   If outArray==NULL (null pointer), this function will create a
   dbSensorFeatures of the appropriate size to hold the data 
   (as required by NDDS).

   Returns the output array or NULL if an error occurred
 */
dbSensorFeatures *dbSensorFeaturesDeserialize(dbSensorFeatures *nddsdbSensorFeatures,
				      NDDSXDRStream nddsds)
{
    int allocated = RTI_FALSE;

    if (nddsdbSensorFeatures == NULL) {
	allocated = RTI_TRUE;
	nddsdbSensorFeatures =(dbSensorFeatures *)calloc(1, sizeof(dbSensorFeatures));
    }

    if (!xdr_dbSensorFeatures(NddsXDRGetDeserializingStream(nddsds),
			     nddsdbSensorFeatures))  {
	if (allocated) {
	    free(nddsdbSensorFeatures);
	}
	return NULL;
    }
    
    return nddsdbSensorFeatures;
}

/* ========================================================================
   dbSensorFeaturesPrint \- NDDS Print method for dbSensorFeatures objects

   Optional NDDS method to print the contents of an dbSensorFeatures.

   Note that if this method *must* handle the case where the object
   is NULL.
 */
dbSensorFeatures *dbSensorFeaturesPrint(dbSensorFeatures *nddsdbSensorFeatures)
{
    /* Do not remove. dbSensorFeaturesPrint must handle a NULL 
       dbSensorFeatures 
       */
    if (nddsdbSensorFeatures==NULL) {
	printf("dbSensorFeatures: (null)\n");
	return NULL;
    }

    /* Replace by custom code if desired */
    if (!NddsXDRPrint_dbSensorFeatures(nddsdbSensorFeatures, "dbSensorFeatures", 0)) {
	printf("NddsXDRPrintdbSensorFeatures() failed on %p\n", 
	       nddsdbSensorFeatures);
	return NULL;
    }

    /* Do not remove the return value */
    return nddsdbSensorFeatures;
}

/* ========================================================================
   dbSensorFeaturesSerializeSize \- NDDS size method for dbSensorFeatures objects
 
   This optional NDDS method returns the maximum size of a dbSensorFeatures object.
   The purpose of this method is to allow NDDS to optimize its memory usage.
 
   Users must be very careful and return a size that is equal-to or larger 
   than the maximum dbSensorFeatures serialized. Please refer to NddsXdr(2) for
   functions to help determin the serialized size of basic types.

   If a -1 is returned then NDDS will default to a safe size, but will not
   be optimal.
 */
int dbSensorFeaturesSerializeSize()
{
    return NddsXDRSerializeSize_dbSensorFeatures();
}


/* ========================================================================
   dbSensorFeaturesAllocate \- NDDS Allocate method for dbSensorFeatures objects

   Optional NDDS method to allocate an NDDS object of type dbSensorFeatures.

   If registered within dbSensorFeaturesNddsRegister(), this method will be 
   invoked as a result of pattern subscriptions. When the NDDS agent 
   subscribes to a publication that matches the requested pattern, it
   needs to create a new object of the corresponding type to hold the 
   updates when they come. 
   It is for this purpose that dbSensorFeaturesAllocate() is used.

   This method is not always required because dbSensorFeaturesDeserialize()
   is usually able to allocate the object itself. There are however
   some cases (notably strings) for which the allocation provided
   by dbSensorFeaturesDeserialize() isn't sufficient. Registration
   of dbSensorFeaturesAllocate() allows to override the default allocation
   provided by dbSensorFeaturesDeserialize().

   If this method is to be used, it must passed to NddsTypeRegister()
   (in function dbSensorFeaturesNddsRegister()) instead of the default
   NULL method.

   This routine gets passed the type and name of the object instance and
   the parameter provided by the user passed in the 
   NddsSubscriptionGroupSubscriptionAdd(3) call.
 */
dbSensorFeatures *dbSensorFeaturesAllocate(const char *type, const char *name,
				   void *userParam)
{
    dbSensorFeatures *nddsdbSensorFeatures = NULL;

    nddsdbSensorFeatures = (dbSensorFeatures *)calloc(1, sizeof(*nddsdbSensorFeatures));
    {
	/* Add the custom allocation of entries in the structure here */
    }

    return nddsdbSensorFeatures;
}

/* ========================================================================
   dbSensorFeaturesFree \- NDDS Free method for dbSensorFeatures objects

   Optional NDDS method to Free an NDDS object of type dbSensorFeatures.

   This method is not used in the current version of NDDS.
 */
RTIBool dbSensorFeaturesFree(dbSensorFeatures *inst, const char *type, const char *name,
		      void *userParam)
{
    return RTI_TRUE;
}

/* ========================================================================
   dbSensorFeaturesNddsRegister \- Install dbSensorFeatures type to NDDS
   
   This function will register an dbSensorFeatures type with NDDS.   
   Registration must happen before any reference to the dbSensorFeatures 
   type is given to NDDS.

   A description of the type dbSensorFeatures was written in a file
   named dbSensorFeatures.x (NOTE: the .x termination which is standard
   for this files is required.). This description uses the XDR language,
   which resembles "C"-like structure-type declarations. More information
   and examples on how to write these ".x" files can be found in the
   man page for 'nddsgen'.
 
   nddsgen was run on the dbRecord.x file. See the man pages
   on nddsgen and dbRecord for details.
 */
void dbSensorFeaturesNddsRegister(void)
{
   NddsTypeRegister(dbSensorFeaturesPublicationType,
	/*A #define in dbRecord.h*/
		    (SerializeMethodType)dbSensorFeaturesSerialize,
		    (DeserializeMethodType)dbSensorFeaturesDeserialize,
		    (PrintMethodType)dbSensorFeaturesPrint,
		    (AllocateMethodType)NULL,
		    (FreeMethodType)NULL,
		    (SerializeSizeMethodType)dbSensorFeaturesSerializeSize);
}
/* ========================================================================
   dbSensorOptionalDataSerialize \- NDDS serialization method for dbSensorOptionalData

   Required NDDS method to serialize an dbSensorOptionalData into NDDSXDRStream 
   buffer.
   The data will be deserialized by the dbSensorOptionalDataDeserialize() function.

   The 'options' may be defined and used for customizing serialization
   for different situations. Often (as in this case) they are simply 
   ignored.
 */
RTIBool dbSensorOptionalDataSerialize(NDDSXDRStream nddsds, 
			   dbSensorOptionalData *nddsdbSensorOptionalData,
			   int options)
{
    return xdr_dbSensorOptionalData(NddsXDRGetSerializingStream(nddsds),
			       nddsdbSensorOptionalData);
}

/* ========================================================================
   dbSensorOptionalDataDeserialize \- NDDS deserialization method for dbSensorOptionalData 
   
   Required NDDS method to deserialize the data from an NDDSXDRStream buffer.
   The data was serialized by the dbSensorOptionalDataSerialize() function.

   If outArray==NULL (null pointer), this function will create a
   dbSensorOptionalData of the appropriate size to hold the data 
   (as required by NDDS).

   Returns the output array or NULL if an error occurred
 */
dbSensorOptionalData *dbSensorOptionalDataDeserialize(dbSensorOptionalData *nddsdbSensorOptionalData,
				      NDDSXDRStream nddsds)
{
    int allocated = RTI_FALSE;

    if (nddsdbSensorOptionalData == NULL) {
	allocated = RTI_TRUE;
	nddsdbSensorOptionalData =(dbSensorOptionalData *)calloc(1, sizeof(dbSensorOptionalData));
    }

    if (!xdr_dbSensorOptionalData(NddsXDRGetDeserializingStream(nddsds),
			     nddsdbSensorOptionalData))  {
	if (allocated) {
	    free(nddsdbSensorOptionalData);
	}
	return NULL;
    }
    
    return nddsdbSensorOptionalData;
}

/* ========================================================================
   dbSensorOptionalDataPrint \- NDDS Print method for dbSensorOptionalData objects

   Optional NDDS method to print the contents of an dbSensorOptionalData.

   Note that if this method *must* handle the case where the object
   is NULL.
 */
dbSensorOptionalData *dbSensorOptionalDataPrint(dbSensorOptionalData *nddsdbSensorOptionalData)
{
    /* Do not remove. dbSensorOptionalDataPrint must handle a NULL 
       dbSensorOptionalData 
       */
    if (nddsdbSensorOptionalData==NULL) {
	printf("dbSensorOptionalData: (null)\n");
	return NULL;
    }

    /* Replace by custom code if desired */
    if (!NddsXDRPrint_dbSensorOptionalData(nddsdbSensorOptionalData, "dbSensorOptionalData", 0)) {
	printf("NddsXDRPrintdbSensorOptionalData() failed on %p\n", 
	       nddsdbSensorOptionalData);
	return NULL;
    }

    /* Do not remove the return value */
    return nddsdbSensorOptionalData;
}

/* ========================================================================
   dbSensorOptionalDataSerializeSize \- NDDS size method for dbSensorOptionalData objects
 
   This optional NDDS method returns the maximum size of a dbSensorOptionalData object.
   The purpose of this method is to allow NDDS to optimize its memory usage.
 
   Users must be very careful and return a size that is equal-to or larger 
   than the maximum dbSensorOptionalData serialized. Please refer to NddsXdr(2) for
   functions to help determin the serialized size of basic types.

   If a -1 is returned then NDDS will default to a safe size, but will not
   be optimal.
 */
int dbSensorOptionalDataSerializeSize()
{
    return NddsXDRSerializeSize_dbSensorOptionalData();
}


/* ========================================================================
   dbSensorOptionalDataAllocate \- NDDS Allocate method for dbSensorOptionalData objects

   Optional NDDS method to allocate an NDDS object of type dbSensorOptionalData.

   If registered within dbSensorOptionalDataNddsRegister(), this method will be 
   invoked as a result of pattern subscriptions. When the NDDS agent 
   subscribes to a publication that matches the requested pattern, it
   needs to create a new object of the corresponding type to hold the 
   updates when they come. 
   It is for this purpose that dbSensorOptionalDataAllocate() is used.

   This method is not always required because dbSensorOptionalDataDeserialize()
   is usually able to allocate the object itself. There are however
   some cases (notably strings) for which the allocation provided
   by dbSensorOptionalDataDeserialize() isn't sufficient. Registration
   of dbSensorOptionalDataAllocate() allows to override the default allocation
   provided by dbSensorOptionalDataDeserialize().

   If this method is to be used, it must passed to NddsTypeRegister()
   (in function dbSensorOptionalDataNddsRegister()) instead of the default
   NULL method.

   This routine gets passed the type and name of the object instance and
   the parameter provided by the user passed in the 
   NddsSubscriptionGroupSubscriptionAdd(3) call.
 */
dbSensorOptionalData *dbSensorOptionalDataAllocate(const char *type, const char *name,
				   void *userParam)
{
    dbSensorOptionalData *nddsdbSensorOptionalData = NULL;

    nddsdbSensorOptionalData = (dbSensorOptionalData *)calloc(1, sizeof(*nddsdbSensorOptionalData));
    {
	/* Add the custom allocation of entries in the structure here */
    }

    return nddsdbSensorOptionalData;
}

/* ========================================================================
   dbSensorOptionalDataFree \- NDDS Free method for dbSensorOptionalData objects

   Optional NDDS method to Free an NDDS object of type dbSensorOptionalData.

   This method is not used in the current version of NDDS.
 */
RTIBool dbSensorOptionalDataFree(dbSensorOptionalData *inst, const char *type, const char *name,
		      void *userParam)
{
    return RTI_TRUE;
}

/* ========================================================================
   dbSensorOptionalDataNddsRegister \- Install dbSensorOptionalData type to NDDS
   
   This function will register an dbSensorOptionalData type with NDDS.   
   Registration must happen before any reference to the dbSensorOptionalData 
   type is given to NDDS.

   A description of the type dbSensorOptionalData was written in a file
   named dbSensorOptionalData.x (NOTE: the .x termination which is standard
   for this files is required.). This description uses the XDR language,
   which resembles "C"-like structure-type declarations. More information
   and examples on how to write these ".x" files can be found in the
   man page for 'nddsgen'.
 
   nddsgen was run on the dbRecord.x file. See the man pages
   on nddsgen and dbRecord for details.
 */
void dbSensorOptionalDataNddsRegister(void)
{
   NddsTypeRegister(dbSensorOptionalDataPublicationType,
	/*A #define in dbRecord.h*/
		    (SerializeMethodType)dbSensorOptionalDataSerialize,
		    (DeserializeMethodType)dbSensorOptionalDataDeserialize,
		    (PrintMethodType)dbSensorOptionalDataPrint,
		    (AllocateMethodType)NULL,
		    (FreeMethodType)NULL,
		    (SerializeSizeMethodType)dbSensorOptionalDataSerializeSize);
}
/* ========================================================================
   dbSensorReadingSerialize \- NDDS serialization method for dbSensorReading

   Required NDDS method to serialize an dbSensorReading into NDDSXDRStream 
   buffer.
   The data will be deserialized by the dbSensorReadingDeserialize() function.

   The 'options' may be defined and used for customizing serialization
   for different situations. Often (as in this case) they are simply 
   ignored.
 */
RTIBool dbSensorReadingSerialize(NDDSXDRStream nddsds, 
			   dbSensorReading *nddsdbSensorReading,
			   int options)
{
    return xdr_dbSensorReading(NddsXDRGetSerializingStream(nddsds),
			       nddsdbSensorReading);
}

/* ========================================================================
   dbSensorReadingDeserialize \- NDDS deserialization method for dbSensorReading 
   
   Required NDDS method to deserialize the data from an NDDSXDRStream buffer.
   The data was serialized by the dbSensorReadingSerialize() function.

   If outArray==NULL (null pointer), this function will create a
   dbSensorReading of the appropriate size to hold the data 
   (as required by NDDS).

   Returns the output array or NULL if an error occurred
 */
dbSensorReading *dbSensorReadingDeserialize(dbSensorReading *nddsdbSensorReading,
				      NDDSXDRStream nddsds)
{
    int allocated = RTI_FALSE;

    if (nddsdbSensorReading == NULL) {
	allocated = RTI_TRUE;
	nddsdbSensorReading =(dbSensorReading *)calloc(1, sizeof(dbSensorReading));
    }

    if (!xdr_dbSensorReading(NddsXDRGetDeserializingStream(nddsds),
			     nddsdbSensorReading))  {
	if (allocated) {
	    free(nddsdbSensorReading);
	}
	return NULL;
    }
    
    return nddsdbSensorReading;
}

/* ========================================================================
   dbSensorReadingPrint \- NDDS Print method for dbSensorReading objects

   Optional NDDS method to print the contents of an dbSensorReading.

   Note that if this method *must* handle the case where the object
   is NULL.
 */
dbSensorReading *dbSensorReadingPrint(dbSensorReading *nddsdbSensorReading)
{
    /* Do not remove. dbSensorReadingPrint must handle a NULL 
       dbSensorReading 
       */
    if (nddsdbSensorReading==NULL) {
	printf("dbSensorReading: (null)\n");
	return NULL;
    }

    /* Replace by custom code if desired */
    if (!NddsXDRPrint_dbSensorReading(nddsdbSensorReading, "dbSensorReading", 0)) {
	printf("NddsXDRPrintdbSensorReading() failed on %p\n", 
	       nddsdbSensorReading);
	return NULL;
    }

    /* Do not remove the return value */
    return nddsdbSensorReading;
}

/* ========================================================================
   dbSensorReadingSerializeSize \- NDDS size method for dbSensorReading objects
 
   This optional NDDS method returns the maximum size of a dbSensorReading object.
   The purpose of this method is to allow NDDS to optimize its memory usage.
 
   Users must be very careful and return a size that is equal-to or larger 
   than the maximum dbSensorReading serialized. Please refer to NddsXdr(2) for
   functions to help determin the serialized size of basic types.

   If a -1 is returned then NDDS will default to a safe size, but will not
   be optimal.
 */
int dbSensorReadingSerializeSize()
{
    return NddsXDRSerializeSize_dbSensorReading();
}


/* ========================================================================
   dbSensorReadingAllocate \- NDDS Allocate method for dbSensorReading objects

   Optional NDDS method to allocate an NDDS object of type dbSensorReading.

   If registered within dbSensorReadingNddsRegister(), this method will be 
   invoked as a result of pattern subscriptions. When the NDDS agent 
   subscribes to a publication that matches the requested pattern, it
   needs to create a new object of the corresponding type to hold the 
   updates when they come. 
   It is for this purpose that dbSensorReadingAllocate() is used.

   This method is not always required because dbSensorReadingDeserialize()
   is usually able to allocate the object itself. There are however
   some cases (notably strings) for which the allocation provided
   by dbSensorReadingDeserialize() isn't sufficient. Registration
   of dbSensorReadingAllocate() allows to override the default allocation
   provided by dbSensorReadingDeserialize().

   If this method is to be used, it must passed to NddsTypeRegister()
   (in function dbSensorReadingNddsRegister()) instead of the default
   NULL method.

   This routine gets passed the type and name of the object instance and
   the parameter provided by the user passed in the 
   NddsSubscriptionGroupSubscriptionAdd(3) call.
 */
dbSensorReading *dbSensorReadingAllocate(const char *type, const char *name,
				   void *userParam)
{
    dbSensorReading *nddsdbSensorReading = NULL;

    nddsdbSensorReading = (dbSensorReading *)calloc(1, sizeof(*nddsdbSensorReading));
    {
	/* Add the custom allocation of entries in the structure here */
    }

    return nddsdbSensorReading;
}

/* ========================================================================
   dbSensorReadingFree \- NDDS Free method for dbSensorReading objects

   Optional NDDS method to Free an NDDS object of type dbSensorReading.

   This method is not used in the current version of NDDS.
 */
RTIBool dbSensorReadingFree(dbSensorReading *inst, const char *type, const char *name,
		      void *userParam)
{
    return RTI_TRUE;
}

/* ========================================================================
   dbSensorReadingNddsRegister \- Install dbSensorReading type to NDDS
   
   This function will register an dbSensorReading type with NDDS.   
   Registration must happen before any reference to the dbSensorReading 
   type is given to NDDS.

   A description of the type dbSensorReading was written in a file
   named dbSensorReading.x (NOTE: the .x termination which is standard
   for this files is required.). This description uses the XDR language,
   which resembles "C"-like structure-type declarations. More information
   and examples on how to write these ".x" files can be found in the
   man page for 'nddsgen'.
 
   nddsgen was run on the dbRecord.x file. See the man pages
   on nddsgen and dbRecord for details.
 */
void dbSensorReadingNddsRegister(void)
{
   NddsTypeRegister(dbSensorReadingPublicationType,
	/*A #define in dbRecord.h*/
		    (SerializeMethodType)dbSensorReadingSerialize,
		    (DeserializeMethodType)dbSensorReadingDeserialize,
		    (PrintMethodType)dbSensorReadingPrint,
		    (AllocateMethodType)NULL,
		    (FreeMethodType)NULL,
		    (SerializeSizeMethodType)dbSensorReadingSerializeSize);
}
/* ========================================================================
   dbSensorDataSerialize \- NDDS serialization method for dbSensorData

   Required NDDS method to serialize an dbSensorData into NDDSXDRStream 
   buffer.
   The data will be deserialized by the dbSensorDataDeserialize() function.

   The 'options' may be defined and used for customizing serialization
   for different situations. Often (as in this case) they are simply 
   ignored.
 */
RTIBool dbSensorDataSerialize(NDDSXDRStream nddsds, 
			   dbSensorData *nddsdbSensorData,
			   int options)
{
    return xdr_dbSensorData(NddsXDRGetSerializingStream(nddsds),
			       nddsdbSensorData);
}

/* ========================================================================
   dbSensorDataDeserialize \- NDDS deserialization method for dbSensorData 
   
   Required NDDS method to deserialize the data from an NDDSXDRStream buffer.
   The data was serialized by the dbSensorDataSerialize() function.

   If outArray==NULL (null pointer), this function will create a
   dbSensorData of the appropriate size to hold the data 
   (as required by NDDS).

   Returns the output array or NULL if an error occurred
 */
dbSensorData *dbSensorDataDeserialize(dbSensorData *nddsdbSensorData,
				      NDDSXDRStream nddsds)
{
    int allocated = RTI_FALSE;

    if (nddsdbSensorData == NULL) {
	allocated = RTI_TRUE;
	nddsdbSensorData =(dbSensorData *)calloc(1, sizeof(dbSensorData));
    }

    if (!xdr_dbSensorData(NddsXDRGetDeserializingStream(nddsds),
			     nddsdbSensorData))  {
	if (allocated) {
	    free(nddsdbSensorData);
	}
	return NULL;
    }
    
    return nddsdbSensorData;
}

/* ========================================================================
   dbSensorDataPrint \- NDDS Print method for dbSensorData objects

   Optional NDDS method to print the contents of an dbSensorData.

   Note that if this method *must* handle the case where the object
   is NULL.
 */
dbSensorData *dbSensorDataPrint(dbSensorData *nddsdbSensorData)
{
    /* Do not remove. dbSensorDataPrint must handle a NULL 
       dbSensorData 
       */
    if (nddsdbSensorData==NULL) {
	printf("dbSensorData: (null)\n");
	return NULL;
    }

    /* Replace by custom code if desired */
    if (!NddsXDRPrint_dbSensorData(nddsdbSensorData, "dbSensorData", 0)) {
	printf("NddsXDRPrintdbSensorData() failed on %p\n", 
	       nddsdbSensorData);
	return NULL;
    }

    /* Do not remove the return value */
    return nddsdbSensorData;
}

/* ========================================================================
   dbSensorDataSerializeSize \- NDDS size method for dbSensorData objects
 
   This optional NDDS method returns the maximum size of a dbSensorData object.
   The purpose of this method is to allow NDDS to optimize its memory usage.
 
   Users must be very careful and return a size that is equal-to or larger 
   than the maximum dbSensorData serialized. Please refer to NddsXdr(2) for
   functions to help determin the serialized size of basic types.

   If a -1 is returned then NDDS will default to a safe size, but will not
   be optimal.
 */
int dbSensorDataSerializeSize()
{
    return NddsXDRSerializeSize_dbSensorData();
}


/* ========================================================================
   dbSensorDataAllocate \- NDDS Allocate method for dbSensorData objects

   Optional NDDS method to allocate an NDDS object of type dbSensorData.

   If registered within dbSensorDataNddsRegister(), this method will be 
   invoked as a result of pattern subscriptions. When the NDDS agent 
   subscribes to a publication that matches the requested pattern, it
   needs to create a new object of the corresponding type to hold the 
   updates when they come. 
   It is for this purpose that dbSensorDataAllocate() is used.

   This method is not always required because dbSensorDataDeserialize()
   is usually able to allocate the object itself. There are however
   some cases (notably strings) for which the allocation provided
   by dbSensorDataDeserialize() isn't sufficient. Registration
   of dbSensorDataAllocate() allows to override the default allocation
   provided by dbSensorDataDeserialize().

   If this method is to be used, it must passed to NddsTypeRegister()
   (in function dbSensorDataNddsRegister()) instead of the default
   NULL method.

   This routine gets passed the type and name of the object instance and
   the parameter provided by the user passed in the 
   NddsSubscriptionGroupSubscriptionAdd(3) call.
 */
dbSensorData *dbSensorDataAllocate(const char *type, const char *name,
				   void *userParam)
{
    dbSensorData *nddsdbSensorData = NULL;

    nddsdbSensorData = (dbSensorData *)calloc(1, sizeof(*nddsdbSensorData));
    {
	/* Add the custom allocation of entries in the structure here */
    }

    return nddsdbSensorData;
}

/* ========================================================================
   dbSensorDataFree \- NDDS Free method for dbSensorData objects

   Optional NDDS method to Free an NDDS object of type dbSensorData.

   This method is not used in the current version of NDDS.
 */
RTIBool dbSensorDataFree(dbSensorData *inst, const char *type, const char *name,
		      void *userParam)
{
    return RTI_TRUE;
}

/* ========================================================================
   dbSensorDataNddsRegister \- Install dbSensorData type to NDDS
   
   This function will register an dbSensorData type with NDDS.   
   Registration must happen before any reference to the dbSensorData 
   type is given to NDDS.

   A description of the type dbSensorData was written in a file
   named dbSensorData.x (NOTE: the .x termination which is standard
   for this files is required.). This description uses the XDR language,
   which resembles "C"-like structure-type declarations. More information
   and examples on how to write these ".x" files can be found in the
   man page for 'nddsgen'.
 
   nddsgen was run on the dbRecord.x file. See the man pages
   on nddsgen and dbRecord for details.
 */
void dbSensorDataNddsRegister(void)
{
   NddsTypeRegister(dbSensorDataPublicationType,
	/*A #define in dbRecord.h*/
		    (SerializeMethodType)dbSensorDataSerialize,
		    (DeserializeMethodType)dbSensorDataDeserialize,
		    (PrintMethodType)dbSensorDataPrint,
		    (AllocateMethodType)NULL,
		    (FreeMethodType)NULL,
		    (SerializeSizeMethodType)dbSensorDataSerializeSize);
}
/* ========================================================================
   dbRecordSerialize \- NDDS serialization method for dbRecord

   Required NDDS method to serialize an dbRecord into NDDSXDRStream 
   buffer.
   The data will be deserialized by the dbRecordDeserialize() function.

   The 'options' may be defined and used for customizing serialization
   for different situations. Often (as in this case) they are simply 
   ignored.
 */
RTIBool dbRecordSerialize(NDDSXDRStream nddsds, 
			   dbRecord *nddsdbRecord,
			   int options)
{
    return xdr_dbRecord(NddsXDRGetSerializingStream(nddsds),
			       nddsdbRecord);
}

/* ========================================================================
   dbRecordDeserialize \- NDDS deserialization method for dbRecord 
   
   Required NDDS method to deserialize the data from an NDDSXDRStream buffer.
   The data was serialized by the dbRecordSerialize() function.

   If outArray==NULL (null pointer), this function will create a
   dbRecord of the appropriate size to hold the data 
   (as required by NDDS).

   Returns the output array or NULL if an error occurred
 */
dbRecord *dbRecordDeserialize(dbRecord *nddsdbRecord,
				      NDDSXDRStream nddsds)
{
    int allocated = RTI_FALSE;

    if (nddsdbRecord == NULL) {
	allocated = RTI_TRUE;
	nddsdbRecord =(dbRecord *)calloc(1, sizeof(dbRecord));
    }

    if (!xdr_dbRecord(NddsXDRGetDeserializingStream(nddsds),
			     nddsdbRecord))  {
	if (allocated) {
	    free(nddsdbRecord);
	}
	return NULL;
    }
    
    return nddsdbRecord;
}

/* ========================================================================
   dbRecordPrint \- NDDS Print method for dbRecord objects

   Optional NDDS method to print the contents of an dbRecord.

   Note that if this method *must* handle the case where the object
   is NULL.
 */
dbRecord *dbRecordPrint(dbRecord *nddsdbRecord)
{
    /* Do not remove. dbRecordPrint must handle a NULL 
       dbRecord 
       */
    if (nddsdbRecord==NULL) {
	printf("dbRecord: (null)\n");
	return NULL;
    }

    /* Replace by custom code if desired */
    if (!NddsXDRPrint_dbRecord(nddsdbRecord, "dbRecord", 0)) {
	printf("NddsXDRPrintdbRecord() failed on %p\n", 
	       nddsdbRecord);
	return NULL;
    }

    /* Do not remove the return value */
    return nddsdbRecord;
}

/* ========================================================================
   dbRecordSerializeSize \- NDDS size method for dbRecord objects
 
   This optional NDDS method returns the maximum size of a dbRecord object.
   The purpose of this method is to allow NDDS to optimize its memory usage.
 
   Users must be very careful and return a size that is equal-to or larger 
   than the maximum dbRecord serialized. Please refer to NddsXdr(2) for
   functions to help determin the serialized size of basic types.

   If a -1 is returned then NDDS will default to a safe size, but will not
   be optimal.
 */
int dbRecordSerializeSize()
{
    return NddsXDRSerializeSize_dbRecord();
}


/* ========================================================================
   dbRecordAllocate \- NDDS Allocate method for dbRecord objects

   Optional NDDS method to allocate an NDDS object of type dbRecord.

   If registered within dbRecordNddsRegister(), this method will be 
   invoked as a result of pattern subscriptions. When the NDDS agent 
   subscribes to a publication that matches the requested pattern, it
   needs to create a new object of the corresponding type to hold the 
   updates when they come. 
   It is for this purpose that dbRecordAllocate() is used.

   This method is not always required because dbRecordDeserialize()
   is usually able to allocate the object itself. There are however
   some cases (notably strings) for which the allocation provided
   by dbRecordDeserialize() isn't sufficient. Registration
   of dbRecordAllocate() allows to override the default allocation
   provided by dbRecordDeserialize().

   If this method is to be used, it must passed to NddsTypeRegister()
   (in function dbRecordNddsRegister()) instead of the default
   NULL method.

   This routine gets passed the type and name of the object instance and
   the parameter provided by the user passed in the 
   NddsSubscriptionGroupSubscriptionAdd(3) call.
 */
dbRecord *dbRecordAllocate(const char *type, const char *name,
				   void *userParam)
{
    dbRecord *nddsdbRecord = NULL;

    nddsdbRecord = (dbRecord *)calloc(1, sizeof(*nddsdbRecord));
    {
	/* Add the custom allocation of entries in the structure here */
    }

    return nddsdbRecord;
}

/* ========================================================================
   dbRecordFree \- NDDS Free method for dbRecord objects

   Optional NDDS method to Free an NDDS object of type dbRecord.

   This method is not used in the current version of NDDS.
 */
RTIBool dbRecordFree(dbRecord *inst, const char *type, const char *name,
		      void *userParam)
{
    return RTI_TRUE;
}

/* ========================================================================
   dbRecordNddsRegister \- Install dbRecord type to NDDS
   
   This function will register an dbRecord type with NDDS.   
   Registration must happen before any reference to the dbRecord 
   type is given to NDDS.

   A description of the type dbRecord was written in a file
   named dbRecord.x (NOTE: the .x termination which is standard
   for this files is required.). This description uses the XDR language,
   which resembles "C"-like structure-type declarations. More information
   and examples on how to write these ".x" files can be found in the
   man page for 'nddsgen'.
 
   nddsgen was run on the dbRecord.x file. See the man pages
   on nddsgen and dbRecord for details.
 */
void dbRecordNddsRegister(void)
{
   NddsTypeRegister(dbRecordPublicationType,
	/*A #define in dbRecord.h*/
		    (SerializeMethodType)dbRecordSerialize,
		    (DeserializeMethodType)dbRecordDeserialize,
		    (PrintMethodType)dbRecordPrint,
		    (AllocateMethodType)NULL,
		    (FreeMethodType)NULL,
		    (SerializeSizeMethodType)dbRecordSerializeSize);
}
/* ========================================================================
   dbSensorReadingBitMaskSerialize \- NDDS serialization method for dbSensorReadingBitMask

   Required NDDS method to serialize an dbSensorReadingBitMask into NDDSXDRStream 
   buffer.
   The data will be deserialized by the dbSensorReadingBitMaskDeserialize() function.

   The 'options' may be defined and used for customizing serialization
   for different situations. Often (as in this case) they are simply 
   ignored.
 */
RTIBool dbSensorReadingBitMaskSerialize(NDDSXDRStream nddsds, 
			   dbSensorReadingBitMask *nddsdbSensorReadingBitMask,
			   int options)
{
    return xdr_dbSensorReadingBitMask(NddsXDRGetSerializingStream(nddsds),
			       nddsdbSensorReadingBitMask);
}

/* ========================================================================
   dbSensorReadingBitMaskDeserialize \- NDDS deserialization method for dbSensorReadingBitMask 
   
   Required NDDS method to deserialize the data from an NDDSXDRStream buffer.
   The data was serialized by the dbSensorReadingBitMaskSerialize() function.

   If outArray==NULL (null pointer), this function will create a
   dbSensorReadingBitMask of the appropriate size to hold the data 
   (as required by NDDS).

   Returns the output array or NULL if an error occurred
 */
dbSensorReadingBitMask *dbSensorReadingBitMaskDeserialize(dbSensorReadingBitMask *nddsdbSensorReadingBitMask,
				      NDDSXDRStream nddsds)
{
    int allocated = RTI_FALSE;

    if (nddsdbSensorReadingBitMask == NULL) {
	allocated = RTI_TRUE;
	nddsdbSensorReadingBitMask =(dbSensorReadingBitMask *)calloc(1, sizeof(dbSensorReadingBitMask));
    }

    if (!xdr_dbSensorReadingBitMask(NddsXDRGetDeserializingStream(nddsds),
			     nddsdbSensorReadingBitMask))  {
	if (allocated) {
	    free(nddsdbSensorReadingBitMask);
	}
	return NULL;
    }
    
    return nddsdbSensorReadingBitMask;
}

/* ========================================================================
   dbSensorReadingBitMaskPrint \- NDDS Print method for dbSensorReadingBitMask objects

   Optional NDDS method to print the contents of an dbSensorReadingBitMask.

   Note that if this method *must* handle the case where the object
   is NULL.
 */
dbSensorReadingBitMask *dbSensorReadingBitMaskPrint(dbSensorReadingBitMask *nddsdbSensorReadingBitMask)
{
    /* Do not remove. dbSensorReadingBitMaskPrint must handle a NULL 
       dbSensorReadingBitMask 
       */
    if (nddsdbSensorReadingBitMask==NULL) {
	printf("dbSensorReadingBitMask: (null)\n");
	return NULL;
    }

    /* Replace by custom code if desired */
    if (!NddsXDRPrint_dbSensorReadingBitMask(nddsdbSensorReadingBitMask, "dbSensorReadingBitMask", 0)) {
	printf("NddsXDRPrintdbSensorReadingBitMask() failed on %p\n", 
	       nddsdbSensorReadingBitMask);
	return NULL;
    }

    /* Do not remove the return value */
    return nddsdbSensorReadingBitMask;
}

/* ========================================================================
   dbSensorReadingBitMaskSerializeSize \- NDDS size method for dbSensorReadingBitMask objects
 
   This optional NDDS method returns the maximum size of a dbSensorReadingBitMask object.
   The purpose of this method is to allow NDDS to optimize its memory usage.
 
   Users must be very careful and return a size that is equal-to or larger 
   than the maximum dbSensorReadingBitMask serialized. Please refer to NddsXdr(2) for
   functions to help determin the serialized size of basic types.

   If a -1 is returned then NDDS will default to a safe size, but will not
   be optimal.
 */
int dbSensorReadingBitMaskSerializeSize()
{
    return NddsXDRSerializeSize_dbSensorReadingBitMask();
}


/* ========================================================================
   dbSensorReadingBitMaskAllocate \- NDDS Allocate method for dbSensorReadingBitMask objects

   Optional NDDS method to allocate an NDDS object of type dbSensorReadingBitMask.

   If registered within dbSensorReadingBitMaskNddsRegister(), this method will be 
   invoked as a result of pattern subscriptions. When the NDDS agent 
   subscribes to a publication that matches the requested pattern, it
   needs to create a new object of the corresponding type to hold the 
   updates when they come. 
   It is for this purpose that dbSensorReadingBitMaskAllocate() is used.

   This method is not always required because dbSensorReadingBitMaskDeserialize()
   is usually able to allocate the object itself. There are however
   some cases (notably strings) for which the allocation provided
   by dbSensorReadingBitMaskDeserialize() isn't sufficient. Registration
   of dbSensorReadingBitMaskAllocate() allows to override the default allocation
   provided by dbSensorReadingBitMaskDeserialize().

   If this method is to be used, it must passed to NddsTypeRegister()
   (in function dbSensorReadingBitMaskNddsRegister()) instead of the default
   NULL method.

   This routine gets passed the type and name of the object instance and
   the parameter provided by the user passed in the 
   NddsSubscriptionGroupSubscriptionAdd(3) call.
 */
dbSensorReadingBitMask *dbSensorReadingBitMaskAllocate(const char *type, const char *name,
				   void *userParam)
{
    dbSensorReadingBitMask *nddsdbSensorReadingBitMask = NULL;

    nddsdbSensorReadingBitMask = (dbSensorReadingBitMask *)calloc(1, sizeof(*nddsdbSensorReadingBitMask));
    {
	/* Add the custom allocation of entries in the structure here */
    }

    return nddsdbSensorReadingBitMask;
}

/* ========================================================================
   dbSensorReadingBitMaskFree \- NDDS Free method for dbSensorReadingBitMask objects

   Optional NDDS method to Free an NDDS object of type dbSensorReadingBitMask.

   This method is not used in the current version of NDDS.
 */
RTIBool dbSensorReadingBitMaskFree(dbSensorReadingBitMask *inst, const char *type, const char *name,
		      void *userParam)
{
    return RTI_TRUE;
}

/* ========================================================================
   dbSensorReadingBitMaskNddsRegister \- Install dbSensorReadingBitMask type to NDDS
   
   This function will register an dbSensorReadingBitMask type with NDDS.   
   Registration must happen before any reference to the dbSensorReadingBitMask 
   type is given to NDDS.

   A description of the type dbSensorReadingBitMask was written in a file
   named dbSensorReadingBitMask.x (NOTE: the .x termination which is standard
   for this files is required.). This description uses the XDR language,
   which resembles "C"-like structure-type declarations. More information
   and examples on how to write these ".x" files can be found in the
   man page for 'nddsgen'.
 
   nddsgen was run on the dbRecord.x file. See the man pages
   on nddsgen and dbRecord for details.
 */
void dbSensorReadingBitMaskNddsRegister(void)
{
   NddsTypeRegister(dbSensorReadingBitMaskPublicationType,
	/*A #define in dbRecord.h*/
		    (SerializeMethodType)dbSensorReadingBitMaskSerialize,
		    (DeserializeMethodType)dbSensorReadingBitMaskDeserialize,
		    (PrintMethodType)dbSensorReadingBitMaskPrint,
		    (AllocateMethodType)NULL,
		    (FreeMethodType)NULL,
		    (SerializeSizeMethodType)dbSensorReadingBitMaskSerializeSize);
}
/* ========================================================================
   dbSensorDataBitMaskSerialize \- NDDS serialization method for dbSensorDataBitMask

   Required NDDS method to serialize an dbSensorDataBitMask into NDDSXDRStream 
   buffer.
   The data will be deserialized by the dbSensorDataBitMaskDeserialize() function.

   The 'options' may be defined and used for customizing serialization
   for different situations. Often (as in this case) they are simply 
   ignored.
 */
RTIBool dbSensorDataBitMaskSerialize(NDDSXDRStream nddsds, 
			   dbSensorDataBitMask *nddsdbSensorDataBitMask,
			   int options)
{
    return xdr_dbSensorDataBitMask(NddsXDRGetSerializingStream(nddsds),
			       nddsdbSensorDataBitMask);
}

/* ========================================================================
   dbSensorDataBitMaskDeserialize \- NDDS deserialization method for dbSensorDataBitMask 
   
   Required NDDS method to deserialize the data from an NDDSXDRStream buffer.
   The data was serialized by the dbSensorDataBitMaskSerialize() function.

   If outArray==NULL (null pointer), this function will create a
   dbSensorDataBitMask of the appropriate size to hold the data 
   (as required by NDDS).

   Returns the output array or NULL if an error occurred
 */
dbSensorDataBitMask *dbSensorDataBitMaskDeserialize(dbSensorDataBitMask *nddsdbSensorDataBitMask,
				      NDDSXDRStream nddsds)
{
    int allocated = RTI_FALSE;

    if (nddsdbSensorDataBitMask == NULL) {
	allocated = RTI_TRUE;
	nddsdbSensorDataBitMask =(dbSensorDataBitMask *)calloc(1, sizeof(dbSensorDataBitMask));
    }

    if (!xdr_dbSensorDataBitMask(NddsXDRGetDeserializingStream(nddsds),
			     nddsdbSensorDataBitMask))  {
	if (allocated) {
	    free(nddsdbSensorDataBitMask);
	}
	return NULL;
    }
    
    return nddsdbSensorDataBitMask;
}

/* ========================================================================
   dbSensorDataBitMaskPrint \- NDDS Print method for dbSensorDataBitMask objects

   Optional NDDS method to print the contents of an dbSensorDataBitMask.

   Note that if this method *must* handle the case where the object
   is NULL.
 */
dbSensorDataBitMask *dbSensorDataBitMaskPrint(dbSensorDataBitMask *nddsdbSensorDataBitMask)
{
    /* Do not remove. dbSensorDataBitMaskPrint must handle a NULL 
       dbSensorDataBitMask 
       */
    if (nddsdbSensorDataBitMask==NULL) {
	printf("dbSensorDataBitMask: (null)\n");
	return NULL;
    }

    /* Replace by custom code if desired */
    if (!NddsXDRPrint_dbSensorDataBitMask(nddsdbSensorDataBitMask, "dbSensorDataBitMask", 0)) {
	printf("NddsXDRPrintdbSensorDataBitMask() failed on %p\n", 
	       nddsdbSensorDataBitMask);
	return NULL;
    }

    /* Do not remove the return value */
    return nddsdbSensorDataBitMask;
}

/* ========================================================================
   dbSensorDataBitMaskSerializeSize \- NDDS size method for dbSensorDataBitMask objects
 
   This optional NDDS method returns the maximum size of a dbSensorDataBitMask object.
   The purpose of this method is to allow NDDS to optimize its memory usage.
 
   Users must be very careful and return a size that is equal-to or larger 
   than the maximum dbSensorDataBitMask serialized. Please refer to NddsXdr(2) for
   functions to help determin the serialized size of basic types.

   If a -1 is returned then NDDS will default to a safe size, but will not
   be optimal.
 */
int dbSensorDataBitMaskSerializeSize()
{
    return NddsXDRSerializeSize_dbSensorDataBitMask();
}


/* ========================================================================
   dbSensorDataBitMaskAllocate \- NDDS Allocate method for dbSensorDataBitMask objects

   Optional NDDS method to allocate an NDDS object of type dbSensorDataBitMask.

   If registered within dbSensorDataBitMaskNddsRegister(), this method will be 
   invoked as a result of pattern subscriptions. When the NDDS agent 
   subscribes to a publication that matches the requested pattern, it
   needs to create a new object of the corresponding type to hold the 
   updates when they come. 
   It is for this purpose that dbSensorDataBitMaskAllocate() is used.

   This method is not always required because dbSensorDataBitMaskDeserialize()
   is usually able to allocate the object itself. There are however
   some cases (notably strings) for which the allocation provided
   by dbSensorDataBitMaskDeserialize() isn't sufficient. Registration
   of dbSensorDataBitMaskAllocate() allows to override the default allocation
   provided by dbSensorDataBitMaskDeserialize().

   If this method is to be used, it must passed to NddsTypeRegister()
   (in function dbSensorDataBitMaskNddsRegister()) instead of the default
   NULL method.

   This routine gets passed the type and name of the object instance and
   the parameter provided by the user passed in the 
   NddsSubscriptionGroupSubscriptionAdd(3) call.
 */
dbSensorDataBitMask *dbSensorDataBitMaskAllocate(const char *type, const char *name,
				   void *userParam)
{
    dbSensorDataBitMask *nddsdbSensorDataBitMask = NULL;

    nddsdbSensorDataBitMask = (dbSensorDataBitMask *)calloc(1, sizeof(*nddsdbSensorDataBitMask));
    {
	/* Add the custom allocation of entries in the structure here */
    }

    return nddsdbSensorDataBitMask;
}

/* ========================================================================
   dbSensorDataBitMaskFree \- NDDS Free method for dbSensorDataBitMask objects

   Optional NDDS method to Free an NDDS object of type dbSensorDataBitMask.

   This method is not used in the current version of NDDS.
 */
RTIBool dbSensorDataBitMaskFree(dbSensorDataBitMask *inst, const char *type, const char *name,
		      void *userParam)
{
    return RTI_TRUE;
}

/* ========================================================================
   dbSensorDataBitMaskNddsRegister \- Install dbSensorDataBitMask type to NDDS
   
   This function will register an dbSensorDataBitMask type with NDDS.   
   Registration must happen before any reference to the dbSensorDataBitMask 
   type is given to NDDS.

   A description of the type dbSensorDataBitMask was written in a file
   named dbSensorDataBitMask.x (NOTE: the .x termination which is standard
   for this files is required.). This description uses the XDR language,
   which resembles "C"-like structure-type declarations. More information
   and examples on how to write these ".x" files can be found in the
   man page for 'nddsgen'.
 
   nddsgen was run on the dbRecord.x file. See the man pages
   on nddsgen and dbRecord for details.
 */
void dbSensorDataBitMaskNddsRegister(void)
{
   NddsTypeRegister(dbSensorDataBitMaskPublicationType,
	/*A #define in dbRecord.h*/
		    (SerializeMethodType)dbSensorDataBitMaskSerialize,
		    (DeserializeMethodType)dbSensorDataBitMaskDeserialize,
		    (PrintMethodType)dbSensorDataBitMaskPrint,
		    (AllocateMethodType)NULL,
		    (FreeMethodType)NULL,
		    (SerializeSizeMethodType)dbSensorDataBitMaskSerializeSize);
}
/* ========================================================================
   dbRecordBitMaskSerialize \- NDDS serialization method for dbRecordBitMask

   Required NDDS method to serialize an dbRecordBitMask into NDDSXDRStream 
   buffer.
   The data will be deserialized by the dbRecordBitMaskDeserialize() function.

   The 'options' may be defined and used for customizing serialization
   for different situations. Often (as in this case) they are simply 
   ignored.
 */
RTIBool dbRecordBitMaskSerialize(NDDSXDRStream nddsds, 
			   dbRecordBitMask *nddsdbRecordBitMask,
			   int options)
{
    return xdr_dbRecordBitMask(NddsXDRGetSerializingStream(nddsds),
			       nddsdbRecordBitMask);
}

/* ========================================================================
   dbRecordBitMaskDeserialize \- NDDS deserialization method for dbRecordBitMask 
   
   Required NDDS method to deserialize the data from an NDDSXDRStream buffer.
   The data was serialized by the dbRecordBitMaskSerialize() function.

   If outArray==NULL (null pointer), this function will create a
   dbRecordBitMask of the appropriate size to hold the data 
   (as required by NDDS).

   Returns the output array or NULL if an error occurred
 */
dbRecordBitMask *dbRecordBitMaskDeserialize(dbRecordBitMask *nddsdbRecordBitMask,
				      NDDSXDRStream nddsds)
{
    int allocated = RTI_FALSE;

    if (nddsdbRecordBitMask == NULL) {
	allocated = RTI_TRUE;
	nddsdbRecordBitMask =(dbRecordBitMask *)calloc(1, sizeof(dbRecordBitMask));
    }

    if (!xdr_dbRecordBitMask(NddsXDRGetDeserializingStream(nddsds),
			     nddsdbRecordBitMask))  {
	if (allocated) {
	    free(nddsdbRecordBitMask);
	}
	return NULL;
    }
    
    return nddsdbRecordBitMask;
}

/* ========================================================================
   dbRecordBitMaskPrint \- NDDS Print method for dbRecordBitMask objects

   Optional NDDS method to print the contents of an dbRecordBitMask.

   Note that if this method *must* handle the case where the object
   is NULL.
 */
dbRecordBitMask *dbRecordBitMaskPrint(dbRecordBitMask *nddsdbRecordBitMask)
{
    /* Do not remove. dbRecordBitMaskPrint must handle a NULL 
       dbRecordBitMask 
       */
    if (nddsdbRecordBitMask==NULL) {
	printf("dbRecordBitMask: (null)\n");
	return NULL;
    }

    /* Replace by custom code if desired */
    if (!NddsXDRPrint_dbRecordBitMask(nddsdbRecordBitMask, "dbRecordBitMask", 0)) {
	printf("NddsXDRPrintdbRecordBitMask() failed on %p\n", 
	       nddsdbRecordBitMask);
	return NULL;
    }

    /* Do not remove the return value */
    return nddsdbRecordBitMask;
}

/* ========================================================================
   dbRecordBitMaskSerializeSize \- NDDS size method for dbRecordBitMask objects
 
   This optional NDDS method returns the maximum size of a dbRecordBitMask object.
   The purpose of this method is to allow NDDS to optimize its memory usage.
 
   Users must be very careful and return a size that is equal-to or larger 
   than the maximum dbRecordBitMask serialized. Please refer to NddsXdr(2) for
   functions to help determin the serialized size of basic types.

   If a -1 is returned then NDDS will default to a safe size, but will not
   be optimal.
 */
int dbRecordBitMaskSerializeSize()
{
    return NddsXDRSerializeSize_dbRecordBitMask();
}


/* ========================================================================
   dbRecordBitMaskAllocate \- NDDS Allocate method for dbRecordBitMask objects

   Optional NDDS method to allocate an NDDS object of type dbRecordBitMask.

   If registered within dbRecordBitMaskNddsRegister(), this method will be 
   invoked as a result of pattern subscriptions. When the NDDS agent 
   subscribes to a publication that matches the requested pattern, it
   needs to create a new object of the corresponding type to hold the 
   updates when they come. 
   It is for this purpose that dbRecordBitMaskAllocate() is used.

   This method is not always required because dbRecordBitMaskDeserialize()
   is usually able to allocate the object itself. There are however
   some cases (notably strings) for which the allocation provided
   by dbRecordBitMaskDeserialize() isn't sufficient. Registration
   of dbRecordBitMaskAllocate() allows to override the default allocation
   provided by dbRecordBitMaskDeserialize().

   If this method is to be used, it must passed to NddsTypeRegister()
   (in function dbRecordBitMaskNddsRegister()) instead of the default
   NULL method.

   This routine gets passed the type and name of the object instance and
   the parameter provided by the user passed in the 
   NddsSubscriptionGroupSubscriptionAdd(3) call.
 */
dbRecordBitMask *dbRecordBitMaskAllocate(const char *type, const char *name,
				   void *userParam)
{
    dbRecordBitMask *nddsdbRecordBitMask = NULL;

    nddsdbRecordBitMask = (dbRecordBitMask *)calloc(1, sizeof(*nddsdbRecordBitMask));
    {
	/* Add the custom allocation of entries in the structure here */
    }

    return nddsdbRecordBitMask;
}

/* ========================================================================
   dbRecordBitMaskFree \- NDDS Free method for dbRecordBitMask objects

   Optional NDDS method to Free an NDDS object of type dbRecordBitMask.

   This method is not used in the current version of NDDS.
 */
RTIBool dbRecordBitMaskFree(dbRecordBitMask *inst, const char *type, const char *name,
		      void *userParam)
{
    return RTI_TRUE;
}

/* ========================================================================
   dbRecordBitMaskNddsRegister \- Install dbRecordBitMask type to NDDS
   
   This function will register an dbRecordBitMask type with NDDS.   
   Registration must happen before any reference to the dbRecordBitMask 
   type is given to NDDS.

   A description of the type dbRecordBitMask was written in a file
   named dbRecordBitMask.x (NOTE: the .x termination which is standard
   for this files is required.). This description uses the XDR language,
   which resembles "C"-like structure-type declarations. More information
   and examples on how to write these ".x" files can be found in the
   man page for 'nddsgen'.
 
   nddsgen was run on the dbRecord.x file. See the man pages
   on nddsgen and dbRecord for details.
 */
void dbRecordBitMaskNddsRegister(void)
{
   NddsTypeRegister(dbRecordBitMaskPublicationType,
	/*A #define in dbRecord.h*/
		    (SerializeMethodType)dbRecordBitMaskSerialize,
		    (DeserializeMethodType)dbRecordBitMaskDeserialize,
		    (PrintMethodType)dbRecordBitMaskPrint,
		    (AllocateMethodType)NULL,
		    (FreeMethodType)NULL,
		    (SerializeSizeMethodType)dbRecordBitMaskSerializeSize);
}
