/**************************
 * CREATED: 3/26/99
 * AUTHOR: Michael Wagner
 * DESCRIPTION:
 *    The file dbMsgs.x contains all messages used to communicate with the
 *  SAS database.
 **************************/

%#include "dbRecord.h"
%#include "dbDef.h"

/**************************
 * NDDS MESSAGE: dbRequest
 * CREATED: 3/12/99
 * AUTHOR:  Michael Wagner
 * SOURCE: Any
 * DESTINATION: Database
 *
 * DESCRIPTION:
 *    dbRequest is the message sent by a database client to request something.
 *  See the file dbDef.h for more information.
 */

PublicationType dbRequest;
struct dbRequest {
  int function;                  /* See dbDef.h for enumerations. */
  dbRecord record;               /* See dbRecord.h for definition. */
  dbRecordBitMask recordBitMask; /* " " " */
  char name [DB_MAX_SAVE_FILENAME_LENGTH]; /* Used as a filename or sensor manager driver ID */
	                                     /* NOTE: This must be the maximum of 
						DB_MAX_SAVE_FILENAME_LENGTH and 
						SM_DRIVER_MAX_ID_LENGTH */
  int numIDs; /* Used for many possible things:
		 1) If function == DB_INSERT_MULTI_FUNCTION, this stores the # of IDs to insert.
		 2) If function == DB_SEARCH_MULTI_FUNCTION, this stores the # of matches to return (must be
		    less than DB_MAX_REPLY_IDS).
	      */
  int driverNum; /* For a DB_GET_SM_DRIVER_NAME_FUNCTION request, this is the sensor manager driver number that is being queried. */
}; 

/**************************
 * NDDS MESSAGE: dbReply
 * CREATED: 4/12/99
 * AUTHOR:  Michael Wagner
 * SOURCE: database
 * DESTINATION: any
 *
 * DESCRIPTION:
 *    dbReply the message sent by the database in response to a client
 *  request. See the file dbDef.h for more information.
 */

PublicationType dbReply;
struct dbReply {
  int status;                    /* See dbDef.h for enumerations. */
  dbRecord record;               /* See dbRecord.h for definition. */
  dbRecordBitMask recordBitMask; /* " " " */
  char name [DB_MAX_SAVE_FILENAME_LENGTH]; /* NOTE: This must be the maximum of 
						DB_MAX_SAVE_FILENAME_LENGTH and 
						SM_DRIVER_MAX_ID_LENGTH */
  int IDs[DB_MAX_REPLY_IDS]; /* Used for many possible things:
				1) If function == DB_INSERT_MULTI_FUNCTION, IDs[0] stores the first ID inserted, and IDs[1]
				   stores the last ID inserted (all insertions should be atomic -- so a continuous range of
				   IDs are inserted at a time).
				2) If function == DB_SEARCH_MULTI_FUNCTION, this returns the IDs that matched the search
			           criteria. 
			     */		
  int numRecords;
}; 

/**************************
 * NDDS MESSAGE: dbNotify
 * CREATED: 6/24/99
 * AUTHOR:  Michael Wagner
 * SOURCE: database
 * DESTINATION: any
 *
 * DESCRIPTION:
 *    dbNotify is sent out after a record in the database
 * changes (see function for what function has occured).
 */

PublicationType dbNotify;
struct dbNotify {
  int function;             /* See dbDef.h */
  dbRecord record;
  dbRecordBitMask changed;
};
