/*
 * @(#)dbMsgs.h    generated by: nddsgen
 *
 * built from:	dbMsgs.c
 */

#ifndef dbMsgs_h
#define dbMsgs_h

#include "ndds/NDDS.h"
#include <rpc/types.h>
#include <rpc/xdr.h>

#ifdef __cplusplus
    extern "C" {
#endif
#include "dbRecord.h"
#include "dbDef.h"


typedef struct dbRequest {
    int function;
    dbRecord record;
    dbRecordBitMask recordBitMask;
    char name[DB_MAX_SAVE_FILENAME_LENGTH];
    int numIDs;
    int driverNum;
} dbRequest;


typedef struct dbReply {
    int status;
    dbRecord record;
    dbRecordBitMask recordBitMask;
    char name[DB_MAX_SAVE_FILENAME_LENGTH];
    int IDs[DB_MAX_REPLY_IDS];
    int numRecords;
} dbReply;


typedef struct dbNotify {
    int function;
    dbRecord record;
    dbRecordBitMask changed;
} dbNotify;

#define dbRequestPublicationType "dbRequest"

#define dbReplyPublicationType "dbReply"

#define dbNotifyPublicationType "dbNotify"

extern RTIBool          dbRequestSerialize(NDDSXDRStream nddsds, 
				           dbRequest *nddsdbRequest, 
                                           int options);
extern dbRequest *dbRequestDeserialize(dbRequest *nddsdbRequest,
				             NDDSXDRStream nddsds);
extern dbRequest *dbRequestPrint(dbRequest *nddsdbRequest);
extern int           dbRequestSerializeSize();
extern void          dbRequestNddsRegister();

extern RTIBool          dbReplySerialize(NDDSXDRStream nddsds, 
				           dbReply *nddsdbReply, 
                                           int options);
extern dbReply *dbReplyDeserialize(dbReply *nddsdbReply,
				             NDDSXDRStream nddsds);
extern dbReply *dbReplyPrint(dbReply *nddsdbReply);
extern int           dbReplySerializeSize();
extern void          dbReplyNddsRegister();

extern RTIBool          dbNotifySerialize(NDDSXDRStream nddsds, 
				           dbNotify *nddsdbNotify, 
                                           int options);
extern dbNotify *dbNotifyDeserialize(dbNotify *nddsdbNotify,
				             NDDSXDRStream nddsds);
extern dbNotify *dbNotifyPrint(dbNotify *nddsdbNotify);
extern int           dbNotifySerializeSize();
extern void          dbNotifyNddsRegister();

#ifdef __cplusplus
    }   /* extern "C" */
#endif

#endif /* dbMsgs_h*/
