/* mangen dbMsgs \- NDDS methods for dbMsgs type.
   banner = ==========
  
   This file is derived from code automatically generated by nddsgen.
 */

static char copyright_rti[] = 
"(c) Copyright, Real-Time Innovations, Inc., 1994.  All rights reserved.";

/*
DESCRIPTION:
  This file was automatically generated by the 'nddsgen' code generator from the
  XDR file dbMsgs.x.  See the man pages on 'nddsgen' and 'NddsXDR'.

  This file was generated with the following steps:

(1) One or more XDR descriptions where written into a file named 
    dbMsgs.x (NOTE: the .x termination which is standard for this 
    files is required.). This description uses the XDR language,
    which resembles "C"-like structure-type declarations. More information 
    and examples on how to write these ".x" files can be found in the 
    on-line html page for 'nddsgen'.

(2) 'nddsgen' was run on the dbMsgs.x file. The command was:
    /usr/mwagner/nomad/src/SAS/messages/database/nddsgen dbMsgs.x -replace

    This created the dbMsgs.c, and dbMsgs.h.

(3) The dbMsgs_stub.c is copied into dbMsgs.c;
    if you pass "-replace" during nddsgen. This file contains the functions, 
    NddsTypeNameSeralize(), NddsTypeNameDeserialize(), and NddsTypeNamePrint() 
    for each NDDS type.

(4) The user may want to fill in the code for the NddsTypeNamePrint()
    function if they want NDDS to print the NddsTypeName automatically
    in certain situations. This isn't required.

(5) The file dbMsgs.c also contains functions to register, and 
    test NDDS types.

SEE ALSO:
  nddsgen(1), NddsXDR(2), Ndds(2)
--------------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <rpc/types.h>
#include <rpc/xdr.h>

#include "dbMsgs.h"
#include "dbRecord.h"
#include "dbDef.h"


int NddsXDRSerializeSize_dbRequest()
{
    int size = 0;
    size += NddsXDRSerializeSize_int(); /* function */
    size += NddsXDRSerializeSize_dbRecord(); /* record */
    size += NddsXDRSerializeSize_dbRecordBitMask(); /* recordBitMask */
    size += NddsXDRSerializeSize_array(DB_MAX_SAVE_FILENAME_LENGTH, NddsXDRSerializeSize_char()); /* name */
    size += NddsXDRSerializeSize_int(); /* numIDs */
    size += NddsXDRSerializeSize_int(); /* driverNum */
    return size;
}




bool_t
NddsXDRPrint_dbRequest(dbRequest *objp, char *desc, int indent)
{
    int i;
    for (i=0; i<indent; i++) { printf("  "); }
    printf("%s:\n", desc);

    if (!NddsXDRPrint_int(&objp->function, "function", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_dbRecord(&objp->record, "record", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_dbRecordBitMask(&objp->recordBitMask, "recordBitMask", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_array(objp->name, DB_MAX_SAVE_FILENAME_LENGTH, sizeof(char), (NddsXDRPrintFncType)NddsXDRPrint_char, "name", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_int(&objp->numIDs, "numIDs", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_int(&objp->driverNum, "driverNum", indent+1)) {
        return (FALSE);
    }
    return (TRUE);
}




bool_t
xdr_dbRequest(XDR *xdrs, dbRequest *objp)
{
    if (!xdr_int(xdrs, &objp->function)) {
    	return (FALSE);
    }
    if (!xdr_dbRecord(xdrs, &objp->record)) {
    	return (FALSE);
    }
    if (!xdr_dbRecordBitMask(xdrs, &objp->recordBitMask)) {
    	return (FALSE);
    }
    if (!xdr_vector(xdrs, (char *)objp->name, DB_MAX_SAVE_FILENAME_LENGTH, sizeof(char), xdr_char)) {
    	return (FALSE);
    }
    if (!xdr_int(xdrs, &objp->numIDs)) {
    	return (FALSE);
    }
    if (!xdr_int(xdrs, &objp->driverNum)) {
    	return (FALSE);
    }
    return (TRUE);
}




int NddsXDRSerializeSize_dbReply()
{
    int size = 0;
    size += NddsXDRSerializeSize_int(); /* status */
    size += NddsXDRSerializeSize_dbRecord(); /* record */
    size += NddsXDRSerializeSize_dbRecordBitMask(); /* recordBitMask */
    size += NddsXDRSerializeSize_array(DB_MAX_SAVE_FILENAME_LENGTH, NddsXDRSerializeSize_char()); /* name */
    size += NddsXDRSerializeSize_array(DB_MAX_REPLY_IDS, NddsXDRSerializeSize_int()); /* IDs */
    size += NddsXDRSerializeSize_int(); /* numRecords */
    return size;
}




bool_t
NddsXDRPrint_dbReply(dbReply *objp, char *desc, int indent)
{
    int i;
    for (i=0; i<indent; i++) { printf("  "); }
    printf("%s:\n", desc);

    if (!NddsXDRPrint_int(&objp->status, "status", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_dbRecord(&objp->record, "record", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_dbRecordBitMask(&objp->recordBitMask, "recordBitMask", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_array(objp->name, DB_MAX_SAVE_FILENAME_LENGTH, sizeof(char), (NddsXDRPrintFncType)NddsXDRPrint_char, "name", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_array(objp->IDs, DB_MAX_REPLY_IDS, sizeof(int), (NddsXDRPrintFncType)NddsXDRPrint_int, "IDs", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_int(&objp->numRecords, "numRecords", indent+1)) {
        return (FALSE);
    }
    return (TRUE);
}




bool_t
xdr_dbReply(XDR *xdrs, dbReply *objp)
{
    if (!xdr_int(xdrs, &objp->status)) {
    	return (FALSE);
    }
    if (!xdr_dbRecord(xdrs, &objp->record)) {
    	return (FALSE);
    }
    if (!xdr_dbRecordBitMask(xdrs, &objp->recordBitMask)) {
    	return (FALSE);
    }
    if (!xdr_vector(xdrs, (char *)objp->name, DB_MAX_SAVE_FILENAME_LENGTH, sizeof(char), xdr_char)) {
    	return (FALSE);
    }
    if (!xdr_vector(xdrs, (char *)objp->IDs, DB_MAX_REPLY_IDS, sizeof(int), xdr_int)) {
    	return (FALSE);
    }
    if (!xdr_int(xdrs, &objp->numRecords)) {
    	return (FALSE);
    }
    return (TRUE);
}




int NddsXDRSerializeSize_dbNotify()
{
    int size = 0;
    size += NddsXDRSerializeSize_int(); /* function */
    size += NddsXDRSerializeSize_dbRecord(); /* record */
    size += NddsXDRSerializeSize_dbRecordBitMask(); /* changed */
    return size;
}




bool_t
NddsXDRPrint_dbNotify(dbNotify *objp, char *desc, int indent)
{
    int i;
    for (i=0; i<indent; i++) { printf("  "); }
    printf("%s:\n", desc);

    if (!NddsXDRPrint_int(&objp->function, "function", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_dbRecord(&objp->record, "record", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_dbRecordBitMask(&objp->changed, "changed", indent+1)) {
        return (FALSE);
    }
    return (TRUE);
}




bool_t
xdr_dbNotify(XDR *xdrs, dbNotify *objp)
{
    if (!xdr_int(xdrs, &objp->function)) {
    	return (FALSE);
    }
    if (!xdr_dbRecord(xdrs, &objp->record)) {
    	return (FALSE);
    }
    if (!xdr_dbRecordBitMask(xdrs, &objp->changed)) {
    	return (FALSE);
    }
    return (TRUE);
}


/* ========================================================================
   dbRequestSerialize \- NDDS serialization method for dbRequest

   Required NDDS method to serialize an dbRequest into NDDSXDRStream 
   buffer.
   The data will be deserialized by the dbRequestDeserialize() function.

   The 'options' may be defined and used for customizing serialization
   for different situations. Often (as in this case) they are simply 
   ignored.
 */
RTIBool dbRequestSerialize(NDDSXDRStream nddsds, 
			   dbRequest *nddsdbRequest,
			   int options)
{
    return xdr_dbRequest(NddsXDRGetSerializingStream(nddsds),
			       nddsdbRequest);
}

/* ========================================================================
   dbRequestDeserialize \- NDDS deserialization method for dbRequest 
   
   Required NDDS method to deserialize the data from an NDDSXDRStream buffer.
   The data was serialized by the dbRequestSerialize() function.

   If outArray==NULL (null pointer), this function will create a
   dbRequest of the appropriate size to hold the data 
   (as required by NDDS).

   Returns the output array or NULL if an error occurred
 */
dbRequest *dbRequestDeserialize(dbRequest *nddsdbRequest,
				      NDDSXDRStream nddsds)
{
    int allocated = RTI_FALSE;

    if (nddsdbRequest == NULL) {
	allocated = RTI_TRUE;
	nddsdbRequest =(dbRequest *)calloc(1, sizeof(dbRequest));
    }

    if (!xdr_dbRequest(NddsXDRGetDeserializingStream(nddsds),
			     nddsdbRequest))  {
	if (allocated) {
	    free(nddsdbRequest);
	}
	return NULL;
    }
    
    return nddsdbRequest;
}

/* ========================================================================
   dbRequestPrint \- NDDS Print method for dbRequest objects

   Optional NDDS method to print the contents of an dbRequest.

   Note that if this method *must* handle the case where the object
   is NULL.
 */
dbRequest *dbRequestPrint(dbRequest *nddsdbRequest)
{
    /* Do not remove. dbRequestPrint must handle a NULL 
       dbRequest 
       */
    if (nddsdbRequest==NULL) {
	printf("dbRequest: (null)\n");
	return NULL;
    }

    /* Replace by custom code if desired */
    if (!NddsXDRPrint_dbRequest(nddsdbRequest, "dbRequest", 0)) {
	printf("NddsXDRPrintdbRequest() failed on %p\n", 
	       nddsdbRequest);
	return NULL;
    }

    /* Do not remove the return value */
    return nddsdbRequest;
}

/* ========================================================================
   dbRequestSerializeSize \- NDDS size method for dbRequest objects
 
   This optional NDDS method returns the maximum size of a dbRequest object.
   The purpose of this method is to allow NDDS to optimize its memory usage.
 
   Users must be very careful and return a size that is equal-to or larger 
   than the maximum dbRequest serialized. Please refer to NddsXdr(2) for
   functions to help determin the serialized size of basic types.

   If a -1 is returned then NDDS will default to a safe size, but will not
   be optimal.
 */
int dbRequestSerializeSize()
{
    return NddsXDRSerializeSize_dbRequest();
}


/* ========================================================================
   dbRequestAllocate \- NDDS Allocate method for dbRequest objects

   Optional NDDS method to allocate an NDDS object of type dbRequest.

   If registered within dbRequestNddsRegister(), this method will be 
   invoked as a result of pattern subscriptions. When the NDDS agent 
   subscribes to a publication that matches the requested pattern, it
   needs to create a new object of the corresponding type to hold the 
   updates when they come. 
   It is for this purpose that dbRequestAllocate() is used.

   This method is not always required because dbRequestDeserialize()
   is usually able to allocate the object itself. There are however
   some cases (notably strings) for which the allocation provided
   by dbRequestDeserialize() isn't sufficient. Registration
   of dbRequestAllocate() allows to override the default allocation
   provided by dbRequestDeserialize().

   If this method is to be used, it must passed to NddsTypeRegister()
   (in function dbRequestNddsRegister()) instead of the default
   NULL method.

   This routine gets passed the type and name of the object instance and
   the parameter provided by the user passed in the 
   NddsSubscriptionGroupSubscriptionAdd(3) call.
 */
dbRequest *dbRequestAllocate(const char *type, const char *name,
				   void *userParam)
{
    dbRequest *nddsdbRequest = NULL;

    nddsdbRequest = (dbRequest *)calloc(1, sizeof(*nddsdbRequest));
    {
	/* Add the custom allocation of entries in the structure here */
    }

    return nddsdbRequest;
}

/* ========================================================================
   dbRequestFree \- NDDS Free method for dbRequest objects

   Optional NDDS method to Free an NDDS object of type dbRequest.

   This method is not used in the current version of NDDS.
 */
RTIBool dbRequestFree(dbRequest *inst, const char *type, const char *name,
		      void *userParam)
{
    return RTI_TRUE;
}

/* ========================================================================
   dbRequestNddsRegister \- Install dbRequest type to NDDS
   
   This function will register an dbRequest type with NDDS.   
   Registration must happen before any reference to the dbRequest 
   type is given to NDDS.

   A description of the type dbRequest was written in a file
   named dbRequest.x (NOTE: the .x termination which is standard
   for this files is required.). This description uses the XDR language,
   which resembles "C"-like structure-type declarations. More information
   and examples on how to write these ".x" files can be found in the
   man page for 'nddsgen'.
 
   nddsgen was run on the dbMsgs.x file. See the man pages
   on nddsgen and dbMsgs for details.
 */
void dbRequestNddsRegister(void)
{
   NddsTypeRegister(dbRequestPublicationType,
	/*A #define in dbMsgs.h*/
		    (SerializeMethodType)dbRequestSerialize,
		    (DeserializeMethodType)dbRequestDeserialize,
		    (PrintMethodType)dbRequestPrint,
		    (AllocateMethodType)NULL,
		    (FreeMethodType)NULL,
		    (SerializeSizeMethodType)dbRequestSerializeSize);
}
/* ========================================================================
   dbReplySerialize \- NDDS serialization method for dbReply

   Required NDDS method to serialize an dbReply into NDDSXDRStream 
   buffer.
   The data will be deserialized by the dbReplyDeserialize() function.

   The 'options' may be defined and used for customizing serialization
   for different situations. Often (as in this case) they are simply 
   ignored.
 */
RTIBool dbReplySerialize(NDDSXDRStream nddsds, 
			   dbReply *nddsdbReply,
			   int options)
{
    return xdr_dbReply(NddsXDRGetSerializingStream(nddsds),
			       nddsdbReply);
}

/* ========================================================================
   dbReplyDeserialize \- NDDS deserialization method for dbReply 
   
   Required NDDS method to deserialize the data from an NDDSXDRStream buffer.
   The data was serialized by the dbReplySerialize() function.

   If outArray==NULL (null pointer), this function will create a
   dbReply of the appropriate size to hold the data 
   (as required by NDDS).

   Returns the output array or NULL if an error occurred
 */
dbReply *dbReplyDeserialize(dbReply *nddsdbReply,
				      NDDSXDRStream nddsds)
{
    int allocated = RTI_FALSE;

    if (nddsdbReply == NULL) {
	allocated = RTI_TRUE;
	nddsdbReply =(dbReply *)calloc(1, sizeof(dbReply));
    }

    if (!xdr_dbReply(NddsXDRGetDeserializingStream(nddsds),
			     nddsdbReply))  {
	if (allocated) {
	    free(nddsdbReply);
	}
	return NULL;
    }
    
    return nddsdbReply;
}

/* ========================================================================
   dbReplyPrint \- NDDS Print method for dbReply objects

   Optional NDDS method to print the contents of an dbReply.

   Note that if this method *must* handle the case where the object
   is NULL.
 */
dbReply *dbReplyPrint(dbReply *nddsdbReply)
{
    /* Do not remove. dbReplyPrint must handle a NULL 
       dbReply 
       */
    if (nddsdbReply==NULL) {
	printf("dbReply: (null)\n");
	return NULL;
    }

    /* Replace by custom code if desired */
    if (!NddsXDRPrint_dbReply(nddsdbReply, "dbReply", 0)) {
	printf("NddsXDRPrintdbReply() failed on %p\n", 
	       nddsdbReply);
	return NULL;
    }

    /* Do not remove the return value */
    return nddsdbReply;
}

/* ========================================================================
   dbReplySerializeSize \- NDDS size method for dbReply objects
 
   This optional NDDS method returns the maximum size of a dbReply object.
   The purpose of this method is to allow NDDS to optimize its memory usage.
 
   Users must be very careful and return a size that is equal-to or larger 
   than the maximum dbReply serialized. Please refer to NddsXdr(2) for
   functions to help determin the serialized size of basic types.

   If a -1 is returned then NDDS will default to a safe size, but will not
   be optimal.
 */
int dbReplySerializeSize()
{
    return NddsXDRSerializeSize_dbReply();
}


/* ========================================================================
   dbReplyAllocate \- NDDS Allocate method for dbReply objects

   Optional NDDS method to allocate an NDDS object of type dbReply.

   If registered within dbReplyNddsRegister(), this method will be 
   invoked as a result of pattern subscriptions. When the NDDS agent 
   subscribes to a publication that matches the requested pattern, it
   needs to create a new object of the corresponding type to hold the 
   updates when they come. 
   It is for this purpose that dbReplyAllocate() is used.

   This method is not always required because dbReplyDeserialize()
   is usually able to allocate the object itself. There are however
   some cases (notably strings) for which the allocation provided
   by dbReplyDeserialize() isn't sufficient. Registration
   of dbReplyAllocate() allows to override the default allocation
   provided by dbReplyDeserialize().

   If this method is to be used, it must passed to NddsTypeRegister()
   (in function dbReplyNddsRegister()) instead of the default
   NULL method.

   This routine gets passed the type and name of the object instance and
   the parameter provided by the user passed in the 
   NddsSubscriptionGroupSubscriptionAdd(3) call.
 */
dbReply *dbReplyAllocate(const char *type, const char *name,
				   void *userParam)
{
    dbReply *nddsdbReply = NULL;

    nddsdbReply = (dbReply *)calloc(1, sizeof(*nddsdbReply));
    {
	/* Add the custom allocation of entries in the structure here */
    }

    return nddsdbReply;
}

/* ========================================================================
   dbReplyFree \- NDDS Free method for dbReply objects

   Optional NDDS method to Free an NDDS object of type dbReply.

   This method is not used in the current version of NDDS.
 */
RTIBool dbReplyFree(dbReply *inst, const char *type, const char *name,
		      void *userParam)
{
    return RTI_TRUE;
}

/* ========================================================================
   dbReplyNddsRegister \- Install dbReply type to NDDS
   
   This function will register an dbReply type with NDDS.   
   Registration must happen before any reference to the dbReply 
   type is given to NDDS.

   A description of the type dbReply was written in a file
   named dbReply.x (NOTE: the .x termination which is standard
   for this files is required.). This description uses the XDR language,
   which resembles "C"-like structure-type declarations. More information
   and examples on how to write these ".x" files can be found in the
   man page for 'nddsgen'.
 
   nddsgen was run on the dbMsgs.x file. See the man pages
   on nddsgen and dbMsgs for details.
 */
void dbReplyNddsRegister(void)
{
   NddsTypeRegister(dbReplyPublicationType,
	/*A #define in dbMsgs.h*/
		    (SerializeMethodType)dbReplySerialize,
		    (DeserializeMethodType)dbReplyDeserialize,
		    (PrintMethodType)dbReplyPrint,
		    (AllocateMethodType)NULL,
		    (FreeMethodType)NULL,
		    (SerializeSizeMethodType)dbReplySerializeSize);
}
/* ========================================================================
   dbNotifySerialize \- NDDS serialization method for dbNotify

   Required NDDS method to serialize an dbNotify into NDDSXDRStream 
   buffer.
   The data will be deserialized by the dbNotifyDeserialize() function.

   The 'options' may be defined and used for customizing serialization
   for different situations. Often (as in this case) they are simply 
   ignored.
 */
RTIBool dbNotifySerialize(NDDSXDRStream nddsds, 
			   dbNotify *nddsdbNotify,
			   int options)
{
    return xdr_dbNotify(NddsXDRGetSerializingStream(nddsds),
			       nddsdbNotify);
}

/* ========================================================================
   dbNotifyDeserialize \- NDDS deserialization method for dbNotify 
   
   Required NDDS method to deserialize the data from an NDDSXDRStream buffer.
   The data was serialized by the dbNotifySerialize() function.

   If outArray==NULL (null pointer), this function will create a
   dbNotify of the appropriate size to hold the data 
   (as required by NDDS).

   Returns the output array or NULL if an error occurred
 */
dbNotify *dbNotifyDeserialize(dbNotify *nddsdbNotify,
				      NDDSXDRStream nddsds)
{
    int allocated = RTI_FALSE;

    if (nddsdbNotify == NULL) {
	allocated = RTI_TRUE;
	nddsdbNotify =(dbNotify *)calloc(1, sizeof(dbNotify));
    }

    if (!xdr_dbNotify(NddsXDRGetDeserializingStream(nddsds),
			     nddsdbNotify))  {
	if (allocated) {
	    free(nddsdbNotify);
	}
	return NULL;
    }
    
    return nddsdbNotify;
}

/* ========================================================================
   dbNotifyPrint \- NDDS Print method for dbNotify objects

   Optional NDDS method to print the contents of an dbNotify.

   Note that if this method *must* handle the case where the object
   is NULL.
 */
dbNotify *dbNotifyPrint(dbNotify *nddsdbNotify)
{
    /* Do not remove. dbNotifyPrint must handle a NULL 
       dbNotify 
       */
    if (nddsdbNotify==NULL) {
	printf("dbNotify: (null)\n");
	return NULL;
    }

    /* Replace by custom code if desired */
    if (!NddsXDRPrint_dbNotify(nddsdbNotify, "dbNotify", 0)) {
	printf("NddsXDRPrintdbNotify() failed on %p\n", 
	       nddsdbNotify);
	return NULL;
    }

    /* Do not remove the return value */
    return nddsdbNotify;
}

/* ========================================================================
   dbNotifySerializeSize \- NDDS size method for dbNotify objects
 
   This optional NDDS method returns the maximum size of a dbNotify object.
   The purpose of this method is to allow NDDS to optimize its memory usage.
 
   Users must be very careful and return a size that is equal-to or larger 
   than the maximum dbNotify serialized. Please refer to NddsXdr(2) for
   functions to help determin the serialized size of basic types.

   If a -1 is returned then NDDS will default to a safe size, but will not
   be optimal.
 */
int dbNotifySerializeSize()
{
    return NddsXDRSerializeSize_dbNotify();
}


/* ========================================================================
   dbNotifyAllocate \- NDDS Allocate method for dbNotify objects

   Optional NDDS method to allocate an NDDS object of type dbNotify.

   If registered within dbNotifyNddsRegister(), this method will be 
   invoked as a result of pattern subscriptions. When the NDDS agent 
   subscribes to a publication that matches the requested pattern, it
   needs to create a new object of the corresponding type to hold the 
   updates when they come. 
   It is for this purpose that dbNotifyAllocate() is used.

   This method is not always required because dbNotifyDeserialize()
   is usually able to allocate the object itself. There are however
   some cases (notably strings) for which the allocation provided
   by dbNotifyDeserialize() isn't sufficient. Registration
   of dbNotifyAllocate() allows to override the default allocation
   provided by dbNotifyDeserialize().

   If this method is to be used, it must passed to NddsTypeRegister()
   (in function dbNotifyNddsRegister()) instead of the default
   NULL method.

   This routine gets passed the type and name of the object instance and
   the parameter provided by the user passed in the 
   NddsSubscriptionGroupSubscriptionAdd(3) call.
 */
dbNotify *dbNotifyAllocate(const char *type, const char *name,
				   void *userParam)
{
    dbNotify *nddsdbNotify = NULL;

    nddsdbNotify = (dbNotify *)calloc(1, sizeof(*nddsdbNotify));
    {
	/* Add the custom allocation of entries in the structure here */
    }

    return nddsdbNotify;
}

/* ========================================================================
   dbNotifyFree \- NDDS Free method for dbNotify objects

   Optional NDDS method to Free an NDDS object of type dbNotify.

   This method is not used in the current version of NDDS.
 */
RTIBool dbNotifyFree(dbNotify *inst, const char *type, const char *name,
		      void *userParam)
{
    return RTI_TRUE;
}

/* ========================================================================
   dbNotifyNddsRegister \- Install dbNotify type to NDDS
   
   This function will register an dbNotify type with NDDS.   
   Registration must happen before any reference to the dbNotify 
   type is given to NDDS.

   A description of the type dbNotify was written in a file
   named dbNotify.x (NOTE: the .x termination which is standard
   for this files is required.). This description uses the XDR language,
   which resembles "C"-like structure-type declarations. More information
   and examples on how to write these ".x" files can be found in the
   man page for 'nddsgen'.
 
   nddsgen was run on the dbMsgs.x file. See the man pages
   on nddsgen and dbMsgs for details.
 */
void dbNotifyNddsRegister(void)
{
   NddsTypeRegister(dbNotifyPublicationType,
	/*A #define in dbMsgs.h*/
		    (SerializeMethodType)dbNotifySerialize,
		    (DeserializeMethodType)dbNotifyDeserialize,
		    (PrintMethodType)dbNotifyPrint,
		    (AllocateMethodType)NULL,
		    (FreeMethodType)NULL,
		    (SerializeSizeMethodType)dbNotifySerializeSize);
}
