/* mangen move \- NDDS methods for move type.
   banner = ==========
  
   This file is derived from code automatically generated by nddsgen.
 */

static char copyright_rti[] = 
"(c) Copyright, Real-Time Innovations, Inc., 1994.  All rights reserved.";

/*
DESCRIPTION:
  This file was automatically generated by the 'nddsgen' code generator from the
  XDR file move.x.  See the man pages on 'nddsgen' and 'NddsXDR'.

  This file was generated with the following steps:

(1) One or more XDR descriptions where written into a file named 
    move.x (NOTE: the .x termination which is standard for this 
    files is required.). This description uses the XDR language,
    which resembles "C"-like structure-type declarations. More information 
    and examples on how to write these ".x" files can be found in the 
    on-line html page for 'nddsgen'.

(2) 'nddsgen' was run on the move.x file. The command was:
    /usr/mwagner/nomad/src/messages/common/nddsgen move.x

    This created the move.c, and move.h.

(3) The move_stub.c is copied into move.c;
    if you pass "-replace" during nddsgen. This file contains the functions, 
    NddsTypeNameSeralize(), NddsTypeNameDeserialize(), and NddsTypeNamePrint() 
    for each NDDS type.

(4) The user may want to fill in the code for the NddsTypeNamePrint()
    function if they want NDDS to print the NddsTypeName automatically
    in certain situations. This isn't required.

(5) The file move.c also contains functions to register, and 
    test NDDS types.

SEE ALSO:
  nddsgen(1), NddsXDR(2), Ndds(2)
--------------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <rpc/types.h>
#include <rpc/xdr.h>

#include "move.h"


int NddsXDRSerializeSize_move()
{
    int size = 0;
    size += NddsXDRSerializeSize_double(); /* radius */
    size += NddsXDRSerializeSize_int(); /* pointTurnFlag */
    size += NddsXDRSerializeSize_double(); /* turnSpeed */
    size += NddsXDRSerializeSize_double(); /* turnDistance */
    size += NddsXDRSerializeSize_double(); /* translateSpeed */
    size += NddsXDRSerializeSize_double(); /* translateDistance */
    return size;
}




bool_t
NddsXDRPrint_move(move *objp, char *desc, int indent)
{
    int i;
    for (i=0; i<indent; i++) { printf("  "); }
    printf("%s:\n", desc);

    if (!NddsXDRPrint_double(&objp->radius, "radius", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_int(&objp->pointTurnFlag, "pointTurnFlag", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_double(&objp->turnSpeed, "turnSpeed", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_double(&objp->turnDistance, "turnDistance", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_double(&objp->translateSpeed, "translateSpeed", indent+1)) {
        return (FALSE);
    }
    if (!NddsXDRPrint_double(&objp->translateDistance, "translateDistance", indent+1)) {
        return (FALSE);
    }
    return (TRUE);
}




bool_t
xdr_move(XDR *xdrs, move *objp)
{
    if (!xdr_double(xdrs, &objp->radius)) {
    	return (FALSE);
    }
    if (!xdr_int(xdrs, &objp->pointTurnFlag)) {
    	return (FALSE);
    }
    if (!xdr_double(xdrs, &objp->turnSpeed)) {
    	return (FALSE);
    }
    if (!xdr_double(xdrs, &objp->turnDistance)) {
    	return (FALSE);
    }
    if (!xdr_double(xdrs, &objp->translateSpeed)) {
    	return (FALSE);
    }
    if (!xdr_double(xdrs, &objp->translateDistance)) {
    	return (FALSE);
    }
    return (TRUE);
}


/* ========================================================================
   moveSerialize \- NDDS serialization method for move

   Required NDDS method to serialize an move into NDDSXDRStream 
   buffer.
   The data will be deserialized by the moveDeserialize() function.

   The 'options' may be defined and used for customizing serialization
   for different situations. Often (as in this case) they are simply 
   ignored.
 */
RTIBool moveSerialize(NDDSXDRStream nddsds, 
			   move *nddsmove,
			   int options)
{
    return xdr_move(NddsXDRGetSerializingStream(nddsds),
			       nddsmove);
}

/* ========================================================================
   moveDeserialize \- NDDS deserialization method for move 
   
   Required NDDS method to deserialize the data from an NDDSXDRStream buffer.
   The data was serialized by the moveSerialize() function.

   If outArray==NULL (null pointer), this function will create a
   move of the appropriate size to hold the data 
   (as required by NDDS).

   Returns the output array or NULL if an error occurred
 */
move *moveDeserialize(move *nddsmove,
				      NDDSXDRStream nddsds)
{
    int allocated = RTI_FALSE;

    if (nddsmove == NULL) {
	allocated = RTI_TRUE;
	nddsmove =(move *)calloc(1, sizeof(move));
    }

    if (!xdr_move(NddsXDRGetDeserializingStream(nddsds),
			     nddsmove))  {
	if (allocated) {
	    free(nddsmove);
	}
	return NULL;
    }
    
    return nddsmove;
}

/* ========================================================================
   movePrint \- NDDS Print method for move objects

   Optional NDDS method to print the contents of an move.

   Note that if this method *must* handle the case where the object
   is NULL.
 */
move *movePrint(move *nddsmove)
{
    /* Do not remove. movePrint must handle a NULL 
       move 
       */
    if (nddsmove==NULL) {
	printf("move: (null)\n");
	return NULL;
    }

    /* Replace by custom code if desired */
    if (!NddsXDRPrint_move(nddsmove, "move", 0)) {
	printf("NddsXDRPrintmove() failed on %p\n", 
	       nddsmove);
	return NULL;
    }

    /* Do not remove the return value */
    return nddsmove;
}

/* ========================================================================
   moveSerializeSize \- NDDS size method for move objects
 
   This optional NDDS method returns the maximum size of a move object.
   The purpose of this method is to allow NDDS to optimize its memory usage.
 
   Users must be very careful and return a size that is equal-to or larger 
   than the maximum move serialized. Please refer to NddsXdr(2) for
   functions to help determin the serialized size of basic types.

   If a -1 is returned then NDDS will default to a safe size, but will not
   be optimal.
 */
int moveSerializeSize()
{
    return NddsXDRSerializeSize_move();
}


/* ========================================================================
   moveAllocate \- NDDS Allocate method for move objects

   Optional NDDS method to allocate an NDDS object of type move.

   If registered within moveNddsRegister(), this method will be 
   invoked as a result of pattern subscriptions. When the NDDS agent 
   subscribes to a publication that matches the requested pattern, it
   needs to create a new object of the corresponding type to hold the 
   updates when they come. 
   It is for this purpose that moveAllocate() is used.

   This method is not always required because moveDeserialize()
   is usually able to allocate the object itself. There are however
   some cases (notably strings) for which the allocation provided
   by moveDeserialize() isn't sufficient. Registration
   of moveAllocate() allows to override the default allocation
   provided by moveDeserialize().

   If this method is to be used, it must passed to NddsTypeRegister()
   (in function moveNddsRegister()) instead of the default
   NULL method.

   This routine gets passed the type and name of the object instance and
   the parameter provided by the user passed in the 
   NddsSubscriptionGroupSubscriptionAdd(3) call.
 */
move *moveAllocate(const char *type, const char *name,
				   void *userParam)
{
    move *nddsmove = NULL;

    nddsmove = (move *)calloc(1, sizeof(*nddsmove));
    {
	/* Add the custom allocation of entries in the structure here */
    }

    return nddsmove;
}

/* ========================================================================
   moveFree \- NDDS Free method for move objects

   Optional NDDS method to Free an NDDS object of type move.

   This method is not used in the current version of NDDS.
 */
RTIBool moveFree(move *inst, const char *type, const char *name,
		      void *userParam)
{
    return RTI_TRUE;
}

/* ========================================================================
   moveNddsRegister \- Install move type to NDDS
   
   This function will register an move type with NDDS.   
   Registration must happen before any reference to the move 
   type is given to NDDS.

   A description of the type move was written in a file
   named move.x (NOTE: the .x termination which is standard
   for this files is required.). This description uses the XDR language,
   which resembles "C"-like structure-type declarations. More information
   and examples on how to write these ".x" files can be found in the
   man page for 'nddsgen'.
 
   nddsgen was run on the move.x file. See the man pages
   on nddsgen and move for details.
 */
void moveNddsRegister(void)
{
   NddsTypeRegister(movePublicationType,
	/*A #define in move.h*/
		    (SerializeMethodType)moveSerialize,
		    (DeserializeMethodType)moveDeserialize,
		    (PrintMethodType)movePrint,
		    (AllocateMethodType)NULL,
		    (FreeMethodType)NULL,
		    (SerializeSizeMethodType)moveSerializeSize);
}
