#ifndef mplanner_h
#define mplanner_h

#include "commonTypes.h"
#include "nomadDimensions.h"
#include "nomadTransforms.h"
#include "libc.h"
#include "commonMsgTypes.h"
#include "tca/stdinDev.h"
#include "NDDS.h"
#include "nomadNddsDomain.h"
#include "nomadNddsMessages.h"

#include "mPlannerMsgs.h"
#include "navManMsgs.h"
#include "sensManMsgs.h"
#include "targetAcqMsgs.h"
#include "dbMsgs.h"
#include "posDerivedState.h"
#include "sensManDef.h"
#include "targetAcqDef.h"
#include "navManDef.h"
#include "mPlannerDef.h"
#include "navplan.h"
#include "SAS_ServiceNames.h"


typedef struct {
  PlanParams plan0;
  PlanParams plan1;
  PlanParams plan2;
  PlanParams plan3;
  PlanParams plan4;
  PlanParams simplan;
  struct sensManRequest* sensMsg;
  struct targetAcqRequest* targetMsg;
  int sendNavMsg;
  int sendNavSim;
  int sendSensMsg;
  int sendTargetMsg;
} TaskMessage;

typedef struct {
  struct mPlannerReport* message;
  int sendReportMsg; 
} missionReport;

typedef struct {
  int taskMode;
  int navPlannerStatus;
  float timeCost;
  float areaCovered ;
  float energyGen;
} PlannerInfo;


/* internal structs */
typedef struct sensor_list_t {
  int driver;
  int reqNum;
  struct sensor_list_t* next;
} sensor_list;

typedef struct target_list_t {
  int targetID;
  MP_POSE location;
  double timestamp;  /* time of last cost evaluation */
  float cost;        /* cost evaluation */
  int complete;      /* 1 if this target is done? */
  struct target_list_t* next;
} target_list_item;


/* Planning variables */
extern int PLAN_TIME;  /* time used in marking planning map */
extern char MPLAN[40];
extern char PMAPNAME[255];
extern char RecordSun[40];
extern planner_map PlanMap;
extern MP_POSE PlanningPose;

/* Time/date solar variables */
extern float ROB_LAT, ROB_LON, ROB_XAX; /* coords of DGPS base station */

/* Global variable tags for how nplanner runs */
extern int npVERBOSE;

/* Function prototypes */
double getdate(void);
int check_workspace(MP_POSE robot, MP_POSE target, int sensor);
void storeNavCommands(PlanParams request, PlanParams* plan);
RTIBool SensManCompleteCallback(NDDSRecvInfo* message);
RTIBool NavManCompleteCallback(NDDSRecvInfo* message);
RTIBool NddsPose(NDDSRecvInfo* nddsPose);
RTIBool TargetFound(NDDSRecvInfo* message);
RTIBool RouteTaskMode(NDDSObjectInstance reply, NDDSObjectInstance request,
		      void* userData);
void subscriberSetup(target_list_item* TargetList, MP_POSE* LastPose,
		     sensor_list* CurrSensList);
void clientSetup(NDDSClient* SensManClient, NDDSClient* TargetAcqClient,
		 NDDSClient* NavManClient);
void serverSetup(TaskMessage* newMessage);

#endif /* mplanner_h*/


