/* FILE: mPlannerDef.h
   CREATED: 7/23/99
   AUTHOR: Kim Shillcutt 
   DESCRIPTION: This file contains definitions used by the mission planner,
     navigation manager, and other software that communicates with mPlanner.
*/

#ifndef __M_PLANNER_DEF_H__
#define __M_PLANNER_DEF_H__

/* for mPlannerRequest.planningMode */
typedef enum {
  MP_COMMAND_TASK,
  MP_SIMULATE_TASK
} M_PLANNER_MODE_t;

/* for mPlannerRequest.type */
typedef enum {
  MP_TYPE_SENSOR,
  MP_TYPE_NAVIGATE,
  MP_TYPE_AUTONOMOUS
} M_PLANNER_TYPE_t;

/* for mPlannerReply.status */
typedef enum {
  MP_STATUS_RCVD,
  MP_STATUS_BUSY,
  MP_STATUS_ERROR
} M_PLANNER_STATUS_t;


#endif
