/* FILE: dbDef.h
   CREATED: 4/12/99
   AUTHOR: Michael Wagner

   DESCRIPTION: This file defines types used with the database. 
*/

#ifndef __DB_DEF_H__
#define __DB_DEF_H__

#include "dbRecordDef.h"

#define DB_MAX_SAVE_FILENAME_LENGTH 64
#define DB_MAX_RECORD_OPTIONAL_DATA MAX_OPTIONAL_DATA_SIZE
#define DB_MAX_REPLY_IDS 32

/* Possible dbRecordBitMask field values. */
typedef enum {
  DB_UNALTERED,
  DB_ALTERED,
  DB_SEARCH_AND, /* Used for AND'ing search criteria */
  DB_SEARCH_OR   /* Used for OR'ing search criteria */
} DB_RECORD_BIT_MASK_VAL;

/* Database reply statuses for dbRequest messages. */
typedef enum {
  DB_INSERT_ERROR = -1,
  DB_OK = 0,
  DB_INVALID_ID,
  DB_PUT_ERROR,
  DB_SEARCH_FAIL,
  DB_SAVE_ERROR,
  DB_RESTORE_ERROR,
  DB_ARCHIVE_ERROR,
  DB_SM_DRIVER_REG_DUPLICATE_ERROR,
  DB_SM_DRIVER_REG_LIMIT_ERROR,
  DB_SM_DRIVER_REG_NAME_ERROR,
  DB_GET_SM_DRIVER_NAME_ERROR,
  DB_DID_NOT_RESPOND_ERROR,
  DB_ERROR  /* A generic error */
} DB_REPLY_STATUS;

/* Database functions. */  
typedef enum {
  DB_INSERT_FUNCTION,
  DB_INSERT_MULTI_FUNCTION,
  DB_GET_FUNCTION,
  DB_PUT_FUNCTION,
  DB_SEARCH_FUNCTION,
  DB_SEARCH_MULTI_FUNCTION,
  DB_SAVE_FUNCTION,
  DB_RESTORE_FUNCTION,
  DB_ARCHIVE_FUNCTION,
  DB_SM_DRIVER_REG_FUNCTION,
  DB_GET_SM_DRIVER_NAME_FUNCTION,
  DB_GET_NUM_RECORDS_FUNCTION
} DB_FUNCTION;


#endif /* __DB_DEF_H__ */
