#!/usr/bin/wish -f

set numSensors 2
set numReadings 2

set qFont   "-adobe-helvetica-bold-r-normal--10-*";
set hFont   "-adobe-helvetica-bold-r-normal--14-*";

pack [canvas .c] -fill both

frame .c.fLeft
frame .c.fRight

# The left side labels
label .c.fLeft.targetID -text "Target ID:" -font $qFont
label .c.fLeft.dgps -text "DGPS location estimate (x, y, z): " -font $qFont
label .c.fLeft.timeStamp -text "Acquisition time stamp: " -font $qFont
label .c.fLeft.probClassMembers -text "Class members probabilities: " -font $qFont
pack .c.fLeft.targetID -in .c.fLeft
pack .c.fLeft.dgps -in .c.fLeft
pack .c.fLeft.timeStamp -in .c.fLeft
pack .c.fLeft.probClassMembers -in .c.fLeft
for {set i 0} {$i < $numSensors} {incr i} {
    frame .c.fLeft.sensor$i -borderwidth 2 -highlightthickness 2
    label .c.fLeft.sensor$i.title -text "Sensor #$i" -font $qFont
    label .c.fLeft.sensor$i.estInfoGain -text "Estimated info gain: " -font $qFont
    pack .c.fLeft.sensor$i -in .c.fLeft
    pack .c.fLeft.sensor$i.title -in .c.fLeft.sensor$i
    pack .c.fLeft.sensor$i.estInfoGain -in .c.fLeft.sensor$i
    for {set j 0} {$j < $numReadings} {incr j} {
	frame .c.fLeft.sensor$i.reading$j -borderwidth 1 -highlightthickness 1
	label .c.fLeft.sensor$i.reading$j.title -text "Reading #$j" -font $qFont
	label .c.fLeft.sensor$i.reading$j.filename -text "Data filename: " -font $qFont
	label .c.fLeft.sensor$i.reading$j.timeStamp -text "Reading time stamp: " -font $qFont
	label .c.fLeft.sensor$i.reading$j.robotPosition -text "Robot DGPS position at reading (x, y, z): " -font $qFont
	label .c.fLeft.sensor$i.reading$j.robotPose -text "Robot pose at reading (r, p, y): " -font $qFont
	label .c.fLeft.sensor$i.reading$j.featureVector -text "Feature vector: " -font $qFont
	label .c.fLeft.sensor$i.reading$j.optionalData -text "Optional data: " -font $qFont
	pack .c.fLeft.sensor$i.reading$j -in .c.fLeft.sensor$i
	pack .c.fLeft.sensor$i.reading$j.title -in .c.fLeft.sensor$i.reading$j
	pack .c.fLeft.sensor$i.reading$j.filename -in .c.fLeft.sensor$i.reading$j
	pack .c.fLeft.sensor$i.reading$j.timeStamp -in .c.fLeft.sensor$i.reading$j
	pack .c.fLeft.sensor$i.reading$j.robotPosition -in .c.fLeft.sensor$i.reading$j
	pack .c.fLeft.sensor$i.reading$j.robotPose -in .c.fLeft.sensor$i.reading$j
	pack .c.fLeft.sensor$i.reading$j.featureVector -in .c.fLeft.sensor$i.reading$j
	pack .c.fLeft.sensor$i.reading$j.optionalData -in .c.fLeft.sensor$i.reading$j
    }
}

# The right side text entry boxes
entry .c.fRight.targetID 

.c.fRight.targetID insert 0 55

pack .c.fLeft -side left -fill y
pack .c.fRight -side right -fill y

