/* A class that helps access the SAS database server. 
   Please #define DB_CLIENT_MAIN if you'd like to run the
   main() function in dbClient.cpp. */

#ifndef __DB_CLIENT_H__
#define __DB_CLIENT_H__

#include "dbMsgs.h"
#include "dbRecord.h"
#include "dbRecordDef.h"
#include "dbDef.h"
#include "matrix/vector.h"
#include "queue.h"

class dbClient {
 public:
  dbClient();
  dbClient(int verbose);
  ~dbClient();

  /* Returns 1 on success, 0 on failure */
  int startNDDS();
  int startNDDS(int verbose);

  /* Returns 1 if there is new data, 0 otherwise */
  int databaseHasNewInfo(dbRecord &record);
  
  /* These methods are used to interface with the database, and they
     return DB_REPLY_STATUS (see dbDef.h). */
  int getRecord(int targetID, dbRecord &record);
  int putRecord(int targetID, const dbRecord &record, const dbRecordBitMask &bitMask); /* targetID is a bit redundant, as it's also in the record */
  int putRecord(const dbRecord &record, const dbRecordBitMask &bitMask);
  int insertRecord(int &newID);
  int insertRecords(int numRecords, int &firstID, int &lastID);
  int driverRegister(char *driverName);
  int getDriverName(int driverNum, char *driverName);
  int getNumRecords(int &num);
  int saveDB(char *filename);
  int restoreDB(char *filename);
  int archiveDB(char *filename);

  void displayRecord(const dbRecord &record);

  /* This will run a user interface. It will return when the user selects option 'q' */
  void runUI();

 private:
  int verbose;
  dbNotify *dbNotifyRecvMsg, *dbNotifySendMsg;
  NDDSSubscription dbNotifySub;
  NDDSPublication dbNotifyPub;
  dbRequest *dbRequestMsg;
  dbReply *dbReplyMsg;
  NDDSClient dbClient;
  NDDSClientReplyStatus dbClientStatus;
  queue<dbNotify *> *q;
};  

#endif /* __DB_CLIENT_H__ */
