/* FILE: queue.h
   AUTHOR: Michael Wagner
   CREATED 5/3/99
   DESCRIPTION: This file defines a queue object. Code is used from 
     "C++ Primer" by Stanley B. Lippman, Addison Wesley Publishing Company.
*/

#ifndef __QUEUE_H__
#define __QUEUE_H__

template <class T> class queueItem;
template <class Type>
class queue {
 public:
  queue() {front = back = 0; num = 0;}
  ~queue() {
    while(isEmpty() != true) {
      (void) remove();
    }
    num = 0;
  }

  Type remove() {
    if(isEmpty() == true) {
      return((Type)NULL);
    } 
    
    queueItem<Type> *pt = front;
    front = front->next;
    Type retVal = pt->item;
    delete pt;
    if(num-- < 0) {num = 0;}
    return(retVal);
  }

  Type peek(int index) {
    if(isEmpty() == true) {
      return((Type)NULL);
    }
    
    queueItem<Type> *pt = front;
    for(int i=0; i < index; i++) {
      pt = pt->next;
    }
    return(pt->item);
  }

  void add(const Type &val) {
    // Allocate a new queueItem object
    queueItem<Type> *pt = new queueItem<Type>(val);
    
    if(isEmpty()) {
      front = back = pt;
    } else {
      back->next = pt;
      back = pt;
    }

    num++;
  }
  
  int isEmpty() {
    return num == 0 ? 1 : 0;
  }

  int numElements() {
    return(num);
  }

 private:
  int num;
  
  queueItem<Type> *front;
  queueItem<Type> *back;
};

template <class Type>
class queueItem {
  friend class queue<Type>;
 public:
  queueItem(Type val) { item = val; }
 private:
  Type item;
  queueItem *next;
};


#endif /* __QUEUE_H__ */
