#ifndef __PUBLISHER_THREAD_H__
#define __PUBLISHER_THREAD_H__

#include <pthread.h>
#include "telemetryMsgs.h"

typedef enum {
  PUBLISHER_THREAD_START,
  PUBLISHER_THREAD_STOP
} PUBLISHER_THREAD_STATE;

#define TELEMETRY_DEFAULT_PERIOD 2 /* sec */
#define TELEMETRY_PUBLISHER_PERSISTANCE 15.0f
#define TELEMETRY_PUBLISHER_STRENGTH 10.0f

class publisherThreadData {
 public:
  publisherThreadData();

  // Pointers used inside the thread to communicate to the wrapper class.
  int threadDone;
  PUBLISHER_THREAD_STATE publisherThreadState;
  
  // Data passed to the thread on startup.
  float period;
};


class publisherThread {
 public:
  publisherThread(float period, publisherThreadData *param);
  ~publisherThread();

  void start();
  void stop();
  PUBLISHER_THREAD_STATE getState();

 private:
  void produceTelemetry();
  pthread_t *telThread;
  publisherThreadData *threadParam;

  // Virtual classes that must be implemented according to specific telemetry messages.
  virtual void registerNddsMsgs() = 0;
  virtual NDDSPublication createNddsPublication() = 0;
};


#endif /* __PUBLISHER_THREAD_H__ */
